/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocationIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.BaseBlockEncoder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public final class RemoveSinkStates
extends BaseBlockEncoder<IcfgLocation> {
    private final BiPredicate<IIcfg<?>, IcfgLocation> mFunHasToBePreserved;

    public RemoveSinkStates(IUltimateServiceProvider iUltimateServiceProvider, BiPredicate<IIcfg<?>, IcfgLocation> biPredicate, BlockEncodingBacktranslator blockEncodingBacktranslator, ILogger iLogger) {
        super(iLogger, iUltimateServiceProvider, blockEncodingBacktranslator);
        this.mFunHasToBePreserved = biPredicate;
    }

    @Override
    protected BasicIcfg<IcfgLocation> createResult(BasicIcfg<IcfgLocation> basicIcfg) {
        List<IcfgLocation> list = this.collectInitialSinks((IIcfg<?>)basicIcfg);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Collected " + list.size() + " initial sink states:"));
            list.stream().forEach(arg_0 -> ((ILogger)this.mLogger).debug(arg_0));
        }
        this.disconnectSinks((IIcfg<?>)basicIcfg, list);
        this.removeDisconnectedLocations(basicIcfg);
        this.mLogger.info((Object)("Removed " + this.mRemovedEdges + " edges and " + this.mRemovedLocations + " locations by removing sink states"));
        return basicIcfg;
    }

    private List<IcfgLocation> collectInitialSinks(IIcfg<?> iIcfg) {
        IcfgLocationIterator icfgLocationIterator = new IcfgLocationIterator(iIcfg);
        return icfgLocationIterator.asStream().filter(icfgLocation -> this.isSink(iIcfg, (IcfgLocation)icfgLocation)).collect(Collectors.toList());
    }

    private void disconnectSinks(IIcfg<?> iIcfg, List<IcfgLocation> list) {
        ArrayDeque<IcfgLocation> arrayDeque = new ArrayDeque<IcfgLocation>(list);
        while (!arrayDeque.isEmpty()) {
            IcfgLocation icfgLocation = (IcfgLocation)arrayDeque.removeFirst();
            assert (this.isSink(iIcfg, icfgLocation));
            arrayDeque.addAll(this.disconnectSink(iIcfg, icfgLocation));
        }
    }

    private List<IcfgLocation> disconnectSink(IIcfg<?> iIcfg, IcfgLocation icfgLocation) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Removing sink " + String.valueOf(icfgLocation)));
        }
        ArrayList arrayList = new ArrayList(icfgLocation.getIncomingEdges());
        ArrayList<IcfgLocation> arrayList2 = new ArrayList<IcfgLocation>();
        for (IcfgEdge icfgEdge : arrayList) {
            IcfgLocation icfgLocation2 = (IcfgLocation)icfgEdge.getSource();
            icfgEdge.disconnectSource();
            icfgEdge.disconnectTarget();
            ++this.mRemovedEdges;
            if (!this.isSink(iIcfg, icfgLocation2)) continue;
            arrayList2.add(icfgLocation2);
        }
        return arrayList2;
    }

    private boolean isSink(IIcfg<?> iIcfg, IcfgLocation icfgLocation) {
        return icfgLocation.getOutgoingEdges().isEmpty() && !this.mFunHasToBePreserved.test(iIcfg, icfgLocation);
    }

    @Override
    public boolean isGraphStructureChanged() {
        return this.mRemovedEdges > 0 || this.mRemovedLocations > 0;
    }
}

