/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.DefaultIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.TermTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BidirectionalMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TransferrerWithVariableCache {
    private final ManagedScript mTargetScript;
    private final TermTransferrer mTransferrer;
    private final TermTransferrer mBackTransferrer;
    private final BidirectionalMap<IProgramVarOrConst, IProgramVarOrConst> mCache = new BidirectionalMap();

    public TransferrerWithVariableCache(Script script, ManagedScript managedScript) {
        this.mTargetScript = managedScript;
        BidirectionalMap bidirectionalMap = new BidirectionalMap();
        this.mTransferrer = new TermTransferrer(script, managedScript.getScript(), (Map)bidirectionalMap, false);
        this.mBackTransferrer = new TermTransferrer(managedScript.getScript(), script, (Map)bidirectionalMap.inverse(), false);
    }

    public IProgramVar transferProgramVar(IProgramVar iProgramVar) {
        return (IProgramVar)this.mCache.computeIfAbsent((Object)iProgramVar, iProgramVarOrConst -> ProgramVarUtils.transferProgramVar(this.mTransferrer, iProgramVar));
    }

    public IProgramConst transferProgramConst(IProgramConst iProgramConst) {
        return (IProgramConst)this.mCache.computeIfAbsent((Object)iProgramConst, iProgramVarOrConst -> ProgramVarUtils.transferProgramConst(this.mTransferrer, iProgramConst));
    }

    public Set<IProgramVar> transferVariables(Set<IProgramVar> set) {
        return set.stream().map(this::transferProgramVar).collect(Collectors.toSet());
    }

    public UnmodifiableTransFormula transferTransFormula(UnmodifiableTransFormula unmodifiableTransFormula) {
        return TransFormulaBuilder.transferTransformula(this, this.mTargetScript, unmodifiableTransFormula, true);
    }

    public <T extends Term> T transferTerm(T t) {
        return (T)this.mTransferrer.transform(t);
    }

    public IIcfgSymbolTable transferSymbolTable(IIcfgSymbolTable iIcfgSymbolTable, Set<String> set) {
        DefaultIcfgSymbolTable defaultIcfgSymbolTable = new DefaultIcfgSymbolTable();
        for (IProgramNonOldVar object : iIcfgSymbolTable.getGlobals()) {
            defaultIcfgSymbolTable.add(this.transferProgramVar(object));
        }
        for (String string : set) {
            for (ILocalProgramVar iLocalProgramVar : iIcfgSymbolTable.getLocals(string)) {
                defaultIcfgSymbolTable.add(this.transferProgramVar(iLocalProgramVar));
            }
        }
        for (IProgramConst iProgramConst : iIcfgSymbolTable.getConstants()) {
            defaultIcfgSymbolTable.add(this.transferProgramConst(iProgramConst));
        }
        defaultIcfgSymbolTable.finishConstruction();
        return defaultIcfgSymbolTable;
    }

    public TermTransferrer getTransferrer() {
        return this.mTransferrer;
    }

    public <T extends Term> T backTransferTerm(T t) {
        return (T)this.mBackTransferrer.transform(t);
    }

    public IProgramVar getOriginalProgramVar(IProgramVar iProgramVar) {
        return (IProgramVar)this.mCache.inverse().get((Object)iProgramVar);
    }
}

