/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.modelwalker;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.modelwalker.IWalker;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IObserver;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.LinkedList;
import java.util.List;

public abstract class BaseWalker
implements IWalker {
    protected ILogger mLogger;
    protected List<IObserver> mObservers = new LinkedList<IObserver>();

    protected BaseWalker(ILogger iLogger) {
        this.mLogger = iLogger;
    }

    @Override
    public boolean addObserver(IObserver iObserver) {
        return this.mObservers.add(iObserver);
    }

    @Override
    public boolean removeObserver(IObserver iObserver) {
        return this.mObservers.remove(iObserver);
    }

    @Override
    public void removeAllObservers() {
        this.mObservers.clear();
    }

    @Override
    public boolean containsObserver(IObserver iObserver) {
        return this.mObservers.contains(iObserver);
    }

    @Override
    public void run(IElement iElement) throws Throwable {
        if (iElement != null) {
            for (IObserver iObserver : this.mObservers) {
                this.runObserver(iElement, iObserver);
            }
        }
    }

    private void runObserver(IElement iElement, IObserver iObserver) throws Throwable {
        if (iObserver instanceof IUnmanagedObserver) {
            this.runObserver(iElement, (IUnmanagedObserver)iObserver);
        } else {
            this.mLogger.error((Object)"Illegal observer type supplied, aborting...");
        }
    }

    protected abstract void runObserver(IElement var1, IUnmanagedObserver var2) throws Throwable;
}

