/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness;

import de.uni_freiburg.informatik.ultimate.acsl.parser.ACSLSyntaxErrorException;
import de.uni_freiburg.informatik.ultimate.acsl.parser.Parser;
import de.uni_freiburg.informatik.ultimate.boogie.StatementFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AtomicStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryModelDeclarations;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.UnsupportedSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.IExtractedWitnessEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class ExtractedGhostUpdate
implements IExtractedWitnessEntry {
    private final IASTNode mMatchedAstNode;
    private final String mStatement;

    public ExtractedGhostUpdate(String string, String string2, IASTNode iASTNode) {
        this.mStatement = String.format("%s = %s;", string, string2);
        this.mMatchedAstNode = iASTNode;
    }

    private int getStartline() {
        return this.mMatchedAstNode.getFileLocation().getStartingLineNumber();
    }

    private int getEndline() {
        return this.mMatchedAstNode.getFileLocation().getEndingLineNumber();
    }

    public IASTNode getRelatedAstNode() {
        return this.mMatchedAstNode;
    }

    public String toString() {
        return "ghost_update [L" + this.getStartline() + "-L" + this.getEndline() + "] " + this.mStatement;
    }

    protected ExpressionResult instrument(ILocation iLocation, IDispatcher iDispatcher) {
        ACSLNode aCSLNode = null;
        try {
            aCSLNode = Parser.parseComment((String)("lstart\n ghost " + this.mStatement), (int)this.getStartline(), (int)1);
        }
        catch (ACSLSyntaxErrorException aCSLSyntaxErrorException) {
            throw new UnsupportedSyntaxException(iLocation, aCSLSyntaxErrorException.getMessageText());
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
        return (ExpressionResult)iDispatcher.dispatch(aCSLNode, this.mMatchedAstNode);
    }

    private String getNameOfCalledFunction() {
        IASTExpression iASTExpression;
        IASTExpression iASTExpression2;
        if (this.mMatchedAstNode instanceof IASTExpression) {
            iASTExpression2 = (IASTExpression)this.mMatchedAstNode;
        } else if (this.mMatchedAstNode instanceof IASTExpressionStatement) {
            iASTExpression2 = ((IASTExpressionStatement)this.mMatchedAstNode).getExpression();
        } else {
            return null;
        }
        if (iASTExpression2 instanceof IASTFunctionCallExpression && (iASTExpression = ((IASTFunctionCallExpression)iASTExpression2).getFunctionNameExpression()) instanceof IASTIdExpression) {
            return ((IASTIdExpression)iASTExpression).getName().toString();
        }
        return null;
    }

    private static List<Statement> annotateAtomicCall(ILocation iLocation, List<Statement> list, List<Statement> list2, String string) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        boolean bl = false;
        for (Statement statement2 : list) {
            if (bl || !(statement2 instanceof AtomicStatement)) {
                arrayList.add(statement2);
                continue;
            }
            Statement[] statementArray = ((AtomicStatement)statement2).getBody();
            if (Arrays.stream(statementArray).anyMatch(statement -> statement instanceof CallStatement && ((CallStatement)statement).getMethodName().equals(string))) {
                bl = true;
                arrayList.add((Statement)StatementFactory.constructAtomicStatement((ILocation)iLocation, Stream.concat(list2.stream(), Arrays.stream(statementArray))));
                continue;
            }
            arrayList.add(statement2);
        }
        if (!bl) {
            throw new UnsupportedOperationException("No statement found to annotate with the expected ghost update");
        }
        return arrayList;
    }

    private static List<Statement> annotateFork(ILocation iLocation, List<Statement> list, List<Statement> list2) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        boolean bl = false;
        for (Statement statement : list) {
            if (!bl && statement instanceof ForkStatement) {
                bl = true;
                arrayList.add((Statement)StatementFactory.constructAtomicStatement((ILocation)iLocation, list2));
            }
            arrayList.add(statement);
        }
        if (!bl) {
            throw new UnsupportedOperationException("No statement found to annotate with the expected ghost update");
        }
        return arrayList;
    }

    @Override
    public ExpressionResult transform(ILocation iLocation, IDispatcher iDispatcher, ExpressionResult expressionResult) {
        String string = this.getNameOfCalledFunction();
        if (string == null) {
            throw new UnsupportedOperationException("The following statement is not yet supported for ghost updates: " + String.valueOf(iLocation));
        }
        ExpressionResult expressionResult2 = this.instrument(iLocation, iDispatcher);
        switch (string) {
            case "__VERIFIER_atomic_begin": {
                return new ExpressionResultBuilder(expressionResult).addAllExceptLrValue(expressionResult2).build();
            }
            case "__VERIFIER_atomic_end": {
                return new ExpressionResultBuilder(expressionResult2).addAllExceptLrValue(expressionResult).build();
            }
            case "pthread_mutex_lock": {
                return new ExpressionResultBuilder(expressionResult).addAllExceptLrValueAndStatements(expressionResult2).resetStatements(ExtractedGhostUpdate.annotateAtomicCall(iLocation, expressionResult.getStatements(), expressionResult2.getStatements(), MemoryModelDeclarations.ULTIMATE_PTHREADS_MUTEX_LOCK.getName())).build();
            }
            case "pthread_mutex_unlock": 
            case "pthread_cond_wait": {
                return new ExpressionResultBuilder(expressionResult).addAllExceptLrValueAndStatements(expressionResult2).resetStatements(ExtractedGhostUpdate.annotateAtomicCall(iLocation, expressionResult.getStatements(), expressionResult2.getStatements(), MemoryModelDeclarations.ULTIMATE_PTHREADS_MUTEX_UNLOCK.getName())).build();
            }
            case "pthread_rwlock_rdlock": {
                return new ExpressionResultBuilder(expressionResult).addAllExceptLrValueAndStatements(expressionResult2).resetStatements(ExtractedGhostUpdate.annotateAtomicCall(iLocation, expressionResult.getStatements(), expressionResult2.getStatements(), MemoryModelDeclarations.ULTIMATE_PTHREADS_RWLOCK_READLOCK.getName())).build();
            }
            case "pthread_rwlock_wrlock": {
                return new ExpressionResultBuilder(expressionResult).addAllExceptLrValueAndStatements(expressionResult2).resetStatements(ExtractedGhostUpdate.annotateAtomicCall(iLocation, expressionResult.getStatements(), expressionResult2.getStatements(), MemoryModelDeclarations.ULTIMATE_PTHREADS_RWLOCK_WRITELOCK.getName())).build();
            }
            case "pthread_rwlock_unlock": {
                return new ExpressionResultBuilder(expressionResult).addAllExceptLrValueAndStatements(expressionResult2).resetStatements(ExtractedGhostUpdate.annotateAtomicCall(iLocation, expressionResult.getStatements(), expressionResult2.getStatements(), MemoryModelDeclarations.ULTIMATE_PTHREADS_RWLOCK_UNLOCK.getName())).build();
            }
            case "pthread_create": {
                return new ExpressionResultBuilder(expressionResult).addAllExceptLrValueAndStatements(expressionResult2).resetStatements(ExtractedGhostUpdate.annotateFork(iLocation, expressionResult.getStatements(), expressionResult2.getStatements())).build();
            }
        }
        throw new UnsupportedOperationException("The following statement is not yet supported for ghost updates: " + String.valueOf(iLocation));
    }
}

