/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder.independence;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IndependenceResultAggregator;
import de.uni_freiburg.informatik.ultimate.util.statistics.AbstractStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.PrettyPrint;
import java.util.function.Supplier;

public class IndependenceStatisticsDataProvider
extends AbstractStatisticsDataProvider {
    public static final String INDEPENDENCE_QUERIES = "Independence Queries";
    public static final String UNDERLYING_RELATION = "Statistics on underlying relation";
    public static final String UNDERLYING_RELATIONS = "Statistics on underlying relations";
    private final IndependenceResultAggregator.Counter mQueryCounter = new IndependenceResultAggregator.Counter();

    public IndependenceStatisticsDataProvider(Class<?> clazz) {
        this.declareCounter(clazz.getSimpleName() + ".Independence Queries", () -> this.mQueryCounter);
    }

    public IndependenceStatisticsDataProvider(Class<?> clazz, IIndependenceRelation<?, ?> iIndependenceRelation) {
        this(clazz);
        this.forward(clazz.getSimpleName() + ".Statistics on underlying relation", iIndependenceRelation::getStatistics);
    }

    public <S, L> IndependenceStatisticsDataProvider(Class<?> clazz, Iterable<IIndependenceRelation<S, L>> iterable) {
        this(clazz);
        this.forwardAll(clazz.getSimpleName() + ".Statistics on underlying relations", iterable, IIndependenceRelation::getStatistics);
    }

    protected final void declareCounter(String string2, Supplier<IndependenceResultAggregator.Counter> supplier) {
        this.declare(string2, supplier::get, (object, object2) -> IndependenceResultAggregator.Counter.sum((IndependenceResultAggregator.Counter)object, (IndependenceResultAggregator.Counter)object2), (string, object) -> PrettyPrint.keyColonData((String)string, (Object)((IndependenceResultAggregator.Counter)object).print(Object::toString)));
    }

    public IndependenceResultAggregator.Counter getQueries() {
        return this.mQueryCounter;
    }

    public void reportQuery(IIndependenceRelation.Dependence dependence, boolean bl) {
        this.mQueryCounter.increment(dependence, bl);
    }

    public void reportIndependentQuery(boolean bl) {
        this.mQueryCounter.increment(IIndependenceRelation.Dependence.INDEPENDENT, bl);
    }

    public void reportDependentQuery(boolean bl) {
        this.mQueryCounter.increment(IIndependenceRelation.Dependence.DEPENDENT, bl);
    }

    public void reportUnknownQuery(boolean bl) {
        this.mQueryCounter.increment(IIndependenceRelation.Dependence.UNKNOWN, bl);
    }
}

