/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.internal.InternalPolicy;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageFileNameProvider;

class FileImageDescriptor
extends ImageDescriptor
implements IAdaptable {
    private static final Pattern XPATH_PATTERN = Pattern.compile("(\\d+)x(\\d+)");
    private final Class<?> location;
    private final String name;

    FileImageDescriptor(Class<?> clazz, String filename) {
        super(true);
        this.location = clazz;
        this.name = filename;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FileImageDescriptor)) {
            return false;
        }
        FileImageDescriptor other = (FileImageDescriptor)o;
        return Objects.equals(this.location, other.location) && Objects.equals(this.name, other.name);
    }

    @Override
    public ImageData getImageData(int zoom) {
        InputStream in = this.getStream(zoom);
        if (in != null) {
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try (BufferedInputStream stream = new BufferedInputStream(in);){
                    return new ImageData((InputStream)stream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SWTException e) {
                if (e.code != 40) {
                    throw e;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private InputStream getStream(int zoom) {
        if (zoom == 100) {
            return this.getStream(this.name);
        }
        InputStream xstream = this.getStream(FileImageDescriptor.getxName(this.name, zoom));
        if (xstream != null) {
            return xstream;
        }
        InputStream xpath = this.getStream(FileImageDescriptor.getxPath(this.name, zoom));
        if (xpath != null) {
            return xpath;
        }
        return null;
    }

    private InputStream getStream(String fileName) {
        if (fileName != null) {
            if (this.location != null) {
                return this.location.getResourceAsStream(fileName);
            }
            try {
                return new FileInputStream(fileName);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    static String getxPath(String name, int zoom) {
        Matcher matcher = XPATH_PATTERN.matcher(name);
        if (matcher.find()) {
            try {
                int currentWidth = Integer.parseInt(matcher.group(1));
                int desiredWidth = Math.round((float)zoom / 100.0f * (float)currentWidth);
                int currentHeight = Integer.parseInt(matcher.group(2));
                int desiredHeight = Math.round((float)zoom / 100.0f * (float)currentHeight);
                String lead = name.substring(0, matcher.start(1));
                String tail = name.substring(matcher.end(2));
                return lead + desiredWidth + "x" + desiredHeight + tail;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    static String getxName(String name, int zoom) {
        int dot = name.lastIndexOf(46);
        if (dot != -1 && (zoom == 150 || zoom == 200)) {
            String lead = name.substring(0, dot);
            String tail = name.substring(dot);
            if (InternalPolicy.DEBUG_LOAD_URL_IMAGE_DESCRIPTOR_2x_PNG_FOR_GIF && ".gif".equalsIgnoreCase(tail)) {
                tail = ".png";
            }
            String x = zoom == 150 ? "@1.5x" : "@2x";
            return lead + x + tail;
        }
        return null;
    }

    public int hashCode() {
        int code = this.name.hashCode();
        if (this.location != null) {
            code += this.location.hashCode();
        }
        return code;
    }

    public String toString() {
        return "FileImageDescriptor(location=" + String.valueOf(this.location) + ", name=" + this.name + ")";
    }

    @Override
    public Image createImage(boolean returnMissingImageOnError, Device device) {
        String path;
        if (InternalPolicy.DEBUG_LOAD_URL_IMAGE_DESCRIPTOR_2x) {
            try {
                return new Image(device, (ImageFileNameProvider)new ImageProvider());
            }
            catch (IllegalArgumentException | SWTException throwable) {
                // empty catch block
            }
        }
        if ((path = this.getFilePath(this.name, true)) == null) {
            return this.createDefaultImage(returnMissingImageOnError, device);
        }
        try {
            return new Image(device, path);
        }
        catch (SWTException sWTException) {
            return super.createImage(returnMissingImageOnError, device);
        }
    }

    private Image createDefaultImage(boolean returnMissingImageOnError, Device device) {
        try {
            if (returnMissingImageOnError) {
                return new Image(device, DEFAULT_IMAGE_DATA);
            }
        }
        catch (SWTException nextException) {
            return null;
        }
        return null;
    }

    String getFilePath(String name, boolean logIOException) {
        if (this.location == null) {
            return IPath.fromOSString((String)name).toOSString();
        }
        URL resource = this.location.getResource(name);
        if (resource == null) {
            return null;
        }
        try {
            if (!InternalPolicy.OSGI_AVAILABLE) {
                return IPath.fromOSString((String)resource.getFile()).toOSString();
            }
            return IPath.fromOSString((String)FileLocator.toFileURL((URL)resource).getPath()).toOSString();
        }
        catch (IOException e) {
            if (logIOException) {
                Policy.logException(e);
            } else if (InternalPolicy.DEBUG_LOG_URL_IMAGE_DESCRIPTOR_MISSING_2x && (name.endsWith("@2x.png") || name.endsWith("@1.5x.png"))) {
                String message = "High-resolution image missing: " + String.valueOf(this.location) + " " + name;
                Policy.getLog().log((IStatus)new Status(2, "org.eclipse.jface", message, (Throwable)e));
            }
            return null;
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == URL.class && this.location != null && this.name != null) {
            return adapter.cast(this.location.getResource(this.name));
        }
        if (adapter == ImageFileNameProvider.class) {
            return adapter.cast(new ImageProvider());
        }
        return null;
    }

    private class ImageProvider
    implements ImageFileNameProvider {
        private ImageProvider() {
        }

        public String getImagePath(int zoom) {
            String xResult;
            String xResult2;
            boolean logIOException;
            boolean bl = logIOException = zoom == 100;
            if (zoom == 100) {
                return FileImageDescriptor.this.getFilePath(FileImageDescriptor.this.name, logIOException);
            }
            String xName = FileImageDescriptor.getxName(FileImageDescriptor.this.name, zoom);
            if (xName != null && (xResult2 = FileImageDescriptor.this.getFilePath(xName, logIOException)) != null) {
                return xResult2;
            }
            String xPath = FileImageDescriptor.getxPath(FileImageDescriptor.this.name, zoom);
            if (xPath != null && (xResult = FileImageDescriptor.this.getFilePath(xPath, logIOException)) != null) {
                return xResult;
            }
            return null;
        }
    }
}

