/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.IEncoder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public abstract class BaseBlockEncoder<LOC extends IcfgLocation>
implements IEncoder<LOC> {
    protected final IUltimateServiceProvider mServices;
    protected final ILogger mLogger;
    private final BlockEncodingBacktranslator mBacktranslator;
    protected int mRemovedEdges;
    protected int mRemovedLocations;
    private BasicIcfg<LOC> mResult;

    public BaseBlockEncoder(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, BlockEncodingBacktranslator blockEncodingBacktranslator) {
        assert (iUltimateServiceProvider != null);
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mRemovedEdges = 0;
        this.mRemovedLocations = 0;
        this.mBacktranslator = blockEncodingBacktranslator;
    }

    @Override
    public BasicIcfg<LOC> getResult(BasicIcfg<LOC> basicIcfg) {
        if (this.mResult == null) {
            this.mResult = this.createResult(basicIcfg);
            this.mBacktranslator.removeIntermediateMappings();
            assert (this.mResult != null);
        }
        return this.mResult;
    }

    public int getRemovedEdges() {
        return this.mRemovedEdges;
    }

    public int getRemovedLocations() {
        return this.mRemovedLocations;
    }

    protected abstract BasicIcfg<LOC> createResult(BasicIcfg<LOC> var1);

    protected List<IcfgLocation> getSuccessors(IcfgLocation icfgLocation) {
        ArrayList<IcfgLocation> arrayList = new ArrayList<IcfgLocation>();
        for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
            arrayList.add((IcfgLocation)icfgEdge.getTarget());
        }
        return arrayList;
    }

    protected void removeDisconnectedLocations(BasicIcfg<LOC> basicIcfg) {
        Set set = basicIcfg.getProcedureEntryNodes().entrySet().stream().map(entry -> (IcfgLocation)entry.getValue()).collect(Collectors.toSet());
        Predicate<IcfgLocation> predicate = icfgLocation -> (!set.contains(icfgLocation) || icfgLocation.getOutgoingEdges().isEmpty()) && icfgLocation.getIncomingEdges().isEmpty();
        Deque deque = (Deque)basicIcfg.getProgramPoints().entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).entrySet().stream()).map(entry -> (IcfgLocation)entry.getValue()).filter(predicate).collect(new DequeCollector());
        ArrayList<IcfgLocation> arrayList = new ArrayList<IcfgLocation>();
        while (!deque.isEmpty()) {
            IcfgLocation icfgLocation2 = (IcfgLocation)deque.removeFirst();
            ArrayList arrayList2 = new ArrayList(icfgLocation2.getOutgoingEdges());
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                IcfgEdge icfgEdge = (IcfgEdge)iterator.next();
                IcfgLocation icfgLocation3 = (IcfgLocation)icfgEdge.getTarget();
                if (icfgLocation3.getIncomingEdges().size() == 1) {
                    deque.addLast(icfgLocation3);
                }
                icfgEdge.disconnectSource();
                icfgEdge.disconnectTarget();
                ++this.mRemovedEdges;
            }
            boolean bl = IcfgUtils.isExit((IcfgLocation)icfgLocation2, basicIcfg);
            if (bl) {
                arrayList.add(icfgLocation2);
                continue;
            }
            this.removeDisconnectedLocation(basicIcfg, icfgLocation2);
        }
        for (IcfgLocation icfgLocation2 : arrayList) {
            if (basicIcfg.getProcedureEntryNodes().containsKey(icfgLocation2.getProcedure())) continue;
            this.removeDisconnectedLocation(basicIcfg, icfgLocation2);
        }
    }

    protected void removeDisconnectedLocation(BasicIcfg<LOC> basicIcfg, IcfgLocation icfgLocation) {
        basicIcfg.removeLocation(icfgLocation);
        ++this.mRemovedLocations;
    }

    protected void rememberEdgeMapping(IIcfgTransition<?> iIcfgTransition, IIcfgTransition<?> iIcfgTransition2) {
        this.mBacktranslator.mapEdges((IIcfgTransition)((IcfgEdge)iIcfgTransition), (IIcfgTransition)((IcfgEdge)iIcfgTransition2));
    }

    protected void rememberEdgeMapping(IIcfgTransition<IcfgLocation> iIcfgTransition, Map<TermVariable, IIcfgTransition<IcfgLocation>> map) {
        this.mBacktranslator.mapEdges(iIcfgTransition, map);
    }

    private static class DequeCollector<T>
    implements Collector<T, Deque<T>, Deque<T>> {
        private static final Set<Collector.Characteristics> CHARACTERISTICS = EnumSet.of(Collector.Characteristics.IDENTITY_FINISH);

        private DequeCollector() {
        }

        @Override
        public Supplier<Deque<T>> supplier() {
            return ArrayDeque::new;
        }

        @Override
        public BiConsumer<Deque<T>, T> accumulator() {
            return (deque, object) -> deque.addFirst(object);
        }

        @Override
        public BinaryOperator<Deque<T>> combiner() {
            return this::combiner;
        }

        @Override
        public Function<Deque<T>, Deque<T>> finisher() {
            return deque -> deque;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return CHARACTERISTICS;
        }

        private Deque<T> combiner(Deque<T> deque, Deque<T> deque2) {
            ArrayDeque<T> arrayDeque = new ArrayDeque<T>(deque.size() + deque2.size() + 1);
            arrayDeque.addAll(deque);
            arrayDeque.addAll(deque2);
            return arrayDeque;
        }
    }
}

