/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FunctionValue {
    private Map<Index, Term> mValues;
    private Term mDefault;

    public FunctionValue() {
        this.mDefault = null;
    }

    public FunctionValue(Term term) {
        this.mDefault = term;
    }

    public void put(Term term, Term ... termArray) {
        if (termArray.length == 0) {
            assert (this.mDefault == null);
            this.mDefault = term;
        } else {
            if (this.mValues == null) {
                this.mValues = new HashMap<Index, Term>();
            }
            this.mValues.put(new Index(termArray), term);
        }
    }

    public Term get(Term[] termArray) {
        if (this.mValues == null) {
            return this.mDefault;
        }
        Term term = this.mValues.get(new Index(termArray));
        return term == null ? this.mDefault : term;
    }

    public Term getDefault() {
        return this.mDefault;
    }

    public Map<Index, Term> values() {
        return this.mValues != null ? this.mValues : Collections.emptyMap();
    }

    public static class Index {
        private final Term[] mIdx;
        private final int mHash;

        public Index(Term[] termArray) {
            this.mIdx = termArray;
            this.mHash = Arrays.hashCode(this.mIdx);
        }

        public int hashCode() {
            return this.mHash;
        }

        public boolean equals(Object object) {
            if (object instanceof Index) {
                return Arrays.equals(this.mIdx, ((Index)object).mIdx);
            }
            return false;
        }

        public Term[] toArray() {
            return this.mIdx;
        }

        public String toString() {
            return Arrays.toString(this.mIdx);
        }
    }
}

