/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.toolchain;

import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchain;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public abstract class BasicToolchainJob
extends Job {
    protected ICore<RunDefinition> mCore;
    protected IController<RunDefinition> mController;
    protected ILogger mLogger;
    protected IUltimateServiceProvider mServices;
    private long mDeadline;

    protected BasicToolchainJob(String string, ICore<RunDefinition> iCore, IController<RunDefinition> iController, ILogger iLogger) {
        super(string);
        this.mCore = iCore;
        this.mController = iController;
        this.mLogger = Objects.requireNonNull(iLogger);
        this.mDeadline = -1L;
    }

    private void setTimeout() {
        long l = 0L;
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider("de.uni_freiburg.informatik.ultimate.core");
        int n = iPreferenceProvider.getInt("Toolchain timeout in seconds");
        l = this.mDeadline != -1L ? this.mDeadline : (long)n * 1000L;
        if (l > 0L) {
            this.mServices.getProgressMonitorService().setDeadline(System.currentTimeMillis() + l);
        }
    }

    protected void setServices(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.setTimeout();
    }

    public void setDeadline(long l) {
        if (l >= 0L) {
            this.mDeadline = l;
        }
    }

    protected abstract IStatus run(IProgressMonitor var1);

    protected IStatus convert(IToolchain.ReturnCode returnCode) {
        switch (returnCode) {
            case Ok: 
            case Cancel: {
                return Status.OK_STATUS;
            }
        }
        return new Status(8, "de.uni_freiburg.informatik.ultimate.core", 4, returnCode.toString(), null);
    }
}

