/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IndexAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayEquality;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayUpdate;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EquivalentCells {
    private final Script mScript;
    private final UnionFind<TermVariable> mUnionFind;
    private final Map<TermVariable, TermVariable> mRepresentative;
    private final Term mInOutEqauality;
    private final ModifiableTransFormula mTransFormula;
    private final Map<TermVariable, Map<ArrayIndex, TermVariable>> mArrayInstance2Index2CellVariable;
    private final IndexAnalysisResult mIndexAnalyzer;

    public EquivalentCells(Script script, ModifiableTransFormula modifiableTransFormula, List<ArrayEquality> list, List<ArrayUpdate> list2, IndexAnalysisResult indexAnalysisResult, Map<TermVariable, Map<ArrayIndex, TermVariable>> map) {
        this.mScript = script;
        this.mTransFormula = modifiableTransFormula;
        this.mIndexAnalyzer = indexAnalysisResult;
        this.mArrayInstance2Index2CellVariable = map;
        this.mUnionFind = new UnionFind();
        this.addArrayIndexConstraints(this.mUnionFind);
        this.addArrayEqualityConstraints(this.mUnionFind, list);
        this.addArrayUpdateConstraints(this.mUnionFind, list2);
        this.mRepresentative = this.computeRepresentatives(this.mUnionFind);
        this.mInOutEqauality = this.computeInOutEqualities(this.mUnionFind);
    }

    private void addArrayUpdateConstraints(UnionFind<TermVariable> unionFind, List<ArrayUpdate> list) {
        for (ArrayUpdate arrayUpdate : list) {
            ArrayIndex arrayIndex = arrayUpdate.getIndex();
            Map<ArrayIndex, TermVariable> map = this.mArrayInstance2Index2CellVariable.get(arrayUpdate.getNewArray());
            Map<ArrayIndex, TermVariable> map2 = this.mArrayInstance2Index2CellVariable.get(arrayUpdate.getOldArray());
            for (ArrayIndex arrayIndex2 : map.keySet()) {
                TermVariable termVariable = map.get(arrayIndex2);
                TermVariable termVariable2 = map2.get(arrayIndex2);
                EqualityStatus equalityStatus = this.mIndexAnalyzer.isEqual((List)arrayIndex2, (List)arrayIndex);
                switch (equalityStatus) {
                    case EQUAL: {
                        break;
                    }
                    case NOT_EQUAL: {
                        unionFind.union((Object)termVariable, (Object)termVariable2);
                        break;
                    }
                }
            }
        }
    }

    private void addArrayIndexConstraints(UnionFind<TermVariable> unionFind) {
        for (Map.Entry<TermVariable, Map<ArrayIndex, TermVariable>> entry : this.mArrayInstance2Index2CellVariable.entrySet()) {
            Object object;
            Map<ArrayIndex, TermVariable> map = entry.getValue();
            List[] listArray = new List[map.size()];
            TermVariable[] termVariableArray = new TermVariable[map.size()];
            int n = 0;
            for (Map.Entry<ArrayIndex, TermVariable> entry2 : map.entrySet()) {
                listArray[n] = (List)entry2.getKey();
                termVariableArray[n] = object = entry2.getValue();
                unionFind.makeEquivalenceClass(object);
                ++n;
            }
            int n2 = 0;
            while (n2 < map.size()) {
                int n3 = 0;
                while (n3 < n2) {
                    object = listArray[n2];
                    List list = listArray[n3];
                    if (this.mIndexAnalyzer.isEqual((List)object, list) == EqualityStatus.EQUAL) {
                        TermVariable termVariable = termVariableArray[n2];
                        TermVariable termVariable2 = termVariableArray[n3];
                        unionFind.union((Object)termVariable, (Object)termVariable2);
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }

    private void addArrayEqualityConstraints(UnionFind<TermVariable> unionFind, List<ArrayEquality> list) {
        for (ArrayEquality arrayEquality : list) {
            Map<ArrayIndex, TermVariable> map = this.mArrayInstance2Index2CellVariable.get(arrayEquality.getLhsTermVariable());
            Map<ArrayIndex, TermVariable> map2 = this.mArrayInstance2Index2CellVariable.get(arrayEquality.getRhsTermVariable());
            if (map == null) {
                // empty if block
            }
            for (List list2 : map.keySet()) {
                TermVariable termVariable = map.get(list2);
                assert (termVariable != null) : "no cell variable for " + String.valueOf(list2);
                TermVariable termVariable2 = map2.get(list2);
                assert (termVariable2 != null) : "no cell variable for " + String.valueOf(list2);
                unionFind.union((Object)termVariable, (Object)termVariable2);
            }
        }
    }

    private Term computeInOutEqualities(UnionFind<TermVariable> unionFind) {
        ArrayList<Iterator> arrayList = new ArrayList<Iterator>();
        for (TermVariable termVariable : unionFind.getAllRepresentatives()) {
            TermVariable termVariable22;
            ArrayList<TermVariable> arrayList2 = new ArrayList<TermVariable>();
            for (TermVariable termVariable22 : unionFind.getEquivalenceClassMembers((Object)termVariable)) {
                if (!ModifiableTransFormulaUtils.isInVar((TermVariable)termVariable22, (ModifiableTransFormula)this.mTransFormula) && !ModifiableTransFormulaUtils.isOutVar((TermVariable)termVariable22, (ModifiableTransFormula)this.mTransFormula)) continue;
                arrayList2.add(termVariable22);
            }
            if (arrayList2.size() <= 1) continue;
            termVariable22 = this.mScript.term("=", arrayList2.toArray(new Term[arrayList2.size()]));
            Iterator iterator = SmtUtils.binarize((Script)this.mScript, (ApplicationTerm)((ApplicationTerm)termVariable22));
            arrayList.add(iterator);
        }
        return SmtUtils.and((Script)this.mScript, (Term[])arrayList.toArray(new Term[arrayList.size()]));
    }

    private Map<TermVariable, TermVariable> computeRepresentatives(UnionFind<TermVariable> unionFind) {
        HashMap<TermVariable, TermVariable> hashMap = new HashMap<TermVariable, TermVariable>();
        for (TermVariable termVariable : unionFind.getAllRepresentatives()) {
            TermVariable termVariable2 = this.computeInOutRepresentative(unionFind, termVariable);
            hashMap.put(termVariable, termVariable2);
        }
        return hashMap;
    }

    private TermVariable computeInOutRepresentative(UnionFind<TermVariable> unionFind, TermVariable termVariable) {
        ImmutableSet immutableSet = unionFind.getEquivalenceClassMembers((Object)termVariable);
        for (TermVariable termVariable2 : immutableSet) {
            if (!ModifiableTransFormulaUtils.isInVar((TermVariable)termVariable2, (ModifiableTransFormula)this.mTransFormula) && !ModifiableTransFormulaUtils.isOutVar((TermVariable)termVariable2, (ModifiableTransFormula)this.mTransFormula)) continue;
            return termVariable2;
        }
        return termVariable;
    }

    public Term getInOutEqauality() {
        return this.mInOutEqauality;
    }

    public TermVariable getInOutRepresentative(TermVariable termVariable) {
        TermVariable termVariable2 = (TermVariable)this.mUnionFind.find((Object)termVariable);
        return this.mRepresentative.get(termVariable2);
    }
}

