/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayDeque;

public class ApplicationTerm
extends Term {
    final FunctionSymbol mFunction;
    final Term[] mParameters;

    ApplicationTerm(FunctionSymbol functionSymbol, Term[] termArray, int n) {
        super(n);
        functionSymbol.typecheck(termArray);
        this.mFunction = functionSymbol;
        this.mParameters = termArray;
    }

    public FunctionSymbol getFunction() {
        return this.mFunction;
    }

    public Term[] getParameters() {
        return this.mParameters;
    }

    @Override
    public Sort getSort() {
        return this.mFunction.mReturnSort.getRealSort();
    }

    static final int hashApplication(FunctionSymbol functionSymbol, Term[] termArray) {
        return HashUtils.hashJenkins((int)functionSymbol.hashCode(), (Object[])termArray);
    }

    @Override
    public void toStringHelper(ArrayDeque<Object> arrayDeque) {
        String string = this.getFunction().getApplicationString();
        Term[] termArray = this.getParameters();
        if (termArray.length == 0) {
            arrayDeque.add(string);
        } else {
            arrayDeque.addLast(")");
            int n = termArray.length - 1;
            while (n >= 0) {
                arrayDeque.addLast(termArray[n]);
                arrayDeque.addLast(" ");
                --n;
            }
            arrayDeque.add(string);
            arrayDeque.add("(");
        }
    }
}

