/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.boogie;

import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.boogie.CompleteBoogieVar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SymbolTable {
    protected HashMap<String, HashMap<String, CompleteBoogieVar>> mScopes = new HashMap();
    protected static final String sGlobalScopeIdentifier = "global";

    void addLocalVariable(String string, String string2, IBoogieType iBoogieType) {
        HashMap<Object, Object> hashMap;
        if (string2.equals(sGlobalScopeIdentifier)) {
            throw new IllegalArgumentException("Procedure name is equal to global scope identifier global");
        }
        CompleteBoogieVar completeBoogieVar = new CompleteBoogieVar(string, string2, iBoogieType);
        if (this.mScopes.containsKey(string2)) {
            hashMap = this.mScopes.get(string2);
        } else {
            hashMap = new HashMap();
            this.mScopes.put(string2, hashMap);
        }
        hashMap.put(string, completeBoogieVar);
    }

    void addGlobalVariable(String string, IBoogieType iBoogieType) {
        HashMap<Object, Object> hashMap;
        CompleteBoogieVar completeBoogieVar = new CompleteBoogieVar(string, null, iBoogieType);
        if (this.mScopes.containsKey(sGlobalScopeIdentifier)) {
            hashMap = this.mScopes.get(sGlobalScopeIdentifier);
        } else {
            hashMap = new HashMap();
            this.mScopes.put(sGlobalScopeIdentifier, hashMap);
        }
        hashMap.put(string, completeBoogieVar);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompleteBoogieVar getVariable(String string, String string2) {
        HashMap<String, CompleteBoogieVar> hashMap;
        if (string2 == null) {
            if (!this.mScopes.containsKey(sGlobalScopeIdentifier)) return null;
            hashMap = this.mScopes.get(sGlobalScopeIdentifier);
        } else {
            if (!this.mScopes.containsKey(string2)) return null;
            hashMap = this.mScopes.get(string2);
        }
        if (hashMap.containsKey(string)) {
            return hashMap.get(string);
        }
        if (string2 == null) return null;
        return this.getVariable(string, null);
    }

    public List<CompleteBoogieVar> getVariables(String string) {
        HashMap<String, CompleteBoogieVar> hashMap;
        LinkedList<CompleteBoogieVar> linkedList = new LinkedList<CompleteBoogieVar>();
        if (this.mScopes.containsKey(sGlobalScopeIdentifier)) {
            hashMap = this.mScopes.get(sGlobalScopeIdentifier);
            linkedList.addAll(hashMap.values());
        }
        if (string != null && this.mScopes.containsKey(string)) {
            hashMap = this.mScopes.get(string);
            for (CompleteBoogieVar completeBoogieVar : hashMap.values()) {
                int n = linkedList.size() - 1;
                while (n >= 0) {
                    if (completeBoogieVar.getIdentifier().equals(((CompleteBoogieVar)linkedList.get(n)).getIdentifier())) {
                        linkedList.remove(n);
                    }
                    --n;
                }
            }
            linkedList.addAll(hashMap.values());
        }
        return linkedList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        for (Map.Entry<String, HashMap<String, CompleteBoogieVar>> entry : this.mScopes.entrySet()) {
            if (entry.getKey().equals(sGlobalScopeIdentifier)) {
                stringBuilder.append("Global:\n");
            } else {
                stringBuilder.append("Procedure ");
                stringBuilder.append(entry.getKey());
                stringBuilder.append(":\n");
            }
            for (Map.Entry<String, CompleteBoogieVar> entry2 : entry.getValue().entrySet()) {
                stringBuilder.append("Name is \"");
                stringBuilder.append(entry2.getKey());
                stringBuilder.append("\", CompleteBoogieVar is ");
                stringBuilder.append(entry2.getValue());
                stringBuilder.append("\n");
            }
        }
        return stringBuilder.toString();
    }
}

