/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.toolchain;

import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.PluginType;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.SubchainType;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.ToolchainFileValidator;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainData;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import jakarta.xml.bind.JAXBException;
import java.io.FileNotFoundException;
import org.xml.sax.SAXException;

public class ToolchainData
implements IToolchainData<RunDefinition> {
    private final RunDefinition mToolchain;
    private final IToolchainStorage mStorage;
    private final IUltimateServiceProvider mServices;

    public ToolchainData(IUltimateServiceProvider iUltimateServiceProvider, IToolchainStorage iToolchainStorage) {
        this(new ToolchainFileValidator().createEmptyToolchain(), iUltimateServiceProvider, iToolchainStorage);
    }

    public ToolchainData(String string, IUltimateServiceProvider iUltimateServiceProvider, IToolchainStorage iToolchainStorage) throws JAXBException, FileNotFoundException, SAXException {
        this(new ToolchainFileValidator().loadValidatedToolchain(string), iUltimateServiceProvider, iToolchainStorage);
    }

    private ToolchainData(RunDefinition runDefinition, IUltimateServiceProvider iUltimateServiceProvider, IToolchainStorage iToolchainStorage) {
        this.mToolchain = runDefinition;
        this.mServices = iUltimateServiceProvider;
        this.mStorage = iToolchainStorage;
    }

    public void addPlugin(PluginType pluginType) {
        this.mToolchain.getToolchain().getPluginOrSubchain().add(pluginType);
    }

    public void addPlugin(String string) {
        PluginType pluginType = new PluginType();
        pluginType.setId(string);
        this.mToolchain.getToolchain().getPluginOrSubchain().add(pluginType);
    }

    public void addSubchain(SubchainType subchainType) {
        this.mToolchain.getToolchain().getPluginOrSubchain().add(subchainType);
    }

    public void addToolchain(ToolchainData toolchainData) {
        this.mToolchain.getToolchain().getPluginOrSubchain().addAll(toolchainData.getRootElement().getToolchain().getPluginOrSubchain());
    }

    public RunDefinition getRootElement() {
        return this.mToolchain;
    }

    public IToolchainStorage getStorage() {
        return this.mStorage;
    }

    public IUltimateServiceProvider getServices() {
        return this.mServices;
    }

    public IToolchainData<RunDefinition> replaceServices(IUltimateServiceProvider iUltimateServiceProvider) {
        return new ToolchainData(this.mToolchain, iUltimateServiceProvider, this.mStorage);
    }
}

