/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.List;
import java.util.function.Predicate;

public final class BitVectorAccessExpression
extends Expression {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(BitVectorAccessExpression.class);
    Expression bitvec;
    int end;
    int start;

    public BitVectorAccessExpression(ILocation iLocation, Expression expression, int n, int n2) {
        super(iLocation);
        this.bitvec = expression;
        this.end = n;
        this.start = n2;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid BitVectorAccessExpression: " + String.valueOf((Object)this);
    }

    public BitVectorAccessExpression(ILocation iLocation, IBoogieType iBoogieType, Expression expression, int n, int n2) {
        super(iLocation, iBoogieType);
        this.bitvec = expression;
        this.end = n;
        this.start = n2;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid BitVectorAccessExpression: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BitVectorAccessExpression").append('[');
        stringBuffer.append((Object)this.bitvec);
        stringBuffer.append(',').append(this.end);
        stringBuffer.append(',').append(this.start);
        return stringBuffer.append(']').toString();
    }

    public Expression getBitvec() {
        return this.bitvec;
    }

    public int getEnd() {
        return this.end;
    }

    public int getStart() {
        return this.start;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        list.add(this.bitvec);
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Expression)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this) && this.bitvec != null) {
            this.bitvec.accept(generatedBoogieAstVisitor);
        }
    }

    @Override
    public Expression accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Expression expression = generatedBoogieAstTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        Expression expression2 = null;
        if (this.bitvec != null) {
            expression2 = this.bitvec.accept(generatedBoogieAstTransformer);
        }
        if (this.bitvec != expression2) {
            return new BitVectorAccessExpression(this.loc, this.type, expression2, this.end, this.start);
        }
        return this;
    }
}

