/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.concurrency;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementEngineResult;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.IndependenceBuilder;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.abstraction.IRefinableAbstraction;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.concurrency.IRefinableIndependenceProvider;

class IndependenceProviderWithAbstraction<L extends IIcfgTransition<?>, H>
implements IRefinableIndependenceProvider<L> {
    private final IRefinableAbstraction<NestedWordAutomaton<L, IPredicate>, H, L> mRefinableAbstraction;
    private final IIndependenceRelation<IPredicate, L> mUnderlyingIndependence;
    private H mAbstractionLevel;

    public IndependenceProviderWithAbstraction(IRefinableAbstraction<NestedWordAutomaton<L, IPredicate>, H, L> iRefinableAbstraction, IIndependenceRelation<IPredicate, L> iIndependenceRelation) {
        this.mRefinableAbstraction = iRefinableAbstraction;
        this.mUnderlyingIndependence = iIndependenceRelation;
    }

    @Override
    public void initialize() {
        this.mAbstractionLevel = this.mRefinableAbstraction.getInitial();
    }

    @Override
    public void refine(IRefinementEngineResult<L, NestedWordAutomaton<L, IPredicate>> iRefinementEngineResult) {
        Object object = this.mRefinableAbstraction.refine(this.mAbstractionLevel, iRefinementEngineResult);
        assert (this.mRefinableAbstraction.getHierarchy().compare(object, this.mAbstractionLevel).isLessOrEqual()) : "Refinement must yield a lower abstraction level";
        this.mAbstractionLevel = object;
    }

    @Override
    public IIndependenceRelation<IPredicate, L> retrieveIndependence() {
        return ((IndependenceBuilder.PredicateActionIndependenceBuilder)IndependenceBuilder.fromPredicateActionIndependence(this.mUnderlyingIndependence).withAbstraction(this.mRefinableAbstraction, this.mAbstractionLevel)).build();
    }
}

