/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.CoenabledRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.ICompositionFactory;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.LiptonReductionStatisticsDefinitions;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.LiptonReductionStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.CachedIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.CopySubnet;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LiptonReduction<L, P> {
    private final AutomataLibraryServices mServices;
    private final ILogger mLogger;
    private final ICompositionFactory<L> mCompositionFactory;
    private final IIndependenceRelation<?, L> mMoverCheck;
    private final CoenabledRelation<L> mCoEnabledRelation;
    private final Map<L, List<L>> mSequentialCompositions = new HashMap<L, List<L>>();
    private final Map<L, Set<L>> mChoiceCompositions = new HashMap<L, Set<L>>();
    private final BoundedPetriNet<L, P> mResult;
    private final LiptonReductionStatisticsGenerator mStatistics = new LiptonReductionStatisticsGenerator();

    public LiptonReduction(AutomataLibraryServices automataLibraryServices, BoundedPetriNet<L, P> boundedPetriNet, ICompositionFactory<L> iCompositionFactory, IIndependenceRelation<?, L> iIndependenceRelation) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        this.mServices = automataLibraryServices;
        this.mLogger = automataLibraryServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
        this.mCompositionFactory = iCompositionFactory;
        this.mMoverCheck = iIndependenceRelation;
        this.mStatistics.start((Object)LiptonReductionStatisticsDefinitions.ReductionTime);
        this.mStatistics.collectInitialStatistics(boundedPetriNet);
        this.mLogger.info((Object)("Starting Lipton reduction on Petri net that " + boundedPetriNet.sizeInformation()));
        try {
            try {
                BoundedPetriNet<L, P> boundedPetriNet2;
                this.mCoEnabledRelation = CoenabledRelation.fromPetriNet(this.mServices, boundedPetriNet);
                int n = this.mCoEnabledRelation.size();
                this.mLogger.info((Object)("Number of co-enabled transitions " + n));
                this.mStatistics.setCoEnabledTransitionPairs(n);
                BoundedPetriNet<L, P> boundedPetriNet3 = CopySubnet.copy(automataLibraryServices, boundedPetriNet, new HashSet(boundedPetriNet.getTransitions()), boundedPetriNet.getAlphabet(), true);
                do {
                    this.mStatistics.reportFixpointIteration();
                    boundedPetriNet2 = boundedPetriNet3;
                    boundedPetriNet3 = this.sequenceRule(boundedPetriNet2);
                    boundedPetriNet3 = this.choiceRule(boundedPetriNet3);
                } while (boundedPetriNet2.getTransitions().size() != boundedPetriNet3.getTransitions().size());
                this.mResult = boundedPetriNet3;
                this.mLogger.info((Object)("Checked pairs total: " + String.valueOf(this.mStatistics.getValue(LiptonReductionStatisticsDefinitions.MoverChecksTotal))));
                this.mLogger.info((Object)("Total number of compositions: " + String.valueOf(this.mStatistics.getValue(LiptonReductionStatisticsDefinitions.TotalNumberOfCompositions))));
            }
            catch (AutomataOperationCanceledException automataOperationCanceledException) {
                RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), this.generateTimeoutMessage(boundedPetriNet));
                automataOperationCanceledException.addRunningTaskInfo(runningTaskInfo);
                throw automataOperationCanceledException;
            }
            catch (ToolchainCanceledException toolchainCanceledException) {
                RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), this.generateTimeoutMessage(boundedPetriNet));
                toolchainCanceledException.addRunningTaskInfo(runningTaskInfo);
                throw toolchainCanceledException;
            }
        }
        finally {
            this.mStatistics.stop((Object)LiptonReductionStatisticsDefinitions.ReductionTime);
        }
        this.mStatistics.collectFinalStatistics(this.mResult);
    }

    private String generateTimeoutMessage(BoundedPetriNet<L, P> boundedPetriNet) {
        if (this.mCoEnabledRelation == null) {
            return "applying " + this.getClass().getSimpleName() + " to Petri net that " + boundedPetriNet.sizeInformation();
        }
        return "applying " + this.getClass().getSimpleName() + " to Petri net that " + boundedPetriNet.sizeInformation() + " and " + this.mCoEnabledRelation.size() + " co-enabled transitions pairs.";
    }

    private void transferMoverProperties(L l, L l2, L l3) {
        if (this.mMoverCheck instanceof CachedIndependenceRelation) {
            ((CachedIndependenceRelation)this.mMoverCheck).getCache().mergeIndependencies(l2, l3, l);
        }
    }

    private void removeMoverProperties(L l) {
        if (this.mMoverCheck instanceof CachedIndependenceRelation) {
            ((CachedIndependenceRelation)this.mMoverCheck).removeFromCache(l);
        }
    }

    private BoundedPetriNet<L, P> choiceRule(BoundedPetriNet<L, P> boundedPetriNet) {
        Set<Transition<L, P>> set = boundedPetriNet.getTransitions();
        HashSet<Triple<L, Transition<L, P>, Transition<L, P>>> hashSet = new HashSet<Triple<L, Transition<L, P>, Transition<L, P>>>();
        HashSet<Transition<L, P>> hashSet2 = new HashSet<Transition<L, P>>();
        for (Transition transition : set) {
            for (Transition transition2 : set) {
                if (transition.equals(transition2) || !transition.getPredecessors().equals(transition2.getPredecessors()) || !transition.getSuccessors().equals(transition2.getSuccessors()) || !this.mCompositionFactory.isComposable(transition.getSymbol()) || !this.mCompositionFactory.isComposable(transition2.getSymbol())) continue;
                assert (this.mCoEnabledRelation.getImage(transition.getSymbol()).equals(this.mCoEnabledRelation.getImage(transition2.getSymbol())));
                if (hashSet2.contains(transition) || hashSet2.contains(transition2)) continue;
                List<Object> list = Arrays.asList(transition.getSymbol(), transition2.getSymbol());
                Object object = this.mCompositionFactory.composeParallel(list);
                this.mChoiceCompositions.put(object, new HashSet<Object>(list));
                hashSet.add(new Triple(object, (Object)transition, (Object)transition2));
                hashSet2.add(transition);
                hashSet2.add(transition2);
                this.mStatistics.reportComposition(LiptonReductionStatisticsDefinitions.ChoiceCompositions);
            }
        }
        BoundedPetriNet<L, P> boundedPetriNet2 = this.copyPetriNetWithModification(boundedPetriNet, hashSet, hashSet2);
        for (Triple triple : hashSet) {
            this.mCoEnabledRelation.copyRelationships(((Transition)triple.getSecond()).getSymbol(), triple.getFirst());
            this.transferMoverProperties(triple.getFirst(), ((Transition)triple.getSecond()).getSymbol(), ((Transition)triple.getThird()).getSymbol());
        }
        for (Transition transition : hashSet2) {
            this.mCoEnabledRelation.deleteElement(transition.getSymbol());
            this.removeMoverProperties(transition.getSymbol());
        }
        return boundedPetriNet2;
    }

    private BoundedPetriNet<L, P> sequenceRule(BoundedPetriNet<L, P> boundedPetriNet) {
        Set<Transition<L, P>> set = boundedPetriNet.getTransitions();
        HashSet<Transition<L, P>> hashSet = new HashSet<Transition<L, P>>();
        HashSet<Transition<L, P>> hashSet2 = new HashSet<Transition<L, P>>();
        HashSet<Triple<L, Transition<L, P>, Transition<L, P>>> hashSet3 = new HashSet<Triple<L, Transition<L, P>, Transition<L, P>>>();
        for (Transition transition : set) {
            L l;
            boolean bl;
            boolean bl2;
            boolean bl3;
            if (hashSet2.contains(transition)) continue;
            Iterator iterator = transition.getSuccessors();
            ImmutableSet immutableSet = transition.getPredecessors();
            if (iterator.size() != 1) continue;
            Object e = immutableSet.iterator().next();
            Object e2 = iterator.iterator().next();
            if (boundedPetriNet.getSuccessors(e).size() == 1 && boundedPetriNet.getPredecessors(e).size() > 1) {
                bl3 = true;
                bl2 = false;
                for (Transition<L, P> transition2 : boundedPetriNet.getPredecessors(e)) {
                    bl = !hashSet2.contains(transition2) && this.sequenceRuleCheck(transition2, transition, e, boundedPetriNet);
                    boolean bl4 = bl3 = bl3 && bl;
                    if (!bl) continue;
                    l = this.mCompositionFactory.composeSequential(transition2.getSymbol(), transition.getSymbol());
                    hashSet3.add(new Triple(l, transition2, (Object)transition));
                    hashSet2.add(transition);
                    hashSet2.add(transition2);
                    hashSet.add(transition2);
                    bl2 = true;
                    if (this.mCoEnabledRelation.getImage(transition.getSymbol()).isEmpty()) {
                        this.mStatistics.reportComposition(LiptonReductionStatisticsDefinitions.TrivialYvCompositions);
                        continue;
                    }
                    this.mStatistics.reportComposition(LiptonReductionStatisticsDefinitions.ConcurrentYvCompositions);
                }
                if (!bl3 || !bl2) continue;
                hashSet.add(transition);
                continue;
            }
            if (boundedPetriNet.getPredecessors(e2).size() != 1) continue;
            bl3 = true;
            bl2 = false;
            for (Transition<L, P> transition2 : boundedPetriNet.getSuccessors(e2)) {
                bl = !hashSet2.contains(transition2) && this.sequenceRuleCheck(transition, transition2, e2, boundedPetriNet);
                boolean bl5 = bl3 = bl3 && bl;
                if (!bl) continue;
                l = this.mCompositionFactory.composeSequential(transition.getSymbol(), transition2.getSymbol());
                hashSet3.add(new Triple(l, (Object)transition, transition2));
                hashSet2.add(transition);
                hashSet2.add(transition2);
                hashSet.add(transition2);
                bl2 = true;
                if (this.mCoEnabledRelation.getImage(transition.getSymbol()).isEmpty()) {
                    this.mStatistics.reportComposition(LiptonReductionStatisticsDefinitions.TrivialSequentialCompositions);
                    continue;
                }
                this.mStatistics.reportComposition(LiptonReductionStatisticsDefinitions.ConcurrentSequentialCompositions);
            }
            if (!bl3 || !bl2) continue;
            hashSet.add(transition);
        }
        BoundedPetriNet<L, P> boundedPetriNet2 = this.copyPetriNetWithModification(boundedPetriNet, hashSet3, hashSet);
        for (Triple triple : hashSet3) {
            this.mCoEnabledRelation.copyRelationships(((Transition)triple.getSecond()).getSymbol(), triple.getFirst());
            this.updateSequentialCompositions(triple.getFirst(), ((Transition)triple.getSecond()).getSymbol(), ((Transition)triple.getThird()).getSymbol());
            this.transferMoverProperties(triple.getFirst(), ((Transition)triple.getSecond()).getSymbol(), ((Transition)triple.getThird()).getSymbol());
        }
        for (Transition transition : hashSet) {
            this.mCoEnabledRelation.deleteElement(transition.getSymbol());
            this.removeMoverProperties(transition.getSymbol());
            this.mSequentialCompositions.remove(transition.getSymbol());
        }
        return boundedPetriNet2;
    }

    private void updateSequentialCompositions(L l, L l2, L l3) {
        ArrayList<L> arrayList = new ArrayList<L>();
        if (this.mSequentialCompositions.containsKey(l2)) {
            arrayList.addAll((Collection)this.mSequentialCompositions.get(l2));
        } else {
            arrayList.add(l2);
        }
        if (this.mSequentialCompositions.containsKey(l3)) {
            arrayList.addAll((Collection)this.mSequentialCompositions.get(l3));
        } else {
            arrayList.add(l3);
        }
        this.mSequentialCompositions.put(l, arrayList);
    }

    private boolean sequenceRuleCheck(Transition<L, P> transition, Transition<L, P> transition2, P p, BoundedPetriNet<L, P> boundedPetriNet) {
        boolean bl;
        boolean bl2 = this.mCompositionFactory.isComposable(transition.getSymbol()) && this.mCompositionFactory.isComposable(transition2.getSymbol());
        boolean bl3 = transition2.getPredecessors().size() == 1 && !transition2.getSuccessors().contains(p);
        boolean bl4 = bl = this.isRightMover(transition) || this.isLeftMover(transition2);
        return bl2 && bl3 && bl;
    }

    private BoundedPetriNet<L, P> copyPetriNetWithModification(BoundedPetriNet<L, P> boundedPetriNet, Set<Triple<L, Transition<L, P>, Transition<L, P>>> set, Set<Transition<L, P>> set2) {
        for (Triple<L, Transition<L, P>, Transition<L, P>> object2 : set) {
            boundedPetriNet.getAlphabet().add(object2.getFirst());
            boundedPetriNet.addTransition(object2.getFirst(), ((Transition)object2.getSecond()).getPredecessors(), ((Transition)object2.getThird()).getSuccessors());
        }
        HashSet hashSet = new HashSet(boundedPetriNet.getTransitions());
        hashSet.removeAll(set2);
        return CopySubnet.copy(this.mServices, boundedPetriNet, hashSet, boundedPetriNet.getAlphabet(), true);
    }

    private boolean isLeftMover(Transition<L, P> transition) {
        Set<L> set = this.mCoEnabledRelation.getImage(transition.getSymbol());
        this.mStatistics.reportMoverChecks(set.size());
        return set.stream().allMatch(object -> this.mMoverCheck.isIndependent(null, object, transition.getSymbol()) == IIndependenceRelation.Dependence.INDEPENDENT);
    }

    private boolean isRightMover(Transition<L, P> transition) {
        Set<L> set = this.mCoEnabledRelation.getImage(transition.getSymbol());
        this.mStatistics.reportMoverChecks(set.size());
        return set.stream().allMatch(object -> this.mMoverCheck.isIndependent(null, transition.getSymbol(), object) == IIndependenceRelation.Dependence.INDEPENDENT);
    }

    public BoundedPetriNet<L, P> getResult() {
        return this.mResult;
    }

    public Map<L, List<L>> getSequentialCompositions() {
        return this.mSequentialCompositions;
    }

    public Map<L, Set<L>> getChoiceCompositions() {
        return this.mChoiceCompositions;
    }

    public LiptonReductionStatisticsGenerator getStatistics() {
        return this.mStatistics;
    }
}

