/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.builders;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.DisjunctiveAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractInterpretationResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg.RcfgDebugHelper;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.builders.IInterpolantAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;

public class AbsIntStraightLineInterpolantAutomatonBuilder<LETTER extends IIcfgTransition<?>>
implements IInterpolantAutomatonBuilder<LETTER, IPredicate> {
    private static final long PRINT_PREDS_LIMIT = 30L;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final NestedWordAutomaton<LETTER, IPredicate> mResult;
    private final CfgSmtToolkit mCsToolkit;
    private final Word<LETTER> mCurrentCounterExample;
    private final IIcfgSymbolTable mSymbolTable;

    public AbsIntStraightLineInterpolantAutomatonBuilder(IUltimateServiceProvider iUltimateServiceProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> iNwaOutgoingLetterAndTransitionProvider, IAbstractInterpretationResult<?, LETTER, ?> iAbstractInterpretationResult, IPredicateUnifier iPredicateUnifier, CfgSmtToolkit cfgSmtToolkit, Word<LETTER> word, SmtUtils.SimplificationTechnique simplificationTechnique, IIcfgSymbolTable iIcfgSymbolTable, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mCsToolkit = cfgSmtToolkit;
        this.mSymbolTable = iIcfgSymbolTable;
        this.mCurrentCounterExample = word;
        this.mResult = this.constructAutomaton(iNwaOutgoingLetterAndTransitionProvider, iAbstractInterpretationResult, iPredicateUnifier, iEmptyStackStateFactory);
    }

    @Override
    public NestedWordAutomaton<LETTER, IPredicate> getResult() {
        return this.mResult;
    }

    private <STATE extends IAbstractState<STATE>> NestedWordAutomaton<LETTER, IPredicate> constructAutomaton(INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> iNwaOutgoingLetterAndTransitionProvider, IAbstractInterpretationResult<STATE, LETTER, ?> iAbstractInterpretationResult, IPredicateUnifier iPredicateUnifier, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory) {
        RcfgDebugHelper rcfgDebugHelper = new RcfgDebugHelper(this.mCsToolkit, this.mServices, this.mSymbolTable);
        this.mLogger.info((Object)"Creating interpolant automaton from AI predicates (straight)");
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(new AutomataLibraryServices(this.mServices), iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet(), iEmptyStackStateFactory);
        int n = this.mCurrentCounterExample.length();
        assert (n > 1) : "Unexpected: length of word smaller or equal to 1.";
        TripleStack tripleStack = new TripleStack();
        IPredicate iPredicate2 = iPredicateUnifier.getFalsePredicate();
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
        Set set = Collections.emptySet();
        IPredicate iPredicate3 = iPredicateUnifier.getTruePredicate();
        hashSet.add(iPredicate3);
        nestedWordAutomaton.addState(true, false, (Object)iPredicate3);
        int n2 = 0;
        while (n2 < n) {
            IPredicate iPredicate4;
            Set set2;
            Triple triple;
            IIcfgTransition iIcfgTransition2 = (IIcfgTransition)this.mCurrentCounterExample.getSymbol(n2);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("CallStack Before" + tripleStack.getCalls().stream().map(iIcfgTransition -> "[" + String.valueOf(iIcfgTransition.hashCode()) + "]").reduce((string, string2) -> string + "," + string2).orElse("")));
            }
            if (iIcfgTransition2 instanceof ICallAction) {
                triple = this.getHierachicalPreState(iIcfgTransition2, iPredicate3, set, tripleStack);
                set2 = iAbstractInterpretationResult.getPostStates(tripleStack.getCalls(), (Object)iIcfgTransition2, set);
            } else if (iIcfgTransition2 instanceof IReturnAction) {
                triple = this.getHierachicalPreState(iIcfgTransition2, iPredicate3, set, tripleStack);
                set2 = iAbstractInterpretationResult.getPostStates(tripleStack.getCalls(), (Object)iIcfgTransition2, set);
            } else {
                set2 = iAbstractInterpretationResult.getPostStates(tripleStack.getCalls(), (Object)iIcfgTransition2, set);
                triple = this.getHierachicalPreState(iIcfgTransition2, iPredicate3, set, tripleStack);
            }
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("CallStack After" + tripleStack.getCalls().stream().map(iIcfgTransition -> "[" + String.valueOf(iIcfgTransition.hashCode()) + "]").reduce((string, string2) -> string + "," + string2).orElse("")));
            }
            if (hashSet.add(iPredicate4 = set2.isEmpty() ? iPredicate2 : iPredicateUnifier.getOrConstructPredicateForDisjunction((Collection)set2.stream().map(iAbstractState -> iAbstractState.getTerm(this.mCsToolkit.getManagedScript().getScript())).map(arg_0 -> ((IPredicateUnifier)iPredicateUnifier).getOrConstructPredicate(arg_0)).collect(Collectors.toSet())))) {
                nestedWordAutomaton.addState(false, iPredicate2.equals(iPredicate4), (Object)iPredicate4);
            }
            assert (this.isSound(set, triple, iIcfgTransition2, set2, rcfgDebugHelper)) : "About to insert unsound transition";
            if (iIcfgTransition2 instanceof Call) {
                nestedWordAutomaton.addCallTransition((Object)iPredicate3, (Object)iIcfgTransition2, (Object)iPredicate4);
            } else if (iIcfgTransition2 instanceof Return) {
                nestedWordAutomaton.addReturnTransition((Object)iPredicate3, (Object)((IPredicate)triple.getSecond()), (Object)iIcfgTransition2, (Object)iPredicate4);
            } else {
                nestedWordAutomaton.addInternalTransition((Object)iPredicate3, (Object)iIcfgTransition2, (Object)iPredicate4);
            }
            if (this.mLogger.isDebugEnabled()) {
                this.writeTransitionAddLog(n2, iIcfgTransition2, set2, iPredicate3, triple == null ? null : (IPredicate)triple.getSecond(), iPredicate4);
            }
            set = set2;
            iPredicate3 = iPredicate4;
            ++n2;
        }
        this.addSelfLoops(iNwaOutgoingLetterAndTransitionProvider, nestedWordAutomaton, tripleStack);
        if (30L < (long)hashSet.size()) {
            this.mLogger.info((Object)("Using " + hashSet.size() + " predicates from AI: " + String.join((CharSequence)",", hashSet.stream().limit(30L).map(iPredicate -> iPredicate.toString()).collect(Collectors.toList())) + "..."));
        } else {
            this.mLogger.info((Object)("Using " + hashSet.size() + " predicates from AI: " + String.join((CharSequence)",", hashSet.stream().map(iPredicate -> iPredicate.toString()).collect(Collectors.toList()))));
        }
        return nestedWordAutomaton;
    }

    private <STATE extends IAbstractState<STATE>> void addSelfLoops(INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> iNwaOutgoingLetterAndTransitionProvider, NestedWordAutomaton<LETTER, IPredicate> nestedWordAutomaton, TripleStack<STATE> tripleStack) {
        if (!nestedWordAutomaton.getFinalStates().isEmpty()) {
            for (IPredicate iPredicate : nestedWordAutomaton.getFinalStates()) {
                iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet().getInternalAlphabet().forEach(iIcfgTransition -> nestedWordAutomaton.addInternalTransition((Object)iPredicate, iIcfgTransition, (Object)iPredicate));
                iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet().getCallAlphabet().forEach(iIcfgTransition -> nestedWordAutomaton.addCallTransition((Object)iPredicate, iIcfgTransition, (Object)iPredicate));
                for (IIcfgTransition iIcfgTransition2 : iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet().getReturnAlphabet()) {
                    IIcfgReturnTransition iIcfgReturnTransition = (IIcfgReturnTransition)iIcfgTransition2;
                    nestedWordAutomaton.addReturnTransition((Object)iPredicate, (Object)iPredicate, (Object)iIcfgTransition2, (Object)iPredicate);
                    for (Triple triple : tripleStack) {
                        if (!iIcfgReturnTransition.getCorrespondingCall().equals(triple.getFirst())) continue;
                        nestedWordAutomaton.addReturnTransition((Object)iPredicate, (Object)((IPredicate)triple.getSecond()), (Object)iIcfgTransition2, (Object)iPredicate);
                    }
                }
            }
        }
    }

    private <STATE extends IAbstractState<STATE>> boolean isSound(Set<STATE> set, Triple<LETTER, IPredicate, Set<STATE>> triple, LETTER LETTER, Set<STATE> set2, RcfgDebugHelper<STATE, LETTER, IProgramVarOrConst, ?> rcfgDebugHelper) {
        DisjunctiveAbstractState disjunctiveAbstractState = triple == null ? null : DisjunctiveAbstractState.createDisjunction((Collection)((Collection)triple.getThird()));
        return rcfgDebugHelper.isPostSound(DisjunctiveAbstractState.createDisjunction(set), disjunctiveAbstractState, DisjunctiveAbstractState.createDisjunction(set2), LETTER);
    }

    private <STATE extends IAbstractState<STATE>> Triple<LETTER, IPredicate, Set<STATE>> getHierachicalPreState(LETTER LETTER, IPredicate iPredicate, Set<STATE> set, TripleStack<STATE> tripleStack) {
        Triple triple;
        if (LETTER instanceof ICallAction) {
            triple = new Triple(LETTER, (Object)iPredicate, set);
            tripleStack.addFirst(triple);
        } else if (LETTER instanceof IReturnAction) {
            assert (!tripleStack.isEmpty()) : "Return does not have a corresponding call.";
            triple = tripleStack.removeFirst();
        } else {
            triple = null;
        }
        return triple;
    }

    private <STATE extends IAbstractState<STATE>> void writeTransitionAddLog(int n, LETTER LETTER, Set<STATE> set, IPredicate iPredicate, IPredicate iPredicate2, IPredicate iPredicate3) {
        if (n == 0) {
            this.mLogger.debug((Object)"------------------------------------------------");
        }
        this.mLogger.debug((Object)("Transition: " + String.valueOf(LETTER)));
        if (set == null) {
            this.mLogger.debug((Object)"Post States: NONE");
        } else {
            this.mLogger.debug((Object)"Post States:");
            for (IAbstractState iAbstractState : set) {
                this.mLogger.debug((Object)("  " + String.valueOf(iAbstractState)));
            }
        }
        this.mLogger.debug((Object)("Pre: " + String.valueOf(iPredicate)));
        if (iPredicate2 != null) {
            this.mLogger.debug((Object)("HierPre: " + String.valueOf(iPredicate2)));
        }
        this.mLogger.debug((Object)("Post: " + String.valueOf(iPredicate3)));
        this.mLogger.debug((Object)("Post (S): " + String.valueOf(SmtUtils.simplify((ManagedScript)this.mCsToolkit.getManagedScript(), (Term)iPredicate3.getFormula(), (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA))));
        this.mLogger.debug((Object)"------------------------------------------------");
    }

    private final class TripleStack<STATE extends IAbstractState<STATE>>
    implements Iterable<Triple<LETTER, IPredicate, Set<STATE>>> {
        private final Deque<LETTER> mCalls = new ArrayDeque();
        private final Deque<IPredicate> mPredicates = new ArrayDeque<IPredicate>();
        private final Deque<Set<STATE>> mStates = new ArrayDeque<Set<STATE>>();

        private TripleStack() {
        }

        public Deque<LETTER> getCalls() {
            return this.mCalls;
        }

        public Triple<LETTER, IPredicate, Set<STATE>> removeFirst() {
            return new Triple((Object)((IIcfgTransition)this.mCalls.removeFirst()), (Object)this.mPredicates.removeFirst(), this.mStates.removeFirst());
        }

        public boolean isEmpty() {
            return this.mCalls.isEmpty();
        }

        public void addFirst(Triple<LETTER, IPredicate, Set<STATE>> triple) {
            this.mCalls.addFirst((IIcfgTransition)triple.getFirst());
            this.mPredicates.addFirst((IPredicate)triple.getSecond());
            this.mStates.addFirst((Set)triple.getThird());
        }

        public String toString() {
            return this.getCalls().toString();
        }

        @Override
        public Iterator<Triple<LETTER, IPredicate, Set<STATE>>> iterator() {
            return new Iterator<Triple<LETTER, IPredicate, Set<STATE>>>(){
                private final Iterator<LETTER> mCallIter;
                private final Iterator<IPredicate> mPredicatesIter;
                private final Iterator<Set<STATE>> mStatesIter;
                {
                    this.mCallIter = TripleStack.this.mCalls.iterator();
                    this.mPredicatesIter = TripleStack.this.mPredicates.iterator();
                    this.mStatesIter = TripleStack.this.mStates.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.mCallIter.hasNext();
                }

                @Override
                public Triple<LETTER, IPredicate, Set<STATE>> next() {
                    return new Triple((Object)((IIcfgTransition)this.mCallIter.next()), (Object)this.mPredicatesIter.next(), this.mStatesIter.next());
                }
            };
        }
    }
}

