/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.visualization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IOutgoingTransitionlet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.visualization.AutomatonState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.visualization.AutomatonTransition;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class NwaToUltimateModel<LETTER, STATE> {
    private static final String CREATING_NODE = "Creating Node: ";
    private final AutomataLibraryServices mServices;
    private final ILogger mLogger;
    private final INestedWordAutomaton<LETTER, STATE> mNWA;
    private final Map<STATE, AutomatonState> mConstructedStates = new HashMap<STATE, AutomatonState>();
    private final Deque<STATE> mQueue = new ArrayDeque<STATE>();

    public NwaToUltimateModel(AutomataLibraryServices automataLibraryServices, INwaOutgoingTransitionProvider<LETTER, STATE> iNwaOutgoingTransitionProvider) throws AutomataOperationCanceledException {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
        this.mNWA = iNwaOutgoingTransitionProvider instanceof INestedWordAutomaton ? (INestedWordAutomaton)iNwaOutgoingTransitionProvider : new NestedWordAutomatonReachableStates<LETTER, STATE>(this.mServices, iNwaOutgoingTransitionProvider);
    }

    public IElement transformToUltimateModel() {
        this.mConstructedStates.clear();
        this.mQueue.clear();
        AutomatonState automatonState = new AutomatonState("Sucessors of this node are the initial states", false);
        for (Object object : this.mNWA.getInitialStates()) {
            AutomatonState automatonState2 = this.getOrConstructState(object);
            new AutomatonTransition(automatonState, AutomatonTransition.Transition.INITIAL, "", null, automatonState2);
        }
        while (!this.mQueue.isEmpty()) {
            Object object;
            object = this.mQueue.removeFirst();
            Object object2 = this.mConstructedStates.get(object);
            this.addTransitions((AutomatonState)((Object)object2), AutomatonTransition.Transition.INTERNAL, null, this.mNWA.internalSuccessors(object));
            this.addTransitions((AutomatonState)((Object)object2), AutomatonTransition.Transition.CALL, null, this.mNWA.callSuccessors(object));
            for (AutomatonState automatonState2 : this.mNWA.getStates()) {
                this.addTransitions((AutomatonState)((Object)object2), AutomatonTransition.Transition.RETURN, ((Object)((Object)automatonState2)).toString(), this.mNWA.returnSuccessorsGivenHier((AutomatonState)((Object)object), automatonState2));
            }
        }
        return automatonState;
    }

    protected final AutomatonState getOrConstructState(STATE STATE) {
        return this.mConstructedStates.computeIfAbsent(STATE, this::createStateInternal);
    }

    private AutomatonState createStateInternal(STATE STATE) {
        AutomatonState automatonState = this.createState(STATE);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)(CREATING_NODE + automatonState.toString()));
        }
        this.mQueue.addLast(STATE);
        return automatonState;
    }

    protected AutomatonState createState(STATE STATE) {
        return new AutomatonState(STATE, this.mNWA.isFinal(STATE));
    }

    protected void addTransitions(AutomatonState automatonState, AutomatonTransition.Transition transition, String string, Iterable<? extends IOutgoingTransitionlet<LETTER, STATE>> iterable) {
        for (IOutgoingTransitionlet<LETTER, STATE> iOutgoingTransitionlet : iterable) {
            Object LETTER = iOutgoingTransitionlet.getLetter();
            STATE STATE = iOutgoingTransitionlet.getSucc();
            AutomatonState automatonState2 = this.getOrConstructState(STATE);
            new AutomatonTransition(automatonState, transition, LETTER, string, automatonState2);
        }
    }
}

