/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.model.preferences;

import java.util.LinkedHashMap;
import java.util.Map;

public final class KeyValueUtil {
    private static final String PAIR_SEPARATOR = ";";
    private static final String KV_SEPARATOR = "=";

    private KeyValueUtil() {
    }

    public static String toKeyValueString(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = KeyValueUtil.check(entry.getKey());
            String string2 = KeyValueUtil.check(entry.getValue());
            stringBuilder.append(string).append(KV_SEPARATOR).append(string2).append(PAIR_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    private static String check(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Key or value cannot be null");
        }
        if (string.contains(PAIR_SEPARATOR)) {
            throw new IllegalArgumentException(String.format("Key or value cannot contain %s", PAIR_SEPARATOR));
        }
        if (string.contains(KV_SEPARATOR)) {
            throw new IllegalArgumentException(String.format("Key or value cannot contain %s", KV_SEPARATOR));
        }
        return string;
    }

    public static Map<String, String> toMap(String string) {
        if (string == null || string.isEmpty()) {
            return new LinkedHashMap<String, String>();
        }
        String[] stringArray = string.split(PAIR_SEPARATOR);
        if (stringArray == null || stringArray.length == 0) {
            return new LinkedHashMap<String, String>();
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (KV_SEPARATOR.equals(string2)) {
                linkedHashMap.put("", "");
            } else {
                String[] stringArray3 = string2.split(KV_SEPARATOR);
                if (stringArray3.length != 2) {
                    throw new IllegalArgumentException(String.format("String %s is not of the form key=value", string2));
                }
                linkedHashMap.put(stringArray3[0], stringArray3[1]);
            }
            ++n2;
        }
        return linkedHashMap;
    }

    public static String toKeyValueString(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            String[] stringArray = String.valueOf(object).split(KV_SEPARATOR);
            if (stringArray.length == 0) {
                stringBuilder.append(KV_SEPARATOR).append(PAIR_SEPARATOR);
            } else if (stringArray.length == 2) {
                stringBuilder.append(KeyValueUtil.check(stringArray[0])).append(KV_SEPARATOR).append(KeyValueUtil.check(stringArray[1])).append(PAIR_SEPARATOR);
            } else {
                throw new IllegalArgumentException(String.format("Object %s is not of the form key=value", object));
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static boolean isValid(String string) {
        if (string == null) {
            return false;
        }
        if (string.contains(PAIR_SEPARATOR)) {
            return false;
        }
        return !string.contains(KV_SEPARATOR);
    }

    public static boolean isValid(Map.Entry<String, String> entry) {
        return KeyValueUtil.isValid(entry.getKey()) && KeyValueUtil.isValid(entry.getValue());
    }
}

