/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SolveForSubjectUtils;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class TermClassifier
extends NonRecursive {
    private static final boolean DIV_MOD_NEVER_LINEAR = false;
    private Set<Term> mTermsInWhichWeAlreadyDescended;
    private final Set<String> mOccuringSortNames = new HashSet<String>();
    private final Set<String> mOccuringFunctionNames = new HashSet<String>();
    private final Set<Integer> mOccuringQuantifiers = new HashSet<Integer>();
    private boolean mHasArrays = false;
    private boolean mHasNonlinearArithmetic;

    public Set<String> getOccuringSortNames() {
        return this.mOccuringSortNames;
    }

    public Set<String> getOccuringFunctionNames() {
        return this.mOccuringFunctionNames;
    }

    public Set<Integer> getOccuringQuantifiers() {
        return this.mOccuringQuantifiers;
    }

    public boolean hasArrays() {
        return this.mHasArrays;
    }

    public boolean hasNonlinearArithmetic() {
        return this.mHasNonlinearArithmetic;
    }

    public void checkTerm(Term term) {
        this.mTermsInWhichWeAlreadyDescended = new HashSet<Term>();
        this.run((NonRecursive.Walker)new MyWalker(term));
        this.mTermsInWhichWeAlreadyDescended = null;
    }

    private class MyWalker
    extends NonRecursive.TermWalker {
        MyWalker(Term term) {
            super(term);
        }

        public void walk(NonRecursive nonRecursive) {
            if (!TermClassifier.this.mTermsInWhichWeAlreadyDescended.contains(this.getTerm())) {
                Sort sort = this.getTerm().getSort();
                TermClassifier.this.mOccuringSortNames.add(sort.getName());
                if (sort.isArraySort()) {
                    TermClassifier.this.mHasArrays = true;
                }
                if (this.getTerm() instanceof ApplicationTerm) {
                    long l;
                    ApplicationTerm applicationTerm = (ApplicationTerm)this.getTerm();
                    if (applicationTerm.getFunction().getName().equals("*") && (l = Arrays.asList(applicationTerm.getParameters()).stream().filter(term -> !(term instanceof ConstantTerm)).count()) > 1L) {
                        TermClassifier.this.mHasNonlinearArithmetic = true;
                    }
                    if (applicationTerm.getFunction().getName().equals("mod") && !(applicationTerm.getParameters()[1] instanceof ConstantTerm)) {
                        TermClassifier.this.mHasNonlinearArithmetic = true;
                    }
                    if (applicationTerm.getFunction().getName().equals("div") && !SolveForSubjectUtils.tailIsConstant(Arrays.asList(applicationTerm.getParameters()))) {
                        TermClassifier.this.mHasNonlinearArithmetic = true;
                    }
                }
                super.walk(nonRecursive);
            }
        }

        public void walk(NonRecursive nonRecursive, ConstantTerm constantTerm) {
        }

        public void walk(NonRecursive nonRecursive, AnnotatedTerm annotatedTerm) {
            TermClassifier.this.mTermsInWhichWeAlreadyDescended.add((Term)annotatedTerm);
            nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(annotatedTerm.getSubterm()));
        }

        public void walk(NonRecursive nonRecursive, ApplicationTerm applicationTerm) {
            TermClassifier.this.mOccuringFunctionNames.add(applicationTerm.getFunction().getName());
            TermClassifier.this.mTermsInWhichWeAlreadyDescended.add((Term)applicationTerm);
            Term[] termArray = applicationTerm.getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray[n2];
                nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(term));
                ++n2;
            }
        }

        public void walk(NonRecursive nonRecursive, LetTerm letTerm) {
            TermClassifier.this.mTermsInWhichWeAlreadyDescended.add((Term)letTerm);
            nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(letTerm.getSubTerm()));
            Term[] termArray = letTerm.getValues();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray[n2];
                nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(term));
                ++n2;
            }
        }

        public void walk(NonRecursive nonRecursive, QuantifiedFormula quantifiedFormula) {
            TermClassifier.this.mOccuringQuantifiers.add(quantifiedFormula.getQuantifier());
            nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(quantifiedFormula.getSubformula()));
        }

        public void walk(NonRecursive nonRecursive, TermVariable termVariable) {
        }

        public void walk(NonRecursive nonRecursive, MatchTerm matchTerm) {
            throw new UnsupportedOperationException("not yet implemented: MatchTerm");
        }

        public void walk(NonRecursive nonRecursive, LambdaTerm lambdaTerm) {
            throw new UnsupportedOperationException();
        }
    }
}

