/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.IServiceFactoryFactory;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.SettingsManager;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.model.IAnalysis;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.IGenerator;
import de.uni_freiburg.informatik.ultimate.core.model.IOutput;
import de.uni_freiburg.informatik.ultimate.core.model.IServiceFactory;
import de.uni_freiburg.informatik.ultimate.core.model.ISource;
import de.uni_freiburg.informatik.ultimate.core.model.ITool;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainPlugin;
import de.uni_freiburg.informatik.ultimate.core.model.IUltimatePlugin;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public final class PluginFactory
implements IServiceFactoryFactory {
    private static final Class<?>[] ITOOLCHAIN_PLUGIN_CLASSES = new Class[]{IAnalysis.class, IGenerator.class, IOutput.class, ISource.class};
    private final IExtensionRegistry mRegistry;
    private final ILogger mLogger;
    private final SettingsManager mSettingsManager;
    private final Map<Class<?>, List<IConfigurationElement>> mAvailableToolsByClass;
    private final Map<String, IConfigurationElement> mAvailableToolsByClassName;
    private final Map<String, String> mPluginIDToClassName;
    private final Map<Class<?>, IServiceFactory<?>> mAvailableServicesByClassName;
    private final Set<IConfigurationElement> mFailedTools;
    private boolean mGuiMode;
    private final IController<RunDefinition> mController;
    private List<IToolchainPlugin> mToolchainPluginCache;
    private List<ITool> mToolCache;

    public PluginFactory(SettingsManager settingsManager, ILogger iLogger) {
        this.mLogger = iLogger;
        this.mRegistry = Platform.getExtensionRegistry();
        this.mAvailableToolsByClass = new HashMap();
        this.mAvailableToolsByClassName = new HashMap<String, IConfigurationElement>();
        this.mPluginIDToClassName = new HashMap<String, String>();
        this.mAvailableServicesByClassName = new HashMap();
        this.mFailedTools = new HashSet<IConfigurationElement>();
        this.mSettingsManager = settingsManager;
        this.mLogger.debug((Object)"--------------------------------------------------------------------------------");
        this.mLogger.debug((Object)"Detecting plugins...");
        this.registerType(IController.class);
        this.registerType(ISource.class);
        this.registerType(IOutput.class);
        this.registerType(IGenerator.class);
        this.registerType(IAnalysis.class);
        this.mController = this.loadControllerPlugin(this.mRegistry);
        this.mLogger.debug((Object)"Finished detecting plugins!");
        this.mLogger.debug((Object)"Loading services ...");
        this.registerType(IServiceFactory.class);
        this.mLogger.debug((Object)"Finished loading services!");
        this.mLogger.debug((Object)"--------------------------------------------------------------------------------");
    }

    IController<RunDefinition> getController() {
        return this.mController;
    }

    List<String> getPluginClassNames(Class<?> clazz) {
        List<IConfigurationElement> list = this.mAvailableToolsByClass.get(clazz);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (IConfigurationElement iConfigurationElement : list) {
                arrayList.add(iConfigurationElement.getAttribute("class"));
            }
        }
        return arrayList;
    }

    public List<String> getPluginIds() {
        return new ArrayList<String>(this.mPluginIDToClassName.keySet());
    }

    <T extends IToolchainPlugin> T createTool(String string) {
        IConfigurationElement iConfigurationElement = this.mAvailableToolsByClassName.get(string);
        if (iConfigurationElement == null) {
            iConfigurationElement = this.mAvailableToolsByClassName.get(this.mPluginIDToClassName.get(string));
        }
        IToolchainPlugin iToolchainPlugin = (IToolchainPlugin)this.createInstance(iConfigurationElement);
        return (T)this.prepareToolchainPlugin(iToolchainPlugin);
    }

    private <T extends IToolchainPlugin> T prepareToolchainPlugin(T t) {
        ITool iTool;
        if (t == null) {
            return null;
        }
        if (t instanceof ITool && (iTool = (ITool)t).isGuiRequired() && !this.mGuiMode) {
            this.mLogger.error((Object)("Cannot load plugin " + iTool.getPluginID() + ": Requires GUI controller"));
            return null;
        }
        this.mSettingsManager.registerPlugin((IUltimatePlugin)t);
        return t;
    }

    public List<IToolchainPlugin> getAllAvailableToolchainPlugins() {
        if (this.mToolchainPluginCache == null) {
            this.mToolchainPluginCache = this.loadAdmissiblePlugins();
        }
        ArrayList<IToolchainPlugin> arrayList = new ArrayList<IToolchainPlugin>(this.mToolchainPluginCache);
        return arrayList;
    }

    public List<ITool> getAllAvailableTools() {
        ArrayList<ITool> arrayList = new ArrayList<ITool>();
        if (this.mToolCache != null) {
            arrayList.addAll(this.mToolCache);
            return arrayList;
        }
        for (IToolchainPlugin iToolchainPlugin : this.getAllAvailableToolchainPlugins()) {
            if (!(iToolchainPlugin instanceof ITool)) continue;
            arrayList.add((ITool)iToolchainPlugin);
        }
        this.mToolchainPluginCache = new ArrayList<IToolchainPlugin>();
        this.mToolchainPluginCache.addAll(arrayList);
        return arrayList;
    }

    private List<IToolchainPlugin> loadAdmissiblePlugins() {
        ArrayList<IToolchainPlugin> arrayList = new ArrayList<IToolchainPlugin>();
        this.mLogger.debug((Object)"--------------------------------------------------------------------------------");
        this.mLogger.debug((Object)"Loading all admissible plugins (creating one instance, loading preferences)");
        int n = 0;
        HashSet<String> hashSet = new HashSet<String>();
        Class<?>[] classArray = ITOOLCHAIN_PLUGIN_CLASSES;
        int n2 = ITOOLCHAIN_PLUGIN_CLASSES.length;
        int n3 = 0;
        while (n3 < n2) {
            Class<?> clazz = classArray[n3];
            List<IConfigurationElement> list = this.mAvailableToolsByClass.get(clazz);
            if (list != null) {
                for (IConfigurationElement iConfigurationElement : list) {
                    try {
                        IToolchainPlugin iToolchainPlugin = this.prepareToolchainPlugin((IToolchainPlugin)this.createInstance(iConfigurationElement));
                        if (iToolchainPlugin == null) {
                            ++n;
                            continue;
                        }
                        if (!hashSet.add(iToolchainPlugin.getPluginID())) continue;
                        arrayList.add(iToolchainPlugin);
                    }
                    catch (Exception exception) {
                        this.mLogger.fatal((Object)("Exception during admissibility check of plugin " + iConfigurationElement.getName() + ": " + exception.getMessage()));
                    }
                }
            }
            ++n3;
        }
        this.mLogger.debug((Object)("Finished loading " + arrayList.size() + " admissible plugins" + (String)(n > 0 ? " (" + n + " not admissible)" : " (all were admissible)")));
        this.mLogger.debug((Object)"--------------------------------------------------------------------------------");
        return arrayList;
    }

    boolean isPluginAvailable(String string) {
        return this.mAvailableToolsByClassName.containsKey(string) || this.mPluginIDToClassName.containsKey(string);
    }

    private IController<RunDefinition> loadControllerPlugin(IExtensionRegistry iExtensionRegistry) {
        List<IConfigurationElement> list = this.mAvailableToolsByClass.get(IController.class);
        if (list.isEmpty()) {
            this.mLogger.fatal((Object)"Invalid configuration. You should have at least one IController plugin, but there are none.");
            return null;
        }
        if (list.size() == 1) {
            return this.loadControllerPlugin(list.get(0));
        }
        List list2 = list.stream().map(iConfigurationElement -> new Pair(iConfigurationElement, (Object)Integer.valueOf(iConfigurationElement.getAttribute("preference")))).collect(Collectors.toList());
        Optional<Pair> optional = list2.stream().min(Comparator.comparing(Pair::getSecond));
        if (!optional.isPresent()) {
            throw new AssertionError((Object)"Java8 is broken");
        }
        Pair pair2 = optional.get();
        int n = (Integer)pair2.getSecond();
        List list3 = list2.stream().filter(pair -> ((Integer)pair.getSecond()).equals(n)).collect(Collectors.toList());
        int n2 = list3.size();
        if (n2 == 1) {
            return this.loadControllerPlugin((IConfigurationElement)pair2.getFirst());
        }
        this.mLogger.fatal((Object)("Invalid configuration. You should have only one preferred IController plugin, but you have " + n2));
        for (Pair pair3 : list3) {
            this.mLogger.fatal((Object)(((IConfigurationElement)pair3.getFirst()).getAttribute("class") + " has preference value " + String.valueOf(pair3.getSecond())));
        }
        return null;
    }

    private IController<RunDefinition> loadControllerPlugin(IConfigurationElement iConfigurationElement) {
        IController iController = (IController)this.createInstance(iConfigurationElement);
        this.mGuiMode = Boolean.valueOf(iConfigurationElement.getAttribute("isGraphical"));
        this.mSettingsManager.registerPlugin((IUltimatePlugin)iController);
        this.mLogger.debug((Object)("Loaded " + (this.mGuiMode ? "graphical " : "") + "controller " + iController.getPluginName()));
        return iController;
    }

    private <T extends IUltimatePlugin> T createInstance(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement == null) {
            return null;
        }
        if (this.mFailedTools.contains(iConfigurationElement)) {
            this.mLogger.warn((Object)("Will not retry already failed Ultimate plugin " + iConfigurationElement.getAttribute("class")));
            return null;
        }
        try {
            return (T)((IUltimatePlugin)iConfigurationElement.createExecutableExtension("class"));
        }
        catch (CoreException coreException) {
            this.mLogger.fatal((Object)("Exception during instantiation of Ultimate plugin " + iConfigurationElement.getAttribute("class")), (Throwable)coreException);
            this.mFailedTools.add(iConfigurationElement);
            return null;
        }
    }

    private void registerType(Class<?> clazz) {
        if (clazz.equals(IServiceFactory.class)) {
            IConfigurationElement[] iConfigurationElementArray = this.mRegistry.getConfigurationElementsFor(PluginFactory.getExtensionPointFromClass(clazz));
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                String string = iConfigurationElement.getAttribute("class");
                try {
                    Class<?> clazz2 = Class.forName(string);
                    IServiceFactory iServiceFactory = (IServiceFactory)this.createInstance(iConfigurationElement);
                    this.mSettingsManager.registerPlugin((IUltimatePlugin)iServiceFactory);
                    this.registerClassAndAllInterfaces(clazz2, iServiceFactory);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.mLogger.fatal((Object)("Cannot register type: " + String.valueOf(classNotFoundException)));
                }
                ++n2;
            }
            this.mLogger.debug((Object)(this.mAvailableServicesByClassName.size() + " " + clazz.getSimpleName() + " services available"));
        } else {
            this.registerTool(clazz);
        }
    }

    private void registerClassAndAllInterfaces(Class<?> clazz, IServiceFactory<?> iServiceFactory) {
        this.mAvailableServicesByClassName.put(clazz, iServiceFactory);
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz2 = classArray[n2];
            if (!clazz2.equals(IServiceFactory.class)) {
                this.registerClassAndAllInterfaces(clazz2, iServiceFactory);
            }
            ++n2;
        }
    }

    private void registerTool(Class<?> clazz) {
        ArrayList<IConfigurationElement> arrayList = new ArrayList<IConfigurationElement>();
        this.mAvailableToolsByClass.put(clazz, arrayList);
        IConfigurationElement[] iConfigurationElementArray = this.mRegistry.getConfigurationElementsFor(PluginFactory.getExtensionPointFromClass(clazz));
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            arrayList.add(iConfigurationElement);
            String string = iConfigurationElement.getAttribute("class");
            this.mAvailableToolsByClassName.put(string, iConfigurationElement);
            this.mPluginIDToClassName.put(PluginFactory.createPluginID(string), string);
            ++n2;
        }
        this.mLogger.debug((Object)(arrayList.size() + " " + clazz.getSimpleName() + " plugins available"));
    }

    private static String createPluginID(String string) {
        return string.substring(0, string.lastIndexOf(46));
    }

    private static String getExtensionPointFromClass(Class<?> clazz) {
        String string;
        switch (string = clazz.getName()) {
            case "de.uni_freiburg.informatik.ultimate.core.model.IController": {
                return "de.uni_freiburg.informatik.ultimate.ep.controller";
            }
            case "de.uni_freiburg.informatik.ultimate.core.model.ISource": {
                return "de.uni_freiburg.informatik.ultimate.ep.source";
            }
            case "de.uni_freiburg.informatik.ultimate.core.model.IOutput": {
                return "de.uni_freiburg.informatik.ultimate.ep.output";
            }
            case "de.uni_freiburg.informatik.ultimate.core.model.IGenerator": {
                return "de.uni_freiburg.informatik.ultimate.ep.generator";
            }
            case "de.uni_freiburg.informatik.ultimate.core.model.IAnalysis": {
                return "de.uni_freiburg.informatik.ultimate.ep.analysis";
            }
            case "de.uni_freiburg.informatik.ultimate.core.model.IServiceFactory": {
                return "de.uni_freiburg.informatik.ultimate.ep.service";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public <T, K extends IServiceFactory<T>> T createService(Class<K> clazz, IUltimateServiceProvider iUltimateServiceProvider, IToolchainStorage iToolchainStorage) {
        IServiceFactory<?> iServiceFactory = this.mAvailableServicesByClassName.get(clazz);
        if (iServiceFactory == null) {
            return null;
        }
        IServiceFactory iServiceFactory2 = (IServiceFactory)clazz.cast(iServiceFactory);
        return (T)iServiceFactory2.createInstance(iUltimateServiceProvider, iToolchainStorage);
    }
}

