/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Analyze;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaMaxSat2;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaPmaxSatDirectBi;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeSevpa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.NwaApproximateBisimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.NwaApproximateXsimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.ShrinkNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.SimulationOrMinimizationType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.delayed.nwa.DelayedNwaGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.delayed.nwa.DelayedNwaSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.direct.nwa.DirectNwaGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.direct.nwa.DirectNwaSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair.nwa.FairNwaGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair.nwa.FairNwaSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.multipebble.ReduceNwaDelayedFullMultipebbleSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.multipebble.ReduceNwaDirectFullMultipebbleSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.CompareReduceBuchiSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.CountingMeasure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;

public final class CompareReduceNwaSimulation<LETTER, STATE>
extends CompareReduceBuchiSimulation<LETTER, STATE> {
    public CompareReduceNwaSimulation(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMinimizationStateFactory, iNwaOutgoingLetterAndTransitionProvider);
    }

    @Override
    public void verifyAutomatonValidity(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) {
    }

    @Override
    protected void addGeneralAutomataPerformanceForExternalMethod(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton2) {
        super.addGeneralAutomataPerformanceForExternalMethod(iNestedWordAutomaton, iNestedWordAutomaton2);
        AutomataLibraryServices automataLibraryServices = this.getServices();
        Analyze<LETTER, STATE> analyze = new Analyze<LETTER, STATE>(automataLibraryServices, iNestedWordAutomaton, true);
        this.mCountingMeasures.put(CountingMeasure.BUCHI_ALPHABET_SIZE_INTERNAL, analyze.getNumberOfSymbols(Analyze.SymbolType.INTERNAL));
        this.mCountingMeasures.put(CountingMeasure.BUCHI_ALPHABET_SIZE_CALL, analyze.getNumberOfSymbols(Analyze.SymbolType.CALL));
        this.mCountingMeasures.put(CountingMeasure.BUCHI_ALPHABET_SIZE_RETURN, analyze.getNumberOfSymbols(Analyze.SymbolType.RETURN));
        this.mCountingMeasures.put(CountingMeasure.BUCHI_TRANSITIONS_INTERNAL, analyze.getNumberOfTransitions(Analyze.SymbolType.INTERNAL));
        this.mCountingMeasures.put(CountingMeasure.BUCHI_TRANSITIONS_CALL, analyze.getNumberOfTransitions(Analyze.SymbolType.CALL));
        this.mCountingMeasures.put(CountingMeasure.BUCHI_TRANSITIONS_RETURN, analyze.getNumberOfTransitions(Analyze.SymbolType.RETURN));
        this.mCountingMeasures.put(CountingMeasure.BUCHI_TRANSITION_INTERNAL_DENSITY_MILLION, (int)Math.round(analyze.getTransitionDensity(Analyze.SymbolType.INTERNAL) * 1000000.0));
        this.mCountingMeasures.put(CountingMeasure.BUCHI_TRANSITION_CALL_DENSITY_MILLION, (int)Math.round(analyze.getTransitionDensity(Analyze.SymbolType.CALL) * 1000000.0));
        this.mCountingMeasures.put(CountingMeasure.BUCHI_TRANSITION_RETURN_DENSITY_MILLION, (int)Math.round(analyze.getTransitionDensity(Analyze.SymbolType.RETURN) * 1000000.0));
        Analyze<LETTER, STATE> analyze2 = new Analyze<LETTER, STATE>(automataLibraryServices, iNestedWordAutomaton2, true);
        this.mCountingMeasures.put(CountingMeasure.RESULT_ALPHABET_SIZE_INTERNAL, analyze2.getNumberOfSymbols(Analyze.SymbolType.INTERNAL));
        this.mCountingMeasures.put(CountingMeasure.RESULT_ALPHABET_SIZE_CALL, analyze2.getNumberOfSymbols(Analyze.SymbolType.CALL));
        this.mCountingMeasures.put(CountingMeasure.RESULT_ALPHABET_SIZE_RETURN, analyze2.getNumberOfSymbols(Analyze.SymbolType.RETURN));
        this.mCountingMeasures.put(CountingMeasure.RESULT_TRANSITIONS_INTERNAL, analyze2.getNumberOfTransitions(Analyze.SymbolType.INTERNAL));
        this.mCountingMeasures.put(CountingMeasure.RESULT_TRANSITIONS_CALL, analyze2.getNumberOfTransitions(Analyze.SymbolType.CALL));
        this.mCountingMeasures.put(CountingMeasure.RESULT_TRANSITIONS_RETURN, analyze2.getNumberOfTransitions(Analyze.SymbolType.RETURN));
        this.mCountingMeasures.put(CountingMeasure.RESULT_TRANSITION_INTERNAL_DENSITY_MILLION, (int)Math.round(analyze2.getTransitionDensity(Analyze.SymbolType.INTERNAL) * 1000000.0));
        this.mCountingMeasures.put(CountingMeasure.RESULT_TRANSITION_CALL_DENSITY_MILLION, (int)Math.round(analyze2.getTransitionDensity(Analyze.SymbolType.CALL) * 1000000.0));
        this.mCountingMeasures.put(CountingMeasure.RESULT_TRANSITION_RETURN_DENSITY_MILLION, (int)Math.round(analyze2.getTransitionDensity(Analyze.SymbolType.RETURN) * 1000000.0));
    }

    @Override
    protected void measureMethodPerformance(String string, SimulationOrMinimizationType simulationOrMinimizationType, boolean bl, AutomataLibraryServices automataLibraryServices, long l, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        ILogger iLogger = this.getLogger();
        IProgressAwareTimer iProgressAwareTimer = automataLibraryServices.getProgressAwareTimer().getChildTimer(l);
        boolean bl2 = false;
        boolean bl3 = false;
        AbstractMinimizeNwa abstractMinimizeNwa = null;
        if (!(iNestedWordAutomaton instanceof IDoubleDeckerAutomaton)) {
            throw new IllegalArgumentException("Input must be of type " + String.valueOf(IDoubleDeckerAutomaton.class));
        }
        IDoubleDeckerAutomaton iDoubleDeckerAutomaton = (IDoubleDeckerAutomaton)iNestedWordAutomaton;
        boolean bl4 = simulationOrMinimizationType == SimulationOrMinimizationType.DIRECT || simulationOrMinimizationType == SimulationOrMinimizationType.DIRECT_FULL_MULTIPEBBLE;
        try {
            Object object = ((PartitionBackedSetOfPairs)new NwaApproximateBisimulation(automataLibraryServices, iDoubleDeckerAutomaton, bl4 ? NwaApproximateXsimulation.SimulationType.DIRECT : NwaApproximateXsimulation.SimulationType.ORDINARY).getResult()).getRelation();
            if (simulationOrMinimizationType.equals((Object)SimulationOrMinimizationType.DIRECT)) {
                DirectNwaGameGraph directNwaGameGraph = new DirectNwaGameGraph(automataLibraryServices, iMinimizationStateFactory, iProgressAwareTimer, iLogger, iDoubleDeckerAutomaton, object);
                directNwaGameGraph.generateGameGraphFromAutomaton();
                DirectNwaSimulation directNwaSimulation = new DirectNwaSimulation(iProgressAwareTimer, iLogger, bl, iMinimizationStateFactory, directNwaGameGraph);
                directNwaSimulation.doSimulation();
                abstractMinimizeNwa = directNwaSimulation;
            } else if (simulationOrMinimizationType.equals((Object)SimulationOrMinimizationType.DELAYED)) {
                DelayedNwaGameGraph delayedNwaGameGraph = new DelayedNwaGameGraph(automataLibraryServices, iMinimizationStateFactory, iProgressAwareTimer, iLogger, iDoubleDeckerAutomaton, object);
                delayedNwaGameGraph.generateGameGraphFromAutomaton();
                DelayedNwaSimulation delayedNwaSimulation = new DelayedNwaSimulation(iProgressAwareTimer, iLogger, bl, iMinimizationStateFactory, delayedNwaGameGraph);
                delayedNwaSimulation.doSimulation();
                abstractMinimizeNwa = delayedNwaSimulation;
            } else if (simulationOrMinimizationType.equals((Object)SimulationOrMinimizationType.FAIR)) {
                FairNwaGameGraph fairNwaGameGraph = new FairNwaGameGraph(automataLibraryServices, iMinimizationStateFactory, iProgressAwareTimer, iLogger, iDoubleDeckerAutomaton, object);
                fairNwaGameGraph.generateGameGraphFromAutomaton();
                FairNwaSimulation fairNwaSimulation = new FairNwaSimulation(iProgressAwareTimer, iLogger, bl, iMinimizationStateFactory, fairNwaGameGraph);
                fairNwaSimulation.doSimulation();
                abstractMinimizeNwa = fairNwaSimulation;
            } else if (simulationOrMinimizationType.equals((Object)SimulationOrMinimizationType.DIRECT_FULL_MULTIPEBBLE)) {
                long l2 = System.currentTimeMillis();
                abstractMinimizeNwa = new ReduceNwaDirectFullMultipebbleSimulation(automataLibraryServices, iMinimizationStateFactory, iDoubleDeckerAutomaton);
                this.setExternalOverallTime(System.currentTimeMillis() - l2);
            } else if (simulationOrMinimizationType.equals((Object)SimulationOrMinimizationType.DELAYED_FULL_MULTIPEBBLE)) {
                long l3 = System.currentTimeMillis();
                abstractMinimizeNwa = new ReduceNwaDelayedFullMultipebbleSimulation(automataLibraryServices, iMinimizationStateFactory, iDoubleDeckerAutomaton);
                this.setExternalOverallTime(System.currentTimeMillis() - l3);
            } else if (simulationOrMinimizationType.equals((Object)SimulationOrMinimizationType.EXT_MINIMIZESEVPA)) {
                long l4 = System.currentTimeMillis();
                abstractMinimizeNwa = new MinimizeSevpa(this.getServices(), iMinimizationStateFactory, iDoubleDeckerAutomaton);
                this.setExternalOverallTime(System.currentTimeMillis() - l4);
            } else if (simulationOrMinimizationType.equals((Object)SimulationOrMinimizationType.EXT_SHRINKNWA)) {
                long l5 = System.currentTimeMillis();
                abstractMinimizeNwa = new ShrinkNwa(this.getServices(), iMinimizationStateFactory, iDoubleDeckerAutomaton);
                this.setExternalOverallTime(System.currentTimeMillis() - l5);
            } else if (simulationOrMinimizationType.equals((Object)SimulationOrMinimizationType.EXT_MINIMIZENWAMAXSAT)) {
                long l6 = System.currentTimeMillis();
                abstractMinimizeNwa = new MinimizeNwaPmaxSatDirectBi(automataLibraryServices, iMinimizationStateFactory, iDoubleDeckerAutomaton, new PartitionBackedSetOfPairs(object), new MinimizeNwaMaxSat2.Settings().setLibraryMode(false));
                this.setExternalOverallTime(System.currentTimeMillis() - l6);
            }
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            iLogger.info((Object)"Method timed out.");
            bl2 = true;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            iLogger.info((Object)"Method has thrown an out of memory error.");
            bl3 = true;
        }
        this.appendMethodPerformanceToLog(abstractMinimizeNwa, string, simulationOrMinimizationType, bl, bl2, bl3, iDoubleDeckerAutomaton);
    }

    @Override
    protected void measurePerformances(String string, long l, IMinimizationStateFactory<STATE> iMinimizationStateFactory, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates) {
        this.measureMethodPerformance(string, SimulationOrMinimizationType.DIRECT_FULL_MULTIPEBBLE, false, this.getServices(), l, iMinimizationStateFactory, nestedWordAutomatonReachableStates);
        this.measureMethodPerformance(string, SimulationOrMinimizationType.DELAYED_FULL_MULTIPEBBLE, false, this.getServices(), l, iMinimizationStateFactory, nestedWordAutomatonReachableStates);
    }
}

