/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.variables;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;

public class LassoUnderConstruction {
    private final ModifiableTransFormula mStem;
    private final ModifiableTransFormula mLoop;
    private final long mStemSize;
    private final long mLoopSize;

    public LassoUnderConstruction(ModifiableTransFormula modifiableTransFormula, ModifiableTransFormula modifiableTransFormula2) {
        this.mStem = modifiableTransFormula;
        this.mLoop = modifiableTransFormula2;
        this.mStemSize = new DAGSize().treesize(this.mStem.getFormula());
        this.mLoopSize = new DAGSize().treesize(this.mLoop.getFormula());
    }

    public ModifiableTransFormula getStem() {
        return this.mStem;
    }

    public ModifiableTransFormula getLoop() {
        return this.mLoop;
    }

    public long getFormulaSize() {
        return this.mStemSize + this.mLoopSize;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Stem:" + System.lineSeparator());
        stringBuilder.append(this.getStem());
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append("Loop:" + System.lineSeparator());
        stringBuilder.append(this.getLoop());
        return stringBuilder.toString();
    }

    public Script.LBool checkStemFeasiblity(Script script) {
        Term term = this.mStem.getFormula();
        Script.LBool lBool = Util.checkSat((Script)script, (Term)term);
        return lBool;
    }
}

