/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.symboltable.BoogieSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.boogie.ScopedBoogieVar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class ScopedBoogieVarBuilder {
    private final BoogieSymbolTable mSymbolTable;
    private final Hashtable<VariableUID, ScopedBoogieVar> mVarCache;

    public ScopedBoogieVarBuilder(BoogieSymbolTable boogieSymbolTable) {
        this.mSymbolTable = boogieSymbolTable;
        this.mVarCache = new Hashtable();
    }

    public ScopedBoogieVar getScopedBoogieVar(VariableLHS variableLHS, UnmodifiableTransFormula unmodifiableTransFormula) {
        return this.getScopedBoogieVar(variableLHS.getIdentifier(), variableLHS.getDeclarationInformation(), unmodifiableTransFormula);
    }

    public ScopedBoogieVar getScopedBoogieVar(IdentifierExpression identifierExpression, UnmodifiableTransFormula unmodifiableTransFormula) {
        return this.getScopedBoogieVar(identifierExpression.getIdentifier(), identifierExpression.getDeclarationInformation(), unmodifiableTransFormula);
    }

    private ScopedBoogieVar getScopedBoogieVar(String string, DeclarationInformation declarationInformation, UnmodifiableTransFormula unmodifiableTransFormula) {
        VariableDeclaration variableDeclaration = (VariableDeclaration)this.mSymbolTable.getDeclaration(string, declarationInformation.getStorageClass(), declarationInformation.getProcedure());
        VariableUID variableUID = new VariableUID(variableDeclaration, string);
        ScopedBoogieVar scopedBoogieVar = this.mVarCache.get(variableUID);
        if (scopedBoogieVar == null) {
            IProgramVar iProgramVar = this.getBoogieVarFromTransformula(string, declarationInformation, unmodifiableTransFormula);
            scopedBoogieVar = new ScopedBoogieVar(string, variableDeclaration, declarationInformation, iProgramVar);
            this.mVarCache.put(variableUID, scopedBoogieVar);
        }
        return scopedBoogieVar;
    }

    private IProgramVar getBoogieVarFromTransformula(String string, DeclarationInformation declarationInformation, UnmodifiableTransFormula unmodifiableTransFormula) {
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        hashSet.add(this.getBoogieVarFromSet(string, declarationInformation, unmodifiableTransFormula.getInVars().keySet()));
        hashSet.add(this.getBoogieVarFromSet(string, declarationInformation, unmodifiableTransFormula.getOutVars().keySet()));
        hashSet.add(this.getBoogieVarFromSet(string, declarationInformation, unmodifiableTransFormula.getAssignedVars()));
        hashSet.remove(null);
        if (hashSet.size() != 1) {
            throw new UnsupportedOperationException("Could not find matching BoogieVar");
        }
        return (IProgramVar)hashSet.iterator().next();
    }

    private IProgramVar getBoogieVarFromSet(String string, DeclarationInformation declarationInformation, Set<IProgramVar> set) {
        for (IProgramVar iProgramVar : set) {
            if (iProgramVar instanceof ILocalProgramVar) {
                if (!((ILocalProgramVar)iProgramVar).getIdentifier().equals(string)) continue;
                return iProgramVar;
            }
            if (iProgramVar instanceof IProgramNonOldVar) {
                if (!((ILocalProgramVar)iProgramVar).getIdentifier().equals(string)) continue;
                return iProgramVar;
            }
            if (iProgramVar instanceof IProgramOldVar) continue;
            throw new UnsupportedOperationException("unknown king of IProgramVarIProgramVar " + iProgramVar.getClass().getSimpleName());
        }
        return null;
    }

    private class VariableUID {
        private final VariableDeclaration Declaration;
        private final String Identifier;

        public VariableUID(VariableDeclaration variableDeclaration, String string) {
            this.Declaration = variableDeclaration;
            this.Identifier = string;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + (this.Declaration == null ? 0 : this.Declaration.hashCode());
            n = 31 * n + (this.Identifier == null ? 0 : this.Identifier.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            VariableUID variableUID = (VariableUID)object;
            if (!this.getOuterType().equals(variableUID.getOuterType())) {
                return false;
            }
            if (this.Declaration == null ? variableUID.Declaration != null : !this.Declaration.equals(variableUID.Declaration)) {
                return false;
            }
            return !(this.Identifier == null ? variableUID.Identifier != null : !this.Identifier.equals(variableUID.Identifier));
        }

        private ScopedBoogieVarBuilder getOuterType() {
            return ScopedBoogieVarBuilder.this;
        }
    }
}

