/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.muses;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.ConstraintAdministrationSolver;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.MusContainer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.MusUtils;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.UnexploredMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.TerminationRequest;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Random;

public class Shrinking {
    public static MusContainer shrink(ConstraintAdministrationSolver constraintAdministrationSolver, BitSet bitSet, UnexploredMap unexploredMap, TerminationRequest terminationRequest, Random random, boolean bl) throws SMTLIBException {
        BitSet bitSet2;
        constraintAdministrationSolver.pushRecLevel();
        if (!MusUtils.contains(bitSet, constraintAdministrationSolver.getCrits())) {
            throw new SMTLIBException("WorkingConstraints is corrupted! It should contain all crits.");
        }
        BitSet bitSet3 = (BitSet)bitSet.clone();
        bitSet3.andNot(constraintAdministrationSolver.getCrits());
        ArrayList<Integer> arrayList = MusUtils.randomPermutation(bitSet3, random);
        Term term = null;
        while (!arrayList.isEmpty()) {
            int n = MusUtils.pop(arrayList);
            if (!bitSet3.get(n)) continue;
            int n2 = bitSet3.nextSetBit(0);
            while (n2 >= 0) {
                if (n2 != n) {
                    constraintAdministrationSolver.assertUnknownConstraint(n2);
                }
                n2 = bitSet3.nextSetBit(n2 + 1);
            }
            bitSet3.clear(n);
            switch (constraintAdministrationSolver.checkSat()) {
                case UNSAT: {
                    BitSet bitSet4 = constraintAdministrationSolver.getUnsatCore();
                    if (bl) {
                        term = constraintAdministrationSolver.getProof();
                    }
                    bitSet3.and(bitSet4);
                    constraintAdministrationSolver.clearUnknownConstraints();
                    break;
                }
                case SAT: {
                    if (bl) {
                        constraintAdministrationSolver.clearUnknownConstraints();
                        bitSet2 = constraintAdministrationSolver.getCrits();
                        bitSet2.or(bitSet3);
                        unexploredMap.BlockDown(bitSet2);
                    } else {
                        bitSet2 = constraintAdministrationSolver.getSatExtension(terminationRequest);
                        if (bitSet2 == null) {
                            return null;
                        }
                        unexploredMap.BlockDown(bitSet2);
                        constraintAdministrationSolver.clearUnknownConstraints();
                    }
                    constraintAdministrationSolver.assertCriticalConstraint(n);
                    break;
                }
                case UNKNOWN: {
                    if (terminationRequest != null && terminationRequest.isTerminationRequested()) {
                        return null;
                    }
                    if (!bl) {
                        throw new SMTLIBException("LBool.UNKNOWN occured in the shrinking process, despite not being explicitly allowed.");
                    }
                    constraintAdministrationSolver.clearUnknownConstraints();
                    bitSet2 = constraintAdministrationSolver.getCrits();
                    bitSet2.or(bitSet3);
                    unexploredMap.BlockDown(bitSet2);
                    constraintAdministrationSolver.assertCriticalConstraint(n);
                }
            }
        }
        switch (constraintAdministrationSolver.checkSat()) {
            case UNSAT: {
                break;
            }
            case SAT: {
                throw new SMTLIBException("Something went wrong, the set of all crits should be unsatisfiable!");
            }
            case UNKNOWN: {
                if (terminationRequest != null && terminationRequest.isTerminationRequested()) {
                    return null;
                }
                if (bl) {
                    BitSet bitSet5 = constraintAdministrationSolver.getCrits();
                    unexploredMap.BlockUp(bitSet5);
                    unexploredMap.BlockDown(bitSet5);
                    constraintAdministrationSolver.popRecLevel();
                    assert (term != null) : "The case described in the comment above did not occur, so this is an unexpected behaviour";
                    return new MusContainer(bitSet5, term);
                }
                throw new SMTLIBException("Solver returns UNKNOWN for final set in shrink procedure.");
            }
        }
        Term term2 = constraintAdministrationSolver.getProof();
        bitSet2 = constraintAdministrationSolver.getCrits();
        unexploredMap.BlockUp(bitSet2);
        unexploredMap.BlockDown(bitSet2);
        constraintAdministrationSolver.popRecLevel();
        return new MusContainer(bitSet2, term2);
    }

    public static MusContainer shrink(ConstraintAdministrationSolver constraintAdministrationSolver, BitSet bitSet, UnexploredMap unexploredMap, Random random, boolean bl) {
        return Shrinking.shrink(constraintAdministrationSolver, bitSet, unexploredMap, null, random, bl);
    }

    public static MusContainer shrink(ConstraintAdministrationSolver constraintAdministrationSolver, BitSet bitSet, TerminationRequest terminationRequest, Random random, boolean bl) throws SMTLIBException {
        BitSet bitSet2;
        constraintAdministrationSolver.pushRecLevel();
        if (!MusUtils.contains(bitSet, constraintAdministrationSolver.getCrits())) {
            throw new SMTLIBException("WorkingConstraints is corrupted! It should contain all crits.");
        }
        BitSet bitSet3 = (BitSet)bitSet.clone();
        bitSet3.andNot(constraintAdministrationSolver.getCrits());
        ArrayList<Integer> arrayList = MusUtils.randomPermutation(bitSet3, random);
        Term term = null;
        while (!arrayList.isEmpty()) {
            int n = arrayList.get(arrayList.size() - 1);
            arrayList.remove(arrayList.size() - 1);
            if (!bitSet3.get(n)) continue;
            int n2 = bitSet3.nextSetBit(0);
            while (n2 >= 0) {
                if (n2 != n) {
                    constraintAdministrationSolver.assertUnknownConstraint(n2);
                }
                n2 = bitSet3.nextSetBit(n2 + 1);
            }
            bitSet3.clear(n);
            switch (constraintAdministrationSolver.checkSat()) {
                case UNSAT: {
                    BitSet bitSet4 = constraintAdministrationSolver.getUnsatCore();
                    if (bl) {
                        term = constraintAdministrationSolver.getProof();
                    }
                    bitSet3.and(bitSet4);
                    constraintAdministrationSolver.clearUnknownConstraints();
                    break;
                }
                case SAT: {
                    constraintAdministrationSolver.clearUnknownConstraints();
                    constraintAdministrationSolver.assertCriticalConstraint(n);
                    break;
                }
                case UNKNOWN: {
                    if (terminationRequest != null && terminationRequest.isTerminationRequested()) {
                        return null;
                    }
                    if (!bl) {
                        throw new SMTLIBException("LBool.UNKNOWN occured in the shrinking process, despite not being explicitly allowed.");
                    }
                    bitSet2 = constraintAdministrationSolver.getCrits();
                    bitSet2.or(bitSet3);
                    constraintAdministrationSolver.clearUnknownConstraints();
                    constraintAdministrationSolver.assertCriticalConstraint(n);
                }
            }
        }
        switch (constraintAdministrationSolver.checkSat()) {
            case UNSAT: {
                break;
            }
            case SAT: {
                throw new SMTLIBException("Something went wrong, the set of all crits should be unsatisfiable!");
            }
            case UNKNOWN: {
                if (terminationRequest != null && terminationRequest.isTerminationRequested()) {
                    return null;
                }
                if (bl) {
                    BitSet bitSet5 = constraintAdministrationSolver.getCrits();
                    constraintAdministrationSolver.popRecLevel();
                    if (term == null) {
                        throw new SMTLIBException("The case described in the comment above did not occur, so this is an unexpected behaviour.");
                    }
                    return new MusContainer(bitSet5, term);
                }
                throw new SMTLIBException("Solver returns UNKNOWN for final set in shrink procedure.");
            }
        }
        Term term2 = constraintAdministrationSolver.getProof();
        constraintAdministrationSolver.clearUnknownConstraints();
        bitSet2 = constraintAdministrationSolver.getCrits();
        constraintAdministrationSolver.popRecLevel();
        return new MusContainer(bitSet2, term2);
    }
}

