/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayStoreExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.boogie.symboltable.BoogieSymbolTable;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IBoogieSymbolTableVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.BooleanValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.Evaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.EvaluatorUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.ExpressionEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.IEvaluationResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.IEvaluatorFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.NAryEvaluator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class NonrelationalEvaluator<STATE extends NonrelationalState<STATE, V>, V extends INonrelationalValue<V>>
extends BoogieVisitor {
    private ExpressionEvaluator<V, STATE> mExpressionEvaluator;
    private final Map<Expression, ExpressionEvaluator<V, STATE>> mEvaluatorCache = new HashMap<Expression, ExpressionEvaluator<V, STATE>>();
    private final IEvaluatorFactory<V, STATE> mEvaluatorFactory;
    private final BoogieSymbolTable mSymbolTable;
    private final IBoogieSymbolTableVariableProvider mBoogie2SmtSymbolTable;
    private boolean mOldScope;
    private final Map<Expression, Expression> mNormalizedExpressionCache = new HashMap<Expression, Expression>();
    private final ILogger mLogger;

    public NonrelationalEvaluator(ILogger iLogger, BoogieSymbolTable boogieSymbolTable, IBoogieSymbolTableVariableProvider iBoogieSymbolTableVariableProvider, int n, int n2) {
        this.mLogger = iLogger;
        this.mSymbolTable = boogieSymbolTable;
        this.mBoogie2SmtSymbolTable = iBoogieSymbolTableVariableProvider;
        this.mEvaluatorFactory = this.createEvaluatorFactory(n, n2);
    }

    public Evaluator<V, STATE> createEvaluator(Expression expression) {
        this.mExpressionEvaluator = this.mEvaluatorCache.get(expression);
        if (this.mExpressionEvaluator == null) {
            this.mExpressionEvaluator = new ExpressionEvaluator();
            this.processExpression(expression);
            assert (this.mExpressionEvaluator.isFinished()) : "Expression evaluator is not finished";
            assert (this.mExpressionEvaluator.getRootEvaluator() != null) : "There is no root evaluator";
            this.mEvaluatorCache.put(expression, this.mExpressionEvaluator);
        }
        return this.mExpressionEvaluator.getRootEvaluator();
    }

    public Collection<IEvaluationResult<V>> evaluate(STATE STATE, Expression expression) {
        return this.createEvaluator(expression).evaluate(STATE, 0);
    }

    protected Expression processExpression(Expression expression) {
        UnaryExpression unaryExpression;
        if (expression instanceof ArrayStoreExpression || expression instanceof ArrayAccessExpression) {
            this.mExpressionEvaluator.addEvaluator(this.mEvaluatorFactory.createSingletonValueTopEvaluator(EvaluatorUtils.getEvaluatorType(expression.getType())));
            return expression;
        }
        if (expression instanceof UnaryExpression && (unaryExpression = (UnaryExpression)expression).getOperator() == UnaryExpression.Operator.OLD) {
            this.mOldScope = true;
            Expression expression2 = super.processExpression(unaryExpression.getExpr());
            this.mOldScope = false;
            return expression2;
        }
        unaryExpression = this.createNormalizedExpression(expression);
        return super.processExpression((Expression)unaryExpression);
    }

    protected void visit(IntegerLiteral integerLiteral) {
        Evaluator<V, STATE> evaluator = this.mEvaluatorFactory.createSingletonValueExpressionEvaluator(integerLiteral.getValue(), BigInteger.class);
        this.mExpressionEvaluator.addEvaluator(evaluator);
    }

    protected void visit(RealLiteral realLiteral) {
        Evaluator<V, STATE> evaluator = this.mEvaluatorFactory.createSingletonValueExpressionEvaluator(realLiteral.getValue(), BigDecimal.class);
        this.mExpressionEvaluator.addEvaluator(evaluator);
    }

    protected void visit(BinaryExpression binaryExpression) {
        NAryEvaluator<V, STATE> nAryEvaluator = this.mEvaluatorFactory.createNAryExpressionEvaluator(2, EvaluatorUtils.getEvaluatorType(binaryExpression.getType()));
        nAryEvaluator.setOperator(binaryExpression.getOperator());
        this.mExpressionEvaluator.addEvaluator(nAryEvaluator);
    }

    protected void visit(FunctionApplication functionApplication) {
        Evaluator<V, STATE> evaluator;
        List list = this.mSymbolTable.getFunctionOrProcedureDeclaration(functionApplication.getIdentifier());
        if (list == null || list.isEmpty()) {
            evaluator = this.mEvaluatorFactory.createSingletonValueTopEvaluator(EvaluatorUtils.getEvaluatorType(functionApplication.getType()));
        } else {
            assert (list.get(0) instanceof FunctionDeclaration);
            FunctionDeclaration functionDeclaration = (FunctionDeclaration)list.get(0);
            if (functionDeclaration.getBody() == null) {
                evaluator = this.mEvaluatorFactory.createFunctionEvaluator(functionDeclaration.getIdentifier(), functionDeclaration.getInParams().length, EvaluatorUtils.getEvaluatorType(functionApplication.getType()));
            } else {
                throw new UnsupportedOperationException("The function application for not inlined functions is not yet supported.");
            }
        }
        this.mExpressionEvaluator.addEvaluator(evaluator);
    }

    protected void visit(IdentifierExpression identifierExpression) {
        Evaluator<V, STATE> evaluator = this.mEvaluatorFactory.createSingletonVariableExpressionEvaluator(this.getBoogieVar(identifierExpression));
        this.mExpressionEvaluator.addEvaluator(evaluator);
        super.visit(identifierExpression);
    }

    protected void visit(UnaryExpression unaryExpression) {
        NAryEvaluator<V, STATE> nAryEvaluator = this.mEvaluatorFactory.createNAryExpressionEvaluator(1, EvaluatorUtils.getEvaluatorType(unaryExpression.getType()));
        nAryEvaluator.setOperator(unaryExpression.getOperator());
        this.mExpressionEvaluator.addEvaluator(nAryEvaluator);
        super.visit(unaryExpression);
    }

    protected void visit(BooleanLiteral booleanLiteral) {
        Evaluator<V, STATE> evaluator = this.mEvaluatorFactory.createSingletonLogicalValueExpressionEvaluator(BooleanValue.getBooleanValue(booleanLiteral.getValue()));
        this.mExpressionEvaluator.addEvaluator(evaluator);
    }

    protected void visit(ArrayStoreExpression arrayStoreExpression) {
        throw new UnsupportedOperationException("Proper array handling is not implemented.");
    }

    protected void visit(ArrayAccessExpression arrayAccessExpression) {
        throw new UnsupportedOperationException("Proper array handling is not implemented.");
    }

    protected void visit(IfThenElseExpression ifThenElseExpression) {
        Evaluator<V, STATE> evaluator = this.mEvaluatorFactory.createConditionalEvaluator();
        this.mExpressionEvaluator.addEvaluator(evaluator);
        UnaryExpression unaryExpression = new UnaryExpression(ifThenElseExpression.getLocation(), ifThenElseExpression.getCondition().getType(), UnaryExpression.Operator.LOGICNEG, ifThenElseExpression.getCondition());
        this.processExpression((Expression)unaryExpression);
    }

    private IProgramVarOrConst getBoogieVar(IdentifierExpression identifierExpression) {
        IProgramVar iProgramVar = this.mBoogie2SmtSymbolTable.getBoogieVar(identifierExpression.getIdentifier(), identifierExpression.getDeclarationInformation(), false);
        if (iProgramVar != null) {
            if (this.mOldScope && iProgramVar instanceof IProgramNonOldVar) {
                return ((IProgramNonOldVar)iProgramVar).getOldVar();
            }
            return iProgramVar;
        }
        iProgramVar = this.mBoogie2SmtSymbolTable.getBoogieConst(identifierExpression.getIdentifier());
        assert (iProgramVar != null);
        return iProgramVar;
    }

    private Expression createNormalizedExpression(Expression expression) {
        Expression expression2 = this.mNormalizedExpressionCache.get(expression);
        if (expression2 != null) {
            return expression2;
        }
        Expression expression3 = this.normalizeExpression(expression);
        if (this.mLogger.isDebugEnabled() && expression3 != expression) {
            this.mLogger.debug((Object)String.format("%sRewrote expression %s to %s", "   ", BoogiePrettyPrinter.print((Expression)expression), BoogiePrettyPrinter.print((Expression)expression3)));
        }
        this.mNormalizedExpressionCache.put(expression, expression3);
        return expression3;
    }

    protected Expression normalizeExpression(Expression expression) {
        assert (expression.getType() != null);
        return expression;
    }

    protected abstract IEvaluatorFactory<V, STATE> createEvaluatorFactory(int var1, int var2);

    protected ILogger getLogger() {
        return this.mLogger;
    }
}

