/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach.AlphaSolver;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach.LoopAccelerationMatrix;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach.LoopExtraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach.LoopInsertion;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach.MatrixBB;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach.SimpleLoop;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import java.util.ArrayDeque;
import java.util.Set;

public class IcfgLoopAcceleration<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    final ILogger mLogger;
    final IIcfg<INLOC> mOriginalIcfg;
    final Class<OUTLOC> mOutLocationClass;
    final ILocationFactory<INLOC, OUTLOC> mFunLocFac;
    final String mNewIcfgIdentifier;
    final IcfgTransformationBacktranslator mBacktranslationTracker;
    final IUltimateServiceProvider mServices;
    final LoopAccelerationOptions mOption;
    private IIcfg<OUTLOC> mResultIcfg;

    public IcfgLoopAcceleration(ILogger iLogger, IIcfg<INLOC> iIcfg, Class<OUTLOC> clazz, ILocationFactory<INLOC, OUTLOC> iLocationFactory, String string, IcfgTransformationBacktranslator icfgTransformationBacktranslator, IUltimateServiceProvider iUltimateServiceProvider, LoopAccelerationOptions loopAccelerationOptions) {
        this.mLogger = iLogger;
        this.mOriginalIcfg = iIcfg;
        this.mOutLocationClass = clazz;
        this.mFunLocFac = iLocationFactory;
        this.mNewIcfgIdentifier = string;
        this.mBacktranslationTracker = icfgTransformationBacktranslator;
        this.mServices = iUltimateServiceProvider;
        this.mOption = loopAccelerationOptions;
        this.mResultIcfg = loopAccelerationOptions.equals((Object)LoopAccelerationOptions.MARK_AS_OVERAPPROX) ? this.accelerat() : iIcfg;
    }

    public <T> void printDetailedGraph(Set<T> set) {
        ArrayDeque<IcfgLocation> arrayDeque = new ArrayDeque<IcfgLocation>();
        ArrayDeque<IcfgLocation> arrayDeque2 = new ArrayDeque<IcfgLocation>();
        for (Object object : set) {
            arrayDeque.add((IcfgLocation)object);
        }
        while (!arrayDeque.isEmpty()) {
            Object object;
            object = (IcfgLocation)arrayDeque.pop();
            this.mLogger.info((Object)("node: " + String.valueOf(object)));
            for (IcfgEdge icfgEdge : object.getOutgoingEdges()) {
                IcfgLocation icfgLocation = (IcfgLocation)icfgEdge.getTarget();
                this.mLogger.info((Object)(icfgEdge.getTransformula().getFormula().toStringDirect() + " -> " + String.valueOf(icfgLocation)));
                if (arrayDeque2.contains(icfgLocation)) continue;
                arrayDeque.add(icfgLocation);
                arrayDeque2.add(icfgLocation);
            }
        }
    }

    private IIcfg<OUTLOC> accelerat() {
        Object object = this.mOriginalIcfg;
        ManagedScript managedScript = object.getCfgSmtToolkit().getManagedScript();
        int n = 0;
        LoopExtraction loopExtraction = new LoopExtraction(this.mLogger, this.mOriginalIcfg);
        for (SimpleLoop simpleLoop : loopExtraction.getLoopTransFormulas()) {
            boolean bl;
            boolean bl2 = simpleLoop.mLoopTransFormula.getAssignedVars().size() == simpleLoop.mLoopTransFormula.getOutVars().size();
            boolean bl3 = bl = simpleLoop.mLoopTransFormula.getAssignedVars().size() == simpleLoop.mLoopTransFormula.getInVars().size();
            if (!bl || !bl2) {
                this.mLogger.info((Object)(String.valueOf(simpleLoop.mLoopTransFormula.getAssignedVars()) + "in != out!" + String.valueOf(simpleLoop.mLoopTransFormula.getOutVars())));
                continue;
            }
            MatrixBB matrixBB = new LoopAccelerationMatrix(this.mLogger, simpleLoop.mLoopTransFormula, managedScript).getResult();
            AlphaSolver alphaSolver = new AlphaSolver(this.mLogger, simpleLoop.mLoopTransFormula, managedScript, matrixBB.getMatrix(), matrixBB.getLGS(), this.mServices, ++n);
            LoopInsertion<INLOC, OUTLOC> loopInsertion = new LoopInsertion<INLOC, OUTLOC>(this.mLogger, object, this.mOutLocationClass, this.mFunLocFac, this.mNewIcfgIdentifier, this.mBacktranslationTracker, this.mServices);
            object = loopInsertion.rejoin2(simpleLoop, alphaSolver.getResult(), alphaSolver.getValues(), alphaSolver.getN());
        }
        return object;
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResultIcfg;
    }

    public static enum LoopAccelerationOptions {
        THROW_EXEPTION,
        MARK_AS_OVERAPPROX,
        DO_NOT_ACCELERATE;

    }
}

