/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates;

import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunctionGenerator;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.NestedRankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.ComposableTemplate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class NestedTemplate
extends ComposableTemplate {
    public final int mSize;
    private static final String s_name_delta = "delta_";
    private static final String s_name_function = "rank_";
    private Term mdelta;
    private final AffineFunctionGenerator[] mfgens;

    public NestedTemplate(int n) {
        assert (n > 1);
        this.mSize = n;
        this.mfgens = new AffineFunctionGenerator[this.mSize];
    }

    @Override
    protected void init() {
        this.mdelta = this.newDelta(s_name_delta + this.getInstanceNumber());
        int n = 0;
        while (n < this.mSize) {
            this.mfgens[n] = new AffineFunctionGenerator(this.mScript, this.mVariables, s_name_function + this.getInstanceNumber() + "_" + n);
            ++n;
        }
    }

    @Override
    public String getName() {
        return this.mSize + "-nested";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mSize);
        stringBuilder.append("-nested template:");
        stringBuilder.append("\n");
        stringBuilder.append("   ");
        stringBuilder.append("delta > 0");
        stringBuilder.append("\n");
        stringBuilder.append("/\\ f_0(x') < f_0(x) - delta");
        stringBuilder.append("\n");
        int n = 1;
        while (n < this.mSize) {
            stringBuilder.append("/\\ f_" + n + "(x') < f_" + n + "(x) + f_" + (n - 1) + "(x)");
            stringBuilder.append("\n");
            ++n;
        }
        n = this.mSize - 1;
        stringBuilder.append("/\\ f_" + n + "(x) > 0");
        return stringBuilder.toString();
    }

    @Override
    public Collection<Term> getCoefficients() {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(this.mdelta);
        int n = 0;
        while (n < this.mSize) {
            arrayList.addAll(this.mfgens[n].getCoefficients());
            ++n;
        }
        return arrayList;
    }

    @Override
    public RankingFunction extractRankingFunction(Map<Term, Rational> map) throws SMTLIBException {
        Rational rational = this.mfgens[0].getGcd(map);
        int n = 1;
        while (n < this.mSize) {
            rational = rational.gcd(this.mfgens[n].getGcd(map));
            ++n;
        }
        AffineFunction[] affineFunctionArray = new AffineFunction[this.mSize];
        int n2 = 0;
        while (n2 < this.mSize) {
            affineFunctionArray[n2] = this.mfgens[n2].extractAffineFunction(map, rational);
            ++n2;
        }
        return new NestedRankingFunction(affineFunctionArray);
    }

    @Override
    public int getDegree() {
        return 0;
    }

    @Override
    public List<List<LinearInequality>> getConstraintsDec(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        ArrayList<List<LinearInequality>> arrayList = new ArrayList<List<LinearInequality>>();
        LinearInequality linearInequality = this.mfgens[0].generate(map);
        LinearInequality linearInequality2 = this.mfgens[0].generate(map2);
        linearInequality2.negate();
        linearInequality.add(linearInequality2);
        Serializable serializable = new AffineTerm(this.mdelta, Rational.MONE);
        linearInequality.add((AffineTerm)serializable);
        linearInequality.setStrict(true);
        linearInequality.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
        arrayList.add(Collections.singletonList(linearInequality));
        int n = 1;
        while (n < this.mSize) {
            linearInequality2 = this.mfgens[n].generate(map);
            serializable = this.mfgens[n].generate(map2);
            ((LinearInequality)serializable).negate();
            linearInequality2.add((LinearInequality)serializable);
            LinearInequality linearInequality3 = this.mfgens[n - 1].generate(map);
            linearInequality2.add(linearInequality3);
            linearInequality2.setStrict(true);
            linearInequality2.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
            arrayList.add(Collections.singletonList(linearInequality2));
            ++n;
        }
        return arrayList;
    }

    @Override
    public List<List<LinearInequality>> getConstraintsNonInc(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        ArrayList<List<LinearInequality>> arrayList = new ArrayList<List<LinearInequality>>();
        int n = 0;
        while (n < this.mSize) {
            LinearInequality linearInequality = this.mfgens[n].generate(map);
            LinearInequality linearInequality2 = this.mfgens[n].generate(map2);
            linearInequality2.negate();
            linearInequality.add(linearInequality2);
            linearInequality.setStrict(false);
            linearInequality.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
            arrayList.add(Collections.singletonList(linearInequality));
            ++n;
        }
        return arrayList;
    }

    @Override
    public List<List<LinearInequality>> getConstraintsBounded(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        LinearInequality linearInequality = this.mfgens[this.mSize - 1].generate(map);
        linearInequality.setStrict(true);
        linearInequality.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
        return Collections.singletonList(Collections.singletonList(linearInequality));
    }

    @Override
    public List<String> getAnnotationsDec() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("rank f_0 is decreasing");
        int n = 0;
        while (n < this.mSize - 1) {
            arrayList.add("rank f_" + n + " is decreasing by at least -f_" + (n - 1));
            ++n;
        }
        return arrayList;
    }

    @Override
    public List<String> getAnnotationsNonInc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.mSize) {
            arrayList.add("rank f_" + n + " is nonincreasing");
            ++n;
        }
        return arrayList;
    }

    @Override
    public List<String> getAnnotationsBounded() {
        return Collections.singletonList("rank f_" + (this.mSize - 1) + " is bounded");
    }
}

