/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import de.uni_freiburg.informatik.ultimate.util.ScopeUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.IScopedMap;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class LinkedScopedHashMap<K, V>
extends AbstractMap<K, V>
implements IScopedMap<K, V> {
    private final LinkedHashMap<K, V> mMap = new LinkedHashMap();
    private LinkedHashMap<K, V>[] mHistory = new LinkedHashMap[5];
    private int mCurScope = -1;

    HashMap<K, V> getMap() {
        return this.mMap;
    }

    LinkedHashMap<K, V> undoMap() {
        return this.mHistory[this.mCurScope];
    }

    void recordUndo(K k, V v) {
        LinkedHashMap<K, V> linkedHashMap;
        if (this.mCurScope != -1 && !(linkedHashMap = this.undoMap()).containsKey(k)) {
            linkedHashMap.put(k, v);
        }
    }

    void undoEntry(Map.Entry<K, V> entry) {
        if (entry.getValue() != null) {
            this.mMap.put(entry.getKey(), entry.getValue());
        } else {
            this.mMap.remove(entry.getKey());
        }
    }

    @Override
    public void beginScope() {
        if (this.mCurScope == this.mHistory.length - 1) {
            this.mHistory = ScopeUtils.grow(this.mHistory);
        }
        this.mHistory[++this.mCurScope] = new LinkedHashMap();
    }

    @Override
    public void endScope() {
        for (Map.Entry<K, V> entry : this.undoMap().entrySet()) {
            this.undoEntry(entry);
        }
        this.mHistory[this.mCurScope--] = null;
        if (ScopeUtils.shouldShrink(this.mHistory)) {
            this.mHistory = ScopeUtils.shrink(this.mHistory);
        }
    }

    public Iterable<Map.Entry<K, V>> currentScopeEntries() {
        if (this.mCurScope == -1) {
            return this.entrySet();
        }
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<Map.Entry<K, V>> mBacking;
                    private Map.Entry<K, V> mLast;
                    {
                        this.mBacking = LinkedScopedHashMap.this.undoMap().entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.mLast = this.mBacking.next();
                        final Object k = this.mLast.getKey();
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return k;
                            }

                            @Override
                            public V getValue() {
                                return LinkedScopedHashMap.this.getMap().get(k);
                            }

                            @Override
                            public V setValue(V v) {
                                return LinkedScopedHashMap.this.getMap().put(k, v);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        LinkedScopedHashMap.this.undoEntry(this.mLast);
                    }
                };
            }

            @Override
            public int size() {
                return LinkedScopedHashMap.this.undoMap().size();
            }
        };
    }

    @Override
    public Iterable<K> currentScopeKeys() {
        if (this.mCurScope == -1) {
            return this.keySet();
        }
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    private final Iterator<Map.Entry<K, V>> mBacking;
                    private Map.Entry<K, V> mLast;
                    {
                        this.mBacking = LinkedScopedHashMap.this.undoMap().entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public K next() {
                        this.mLast = this.mBacking.next();
                        return this.mLast.getKey();
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        LinkedScopedHashMap.this.undoEntry(this.mLast);
                    }
                };
            }

            @Override
            public int size() {
                return LinkedScopedHashMap.this.undoMap().size();
            }
        };
    }

    public Iterable<V> currentScopeValues() {
        if (this.mCurScope == -1) {
            return this.values();
        }
        return new AbstractSet<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private final Iterator<Map.Entry<K, V>> mBacking;
                    private Map.Entry<K, V> mLast;
                    {
                        this.mBacking = LinkedScopedHashMap.this.undoMap().entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public V next() {
                        this.mLast = this.mBacking.next();
                        return LinkedScopedHashMap.this.getMap().get(this.mLast.getKey());
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        LinkedScopedHashMap.this.undoEntry(this.mLast);
                    }
                };
            }

            @Override
            public int size() {
                return LinkedScopedHashMap.this.undoMap().size();
            }
        };
    }

    @Override
    public void clear() {
        this.mMap.clear();
        this.mHistory = new LinkedHashMap[5];
    }

    @Override
    public boolean containsKey(Object object) {
        return this.mMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.mMap.containsValue(object);
    }

    @Override
    public V get(Object object) {
        return this.mMap.get(object);
    }

    @Override
    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    @Override
    public boolean isEmptyScope() {
        return this.mCurScope == -1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<Map.Entry<K, V>> mBacking;
                    private Map.Entry<K, V> mLast;
                    {
                        this.mBacking = LinkedScopedHashMap.this.getMap().entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.mLast = this.mBacking.next();
                        return this.mLast;
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        LinkedScopedHashMap.this.recordUndo(this.mLast.getKey(), this.mLast.getValue());
                    }
                };
            }

            @Override
            public int size() {
                return LinkedScopedHashMap.this.getMap().size();
            }
        };
    }

    @Override
    public V put(K k, V v) {
        if (v == null) {
            throw new IllegalArgumentException();
        }
        V v2 = this.mMap.put(k, v);
        this.recordUndo(k, v2);
        return v2;
    }

    @Override
    public V remove(Object object) {
        Object v = this.mMap.remove(object);
        this.recordUndo(object, v);
        return v;
    }

    @Override
    public int size() {
        return this.mMap.size();
    }

    public int getActiveScopeNum() {
        return this.mCurScope + 1;
    }

    public boolean overwritesKeyInScope(Object object, int n) {
        assert (n != 0);
        return this.mHistory[n - 1].containsKey(object);
    }
}

