/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.muses;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.NamedAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.Translator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;

public class UnexploredMap {
    DPLLEngine mEngine;
    Translator mTranslator;
    boolean mMapModifiedSinceLastSolve;
    BitSet mImpliedCrits;
    BitSet mMaximalUnexploredSubset;
    BitSet mLastWorkingSet;

    public UnexploredMap(DPLLEngine dPLLEngine, Translator translator) {
        this.mEngine = dPLLEngine;
        this.mTranslator = translator;
        this.mMapModifiedSinceLastSolve = true;
    }

    public void messWithActivityOfAtoms(Random random) {
        this.mEngine.messWithActivityOfAtoms(random);
    }

    public void BlockUp(BitSet bitSet) {
        this.mMapModifiedSinceLastSolve = true;
        ArrayList<Literal> arrayList = new ArrayList<Literal>();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            arrayList.add(this.mTranslator.translate2Atom(n).negate());
            n = bitSet.nextSetBit(n + 1);
        }
        this.mEngine.addClause(new Clause(arrayList.toArray(new Literal[arrayList.size()]), this.mEngine.getAssertionStackLevel()));
    }

    public void BlockDown(BitSet bitSet) {
        this.mMapModifiedSinceLastSolve = true;
        ArrayList<NamedAtom> arrayList = new ArrayList<NamedAtom>();
        BitSet bitSet2 = (BitSet)bitSet.clone();
        bitSet2.flip(0, this.mTranslator.getNumberOfConstraints());
        int n = bitSet2.nextSetBit(0);
        while (n >= 0) {
            arrayList.add(this.mTranslator.translate2Atom(n));
            n = bitSet2.nextSetBit(n + 1);
        }
        this.mEngine.addClause(new Clause(arrayList.toArray(new Literal[arrayList.size()]), this.mEngine.getAssertionStackLevel()));
    }

    public BitSet findMaximalUnexploredSubsetOf(BitSet bitSet) {
        if (this.mMapModifiedSinceLastSolve || !bitSet.equals(this.mLastWorkingSet)) {
            this.findMaximalUnexploredSubsetAndImpliedCrits(bitSet);
        }
        return this.mMaximalUnexploredSubset;
    }

    public BitSet findImpliedCritsOf(BitSet bitSet) {
        if (this.mMapModifiedSinceLastSolve || !bitSet.equals(this.mLastWorkingSet)) {
            this.findMaximalUnexploredSubsetAndImpliedCrits(bitSet);
        }
        return this.mImpliedCrits;
    }

    private boolean findMaximalUnexploredSubsetAndImpliedCrits(BitSet bitSet) {
        this.mMapModifiedSinceLastSolve = false;
        this.mLastWorkingSet = (BitSet)bitSet.clone();
        BitSet bitSet2 = (BitSet)bitSet.clone();
        bitSet2.flip(0, this.mTranslator.getNumberOfConstraints());
        this.mEngine.push();
        int n = bitSet2.nextSetBit(0);
        while (n >= 0) {
            Literal[] literalArray = new Literal[]{this.mTranslator.translate2Atom(n).negate()};
            this.mEngine.addClause(new Clause(literalArray, this.mEngine.getAssertionStackLevel()));
            n = bitSet2.nextSetBit(n + 1);
        }
        if (this.mEngine.solve()) {
            if (this.mEngine.isTerminationRequested()) {
                this.mMaximalUnexploredSubset = new BitSet();
                this.mImpliedCrits = new BitSet();
                this.mEngine.pop(1);
                return false;
            }
            this.mMaximalUnexploredSubset = this.collectAtomsWithCriteria(bitSet, this::isSetToTrue);
            this.mImpliedCrits = this.collectAtomsWithCriteria(this.mMaximalUnexploredSubset, this::isDecidedInLevelZero);
            this.mEngine.pop(1);
            return true;
        }
        this.mMaximalUnexploredSubset = new BitSet();
        this.mImpliedCrits = new BitSet();
        this.mEngine.pop(1);
        return false;
    }

    private BitSet collectAtomsWithCriteria(BitSet bitSet, Function<Integer, Boolean> function) {
        BitSet bitSet2 = new BitSet(this.mTranslator.getNumberOfConstraints());
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            if (function.apply(n).booleanValue()) {
                bitSet2.set(n);
            }
            n = bitSet.nextSetBit(n + 1);
        }
        return bitSet2;
    }

    private boolean isSetToTrue(int n) {
        return this.mTranslator.translate2Atom(n).getDecideStatus().getSign() == 1;
    }

    private boolean isDecidedInLevelZero(int n) {
        return this.mTranslator.translate2Atom(n).getDecideLevel() == 0;
    }

    private boolean mMaximalUnexploredSubsetIsMSS() {
        SimpleList<Clause> simpleList = this.mEngine.getClauses();
        int n = this.mTranslator.getNumberOfConstraints();
        int n2 = this.mMaximalUnexploredSubset.nextClearBit(0);
        while (n2 >= 0 && n2 < n) {
            NamedAtom namedAtom = this.mTranslator.translate2Atom(n2);
            if (!this.thereIsAClauseThatImpliesTheGivenAtomNegatedButNoOtherLiteral(simpleList, namedAtom)) {
                return false;
            }
            n2 = this.mMaximalUnexploredSubset.nextClearBit(n2 + 1);
        }
        return true;
    }

    private boolean thereIsAClauseThatImpliesTheGivenAtomNegatedButNoOtherLiteral(SimpleList<Clause> simpleList, NamedAtom namedAtom) {
        for (Clause clause : simpleList) {
            if (!clause.contains(namedAtom.negate()) || this.thereIsALiteralWithAnAtomDifferentFromTheGivenThatSatisfiesTheClause(clause, namedAtom)) continue;
            return true;
        }
        return false;
    }

    private boolean thereIsALiteralWithAnAtomDifferentFromTheGivenThatSatisfiesTheClause(Clause clause, NamedAtom namedAtom) {
        int n = 0;
        while (n < clause.getSize()) {
            NamedAtom namedAtom2;
            if (clause.getLiteral(n).getSign() == 1 ? (namedAtom2 = (NamedAtom)clause.getLiteral(n)) != namedAtom && this.mMaximalUnexploredSubset.get(this.mTranslator.translate2Index(namedAtom2)) : (namedAtom2 = (NamedAtom)clause.getLiteral(n).getAtom()) != namedAtom && !this.mMaximalUnexploredSubset.get(this.mTranslator.translate2Index(namedAtom2))) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

