/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.Set;

public class BasicPredicate
extends ModernAnnotations
implements IPredicate {
    private static final long serialVersionUID = -2257982001512157622L;
    protected Term mFormula;
    protected final Term mClosedFormula;
    protected final Set<IProgramVar> mVars;
    protected final Set<IProgramFunction> mFunctions;
    protected final int mSerialNumber;

    public BasicPredicate(int n, Term term, Set<IProgramVar> set, Set<IProgramFunction> set2, Term term2) {
        this.mFormula = term;
        this.mClosedFormula = term2;
        this.mVars = set;
        this.mFunctions = set2;
        this.mSerialNumber = n;
    }

    @Override
    @Visualizable
    public Term getFormula() {
        return this.mFormula;
    }

    @Override
    public Term getClosedFormula() {
        return this.mClosedFormula;
    }

    @Override
    @Visualizable
    public Set<IProgramVar> getVars() {
        return this.mVars;
    }

    @Override
    public Set<IProgramFunction> getFuns() {
        return this.mFunctions;
    }

    public String toString() {
        return this.mSerialNumber + "#" + this.mFormula.toStringDirect();
    }

    public final int hashCode() {
        return HashUtils.hashJenkins((int)31, (Object)this.mSerialNumber);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BasicPredicate) {
            BasicPredicate basicPredicate = (BasicPredicate)object;
            if (this.mSerialNumber == basicPredicate.mSerialNumber) {
                throw new UnsupportedOperationException("different predicates with same serial number");
            }
        }
        return false;
    }
}

