/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.visualization;

import de.uni_freiburg.informatik.ultimate.automata.GeneralAutomatonPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IEpsilonNestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.visualization.INwaAtsFormatter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;

public class NwaWriter<LETTER, STATE>
extends GeneralAutomatonPrinter {
    private final INestedWordAutomaton<LETTER, STATE> mNwa;
    private final Map<LETTER, String> mInternalAlphabet;
    private final Map<LETTER, String> mCallAlphabet;
    private final Map<LETTER, String> mReturnAlphabet;
    private final Map<STATE, String> mStateMapping;

    public NwaWriter(PrintWriter printWriter, String string, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, INwaAtsFormatter<LETTER, STATE> iNwaAtsFormatter) {
        super(printWriter);
        this.mNwa = iNestedWordAutomaton;
        this.mInternalAlphabet = iNwaAtsFormatter.getAlphabetMapping(this.mNwa.getVpAlphabet().getInternalAlphabet(), 'a');
        this.mCallAlphabet = iNwaAtsFormatter.getAlphabetMapping(this.mNwa.getVpAlphabet().getCallAlphabet(), 'c');
        this.mReturnAlphabet = iNwaAtsFormatter.getAlphabetMapping(this.mNwa.getVpAlphabet().getReturnAlphabet(), 'r');
        this.mStateMapping = iNwaAtsFormatter.getStateMapping(this.mNwa.getStates());
        boolean bl = this.mNwa instanceof IEpsilonNestedWordAutomaton;
        if (bl) {
            this.print("EpsilonNestedWordAutomaton ");
            this.print(string);
            this.printAutomatonPrefix();
            this.printAlphabets();
            this.printStates();
            this.printInitialStates((Collection<STATE>)this.mNwa.getInitialStates());
            this.printFinalStates(this.mNwa.getStates());
            this.printCallTransitions(this.mNwa.getStates());
            this.printTransitionListSeparator();
            this.printInternalTransitions(this.mNwa.getStates());
            this.printTransitionListSeparator();
            this.printReturnTransitions(this.mNwa.getStates());
            this.printTransitionListSeparator();
            this.printEpsilonTransitions(this.mNwa.getStates());
            this.printLastTransitionLineSeparator();
            this.printAutomatonSuffix();
        } else {
            boolean bl2;
            boolean bl3 = bl2 = this.mCallAlphabet.isEmpty() && this.mReturnAlphabet.isEmpty();
            if (bl2) {
                this.print("FiniteAutomaton ");
                this.print(string);
                this.printAutomatonPrefix();
                this.printAlphabetOfFiniteAutomaton();
                this.printStates();
                this.printInitialStates((Collection<STATE>)this.mNwa.getInitialStates());
                this.printFinalStates(this.mNwa.getStates());
                this.printTransitionsOfFiniteAutomaton(this.mNwa.getStates());
                this.printLastTransitionLineSeparator();
                this.printAutomatonSuffix();
            } else {
                this.print("NestedWordAutomaton ");
                this.print(string);
                this.printAutomatonPrefix();
                this.printAlphabets();
                this.printStates();
                this.printInitialStates((Collection<STATE>)this.mNwa.getInitialStates());
                this.printFinalStates(this.mNwa.getStates());
                this.printCallTransitions(this.mNwa.getStates());
                this.printTransitionListSeparator();
                this.printInternalTransitions(this.mNwa.getStates());
                this.printTransitionListSeparator();
                this.printReturnTransitions(this.mNwa.getStates());
                this.printLastTransitionLineSeparator();
                this.printAutomatonSuffix();
            }
        }
        this.finish();
    }

    private void printAlphabets() {
        this.printCollectionPrefix("callAlphabet");
        this.printValues(this.mCallAlphabet);
        this.printCollectionSuffix();
        this.printCollectionPrefix("internalAlphabet");
        this.printValues(this.mInternalAlphabet);
        this.printCollectionSuffix();
        this.printCollectionPrefix("returnAlphabet");
        this.printValues(this.mReturnAlphabet);
        this.printCollectionSuffix();
    }

    private void printAlphabetOfFiniteAutomaton() {
        this.printCollectionPrefix("alphabet");
        this.printValues(this.mInternalAlphabet);
        this.printCollectionSuffix();
    }

    private void printStates() {
        this.printCollectionPrefix("states");
        this.printValues(this.mStateMapping);
        this.printCollectionSuffix();
    }

    private void printInitialStates(Collection<STATE> collection) {
        this.printCollectionPrefix("initialStates");
        for (STATE STATE : collection) {
            this.printElement(this.mStateMapping.get(STATE));
        }
        this.printCollectionSuffix();
    }

    private void printFinalStates(Collection<STATE> collection) {
        this.printCollectionPrefix("finalStates");
        for (STATE STATE : collection) {
            if (!this.mNwa.isFinal(STATE)) continue;
            this.printElement(this.mStateMapping.get(STATE));
        }
        this.printCollectionSuffix();
    }

    private void printTransitionsOfFiniteAutomaton(Collection<STATE> collection) {
        this.printlnCollectionPrefix("transitions");
        for (STATE STATE : collection) {
            for (OutgoingInternalTransition outgoingInternalTransition : this.mNwa.internalSuccessors(STATE)) {
                this.printOneTransitionPrefix();
                this.print(this.mStateMapping.get(STATE));
                this.print(' ');
                this.print(this.mInternalAlphabet.get(outgoingInternalTransition.getLetter()));
                this.print(' ');
                this.print(this.mStateMapping.get(outgoingInternalTransition.getSucc()));
                this.printOneTransitionSuffix();
            }
        }
        this.printTransitionsSuffix();
    }

    private void printCallTransitions(Collection<STATE> collection) {
        this.printlnCollectionPrefix("callTransitions");
        for (STATE STATE : collection) {
            for (OutgoingCallTransition outgoingCallTransition : this.mNwa.callSuccessors(STATE)) {
                this.printOneTransitionPrefix();
                this.print(this.mStateMapping.get(STATE));
                this.print(' ');
                this.print(this.mCallAlphabet.get(outgoingCallTransition.getLetter()));
                this.print(' ');
                this.print(this.mStateMapping.get(outgoingCallTransition.getSucc()));
                this.printOneTransitionSuffix();
            }
        }
        this.printTransitionsSuffix();
    }

    private void printInternalTransitions(Collection<STATE> collection) {
        this.printlnCollectionPrefix("internalTransitions");
        for (STATE STATE : collection) {
            for (OutgoingInternalTransition outgoingInternalTransition : this.mNwa.internalSuccessors(STATE)) {
                this.printOneTransitionPrefix();
                this.print(this.mStateMapping.get(STATE));
                this.print(' ');
                this.print(this.mInternalAlphabet.get(outgoingInternalTransition.getLetter()));
                this.print(' ');
                this.print(this.mStateMapping.get(outgoingInternalTransition.getSucc()));
                this.printOneTransitionSuffix();
            }
        }
        this.printTransitionsSuffix();
    }

    private void printReturnTransitions(Collection<STATE> collection) {
        this.printlnCollectionPrefix("returnTransitions");
        for (STATE STATE : collection) {
            for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.mNwa.returnSuccessors(STATE)) {
                this.printOneTransitionPrefix();
                this.print(this.mStateMapping.get(STATE));
                this.print(' ');
                this.print(this.mStateMapping.get(outgoingReturnTransition.getHierPred()));
                this.print(' ');
                this.print(this.mReturnAlphabet.get(outgoingReturnTransition.getLetter()));
                this.print(' ');
                this.print(this.mStateMapping.get(outgoingReturnTransition.getSucc()));
                this.printOneTransitionSuffix();
            }
        }
        this.printTransitionsSuffix();
    }

    private void printEpsilonTransitions(Collection<STATE> collection) {
        this.printlnCollectionPrefix("epsilonTransitions");
        for (STATE STATE : collection) {
            for (STATE STATE2 : ((IEpsilonNestedWordAutomaton)this.mNwa).epsilonSuccessors(STATE)) {
                this.printOneTransitionPrefix();
                this.print(this.mStateMapping.get(STATE));
                this.print(' ');
                this.print(this.mStateMapping.get(STATE2));
                this.printOneTransitionSuffix();
            }
        }
        this.printTransitionsSuffix();
    }
}

