/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder.multireduction;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.multireduction.SleepMapReduction;
import java.util.Random;

public class CoinFlipBudget<L, R>
implements SleepMapReduction.IBudgetFunction<L, R> {
    private final SleepMapReduction.IBudgetFunction<L, R> mUnderlying;
    private final Random mRand;
    private final double mProbabilityUnderlying;
    private final boolean mPreemptive;

    public CoinFlipBudget(SleepMapReduction.IBudgetFunction<L, R> iBudgetFunction, double d, long l, boolean bl) {
        this.mUnderlying = iBudgetFunction;
        this.mRand = new Random(l);
        this.mProbabilityUnderlying = d;
        this.mPreemptive = bl;
    }

    @Override
    public int computeBudget(R r, L l) {
        if (this.mPreemptive && this.flipCoin()) {
            return 0;
        }
        int n = this.mUnderlying.computeBudget(r, l);
        if (!this.mPreemptive && n > 0 && this.flipCoin()) {
            return 0;
        }
        return n;
    }

    private boolean flipCoin() {
        return this.mRand.nextDouble() >= this.mProbabilityUnderlying;
    }
}

