/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;

class PDOMCAnnotations {
    private static final int EXTERN_OFFSET = 0;
    private static final int INLINE_OFFSET = 1;
    private static final int STATIC_OFFSET = 2;
    private static final int VARARGS_OFFSET = 3;
    private static final int NO_RETURN_OFFSET = 4;
    private static final int REGISTER_OFFSET = 5;
    private static final int AUTO_OFFSET = 6;
    private static final int NO_DISCARD_OFFSET = 7;

    PDOMCAnnotations() {
    }

    public static byte encodeFunctionAnnotations(IFunction function) {
        byte annotation = 0;
        if (function.isExtern()) {
            annotation = (byte)(annotation | 1);
        }
        if (ASTInternal.isStatic(function, false)) {
            annotation = (byte)(annotation | 4);
        }
        if (function.isInline()) {
            annotation = (byte)(annotation | 2);
        }
        if (function.takesVarArgs()) {
            annotation = (byte)(annotation | 8);
        }
        if (function.isNoReturn()) {
            annotation = (byte)(annotation | 0x10);
        }
        if (function.isRegister()) {
            annotation = (byte)(annotation | 0x20);
        }
        if (function.isAuto()) {
            annotation = (byte)(annotation | 0x40);
        }
        if (function.isNoDiscard()) {
            annotation = (byte)(annotation | 0x80);
        }
        return annotation;
    }

    public static byte encodeVariableAnnotations(IVariable variable) {
        byte modifiers = 0;
        if (variable.isExtern()) {
            modifiers = (byte)(modifiers | 1);
        }
        if (variable.isStatic()) {
            modifiers = (byte)(modifiers | 4);
        }
        if (variable.isRegister()) {
            modifiers = (byte)(modifiers | 0x20);
        }
        if (variable.isAuto()) {
            modifiers = (byte)(modifiers | 0x40);
        }
        return modifiers;
    }

    public static boolean isExtern(short annotation) {
        return (annotation & 1) != 0;
    }

    public static boolean isStatic(short annotation) {
        return (annotation & 4) != 0;
    }

    public static boolean isInline(short annotation) {
        return (annotation & 2) != 0;
    }

    public static boolean isVarargsFunction(short annotation) {
        return (annotation & 8) != 0;
    }

    public static boolean isNoReturnFunction(short annotation) {
        return (annotation & 0x10) != 0;
    }

    public static boolean isNoDiscardFunction(short annotation) {
        return (annotation & 0x80) != 0;
    }

    public static boolean isRegister(byte annotation) {
        return (annotation & 0x20) != 0;
    }

    public static boolean isAuto(byte annotation) {
        return (annotation & 0x40) != 0;
    }
}

