/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pdr;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.OldVarsAssignmentCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocationIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ITransitionRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.IInterpolatingTraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.InterpolantComputationStatus;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IAbstractPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IDomainSpecificOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermDomainOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.NonDeclaringTermTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.ITraceCheckPreferences;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.TraceCheckReasonUnknown;
import de.uni_freiburg.informatik.ultimate.lib.pdr.PdrBenchmark;
import de.uni_freiburg.informatik.ultimate.lib.pdr.ProofObligation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.predicates.IterativePredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.DefaultTransFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.NestedFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.PathProgram;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.BaseTuple;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Pdr<L extends IIcfgTransition<?>>
implements IInterpolatingTraceCheck<L> {
    private static final boolean USE_INTERPOLATION = true;
    private static final boolean USE_ICFGBUILDER_SOLVER = true;
    private final DealWithProcedures mDealWithProcedures = DealWithProcedures.CONTINUE;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final Map<IcfgLocation, IPredicate> mGlobalFrames;
    private final ManagedScript mScript;
    private final PredicateTransformer<Term, IPredicate, TransFormula> mPredTrans;
    private final IIcfg<? extends IcfgLocation> mIcfg;
    private final IIcfg<? extends IcfgLocation> mPpIcfg;
    private final CfgSmtToolkit mCsToolkit;
    private final IPredicateUnifier mLocalPredicateUnifier;
    private final IPredicate mTruePred;
    private final IPredicate mFalsePred;
    private final List<L> mTrace;
    private final PdrBenchmark mPdrBenchmark;
    private final IIcfgSymbolTable mSymbolTable;
    private final IPredicate mAxioms;
    private final Map<String, UnmodifiableTransFormula> mLocalAssignmentRet;
    private final Map<String, UnmodifiableTransFormula> mLocalAssignmentCall;
    private final Deque<Pair<ProofObligation, ProofObligation>> mSatProofObligations;
    private boolean mTraceCheckFinishedNormally;
    private IProgramExecution<L, Term> mFeasibleProgramExecution;
    private Script.LBool mIsTraceCorrect;
    private IPredicate[] mInterpolants;
    private TraceCheckReasonUnknown mReasonUnknown;
    private int mInvarSpot;
    private final int mLevel;
    private final IPredicateUnifier mExternalPredicateUnifier;
    private final Class<L> mTransitionClazz;

    public Pdr(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, ITraceCheckPreferences iTraceCheckPreferences, IPredicateUnifier iPredicateUnifier, IPredicate iPredicate, IPredicate iPredicate2, List<L> list, Class<L> clazz) {
        this.mLogger = iLogger;
        this.mTrace = list;
        this.mLocalAssignmentCall = new HashMap<String, UnmodifiableTransFormula>();
        this.mLocalAssignmentRet = new HashMap<String, UnmodifiableTransFormula>();
        this.mTransitionClazz = clazz;
        if (!SmtUtils.isTrueLiteral((Term)iPredicate.getFormula())) {
            throw new UnsupportedOperationException("Currently, only precondition true is supported");
        }
        if (!SmtUtils.isFalseLiteral((Term)iPredicate2.getFormula())) {
            throw new UnsupportedOperationException("Currently, only postcondition false is supported");
        }
        this.mServices = iUltimateServiceProvider;
        this.mIcfg = iTraceCheckPreferences.getIcfgContainer();
        this.mSymbolTable = this.mIcfg.getCfgSmtToolkit().getSymbolTable();
        PathProgram.PathProgramConstructionResult pathProgramConstructionResult = PathProgram.constructPathProgram((String)"errorPP", this.mIcfg, new HashSet<L>(list), Collections.emptySet(), icfgLocation -> true);
        this.mPpIcfg = pathProgramConstructionResult.getPathProgram();
        this.mCsToolkit = this.mPpIcfg.getCfgSmtToolkit();
        this.mExternalPredicateUnifier = iPredicateUnifier;
        this.mScript = Pdr.createSolver(this.mServices, this.mCsToolkit);
        this.mLocalPredicateUnifier = this.mExternalPredicateUnifier;
        this.mInvarSpot = -1;
        this.mLevel = 0;
        this.mPdrBenchmark = new PdrBenchmark();
        this.mPredTrans = new PredicateTransformer(this.mScript, (IDomainSpecificOperationProvider)new TermDomainOperationProvider(this.mServices, this.mScript));
        Term term = new NonDeclaringTermTransferrer(this.mScript.getScript()).transform(this.mCsToolkit.getSmtFunctionsAndAxioms().getAxioms().getFormula());
        this.mAxioms = this.mLocalPredicateUnifier.getOrConstructPredicate(term);
        this.mTruePred = this.mLocalPredicateUnifier.getOrConstructPredicate(this.mScript.getScript().term("true", new Term[0]));
        this.mFalsePred = this.mLocalPredicateUnifier.getOrConstructPredicate(this.mScript.getScript().term("false", new Term[0]));
        this.mGlobalFrames = this.initializeGlobalFrames(this.mPpIcfg);
        this.mSatProofObligations = new ArrayDeque<Pair<ProofObligation, ProofObligation>>();
        this.mLogger.info((Object)"Analyzing path program with PDR");
        try {
            try {
                this.mPdrBenchmark.start((Object)PdrBenchmark.PdrStatisticsDefinitions.PDR_RUNTIME);
                this.mIsTraceCorrect = this.pdrPreprocessing(this.mPpIcfg);
                this.mLogger.info((Object)"Finished analyzing path program with PDR");
                this.mTraceCheckFinishedNormally = true;
                this.mReasonUnknown = null;
            }
            catch (ToolchainCanceledException toolchainCanceledException) {
                this.mTraceCheckFinishedNormally = false;
                this.mIsTraceCorrect = Script.LBool.UNKNOWN;
                this.mReasonUnknown = new TraceCheckReasonUnknown(TraceCheckReasonUnknown.Reason.ULTIMATE_TIMEOUT, (Exception)((Object)toolchainCanceledException), TraceCheckReasonUnknown.ExceptionHandlingCategory.KNOWN_DEPENDING);
                this.mPdrBenchmark.stop((Object)PdrBenchmark.PdrStatisticsDefinitions.PDR_RUNTIME);
            }
            catch (SMTLIBException sMTLIBException) {
                this.mTraceCheckFinishedNormally = false;
                this.mIsTraceCorrect = Script.LBool.UNKNOWN;
                this.mReasonUnknown = TraceCheckReasonUnknown.constructReasonUnknown((SMTLIBException)sMTLIBException);
                this.mPdrBenchmark.stop((Object)PdrBenchmark.PdrStatisticsDefinitions.PDR_RUNTIME);
            }
        }
        finally {
            this.mPdrBenchmark.stop((Object)PdrBenchmark.PdrStatisticsDefinitions.PDR_RUNTIME);
        }
    }

    private final Script.LBool pdrPreprocessing(IIcfg<? extends IcfgLocation> iIcfg) {
        IcfgEdge icfgEdge3;
        IcfgLocation icfgLocation2;
        Set set = iIcfg.getInitialNodes();
        Set set2 = IcfgUtils.getErrorLocations(this.mPpIcfg);
        for (IcfgLocation icfgLocation2 : set) {
            if (set2.contains(icfgLocation2)) {
                this.mLogger.debug((Object)"Error is reachable.");
                return Script.LBool.SAT;
            }
            for (IcfgEdge icfgEdge2 : icfgLocation2.getOutgoingEdges()) {
                if (!set2.contains(icfgEdge2.getTarget())) continue;
                if (this.mAxioms != null) {
                    Set set3 = this.mCsToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(icfgEdge2.getPrecedingProcedure());
                    Script.LBool lBool = PredicateUtils.isInductiveHelper((Script)this.mScript.getScript(), (IPredicate)this.mTruePred, (IPredicate)this.not(this.mAxioms), (UnmodifiableTransFormula)icfgEdge2.getTransformula(), (Set)set3, (Set)set3);
                    if (lBool == Script.LBool.UNSAT) {
                        this.mInvarSpot = 0;
                        this.mInterpolants = this.computeInterpolants();
                        return Script.LBool.UNSAT;
                    }
                }
                return Script.LBool.SAT;
            }
        }
        icfgLocation2 = new ArrayDeque();
        for (IcfgEdge icfgEdge3 : ((IcfgLocation)set2.iterator().next()).getIncomingEdges()) {
            Term term = (Term)this.mPredTrans.pre((IAbstractPredicate)this.mTruePred, (ITransitionRelation)icfgEdge3.getTransformula());
            IPredicate iPredicate = this.mLocalPredicateUnifier.getOrConstructPredicate(term);
            ProofObligation proofObligation = new ProofObligation(iPredicate, (IcfgLocation)icfgEdge3.getSource(), 0);
            icfgLocation2.add(proofObligation);
        }
        icfgEdge3 = this.computePdr(iIcfg, (Deque<ProofObligation>)icfgLocation2);
        if (icfgEdge3 == Script.LBool.UNSAT) {
            this.mInterpolants = this.computeInterpolants();
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)"Interpolants are");
                int n = 0;
                this.mLogger.debug((Object)"{true}");
                for (Term term : this.mTrace) {
                    this.mLogger.debug((Object)term);
                    if (n != this.mTrace.size() - 1) {
                        this.mLogger.debug("%s {%s}", new Object[]{term.getTarget(), this.mInterpolants[n]});
                    }
                    ++n;
                }
                this.mLogger.debug((Object)"{false}");
            }
        }
        return icfgEdge3;
    }

    private Script.LBool computePdr(IIcfg<? extends IcfgLocation> iIcfg, Deque<ProofObligation> deque) {
        Map<IcfgLocation, List<Pair<ChangedFrame, IPredicate>>> map = this.initializeLocalFrames(iIcfg);
        int n = 0;
        do {
            if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                throw new ToolchainCanceledException(this.getClass(), "Timeout or canceled while running Pdr");
            }
            ArrayDeque<ProofObligation> arrayDeque = new ArrayDeque<ProofObligation>(deque);
            for (Map.Entry<IcfgLocation, List<Pair<ChangedFrame, IPredicate>>> entry2 : map.entrySet()) {
                IPredicate iPredicate = this.mGlobalFrames.get(entry2.getKey());
                entry2.getValue().add((Pair<ChangedFrame, IPredicate>)new Pair((Object)ChangedFrame.U, (Object)this.mLocalPredicateUnifier.getOrConstructPredicate(iPredicate)));
            }
            if (this.blockingPhase(arrayDeque, map, ++n)) continue;
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Error trace found. Frames: " + map.entrySet().stream().map(entry -> String.valueOf(((IcfgLocation)entry.getKey()).getDebugIdentifier()) + ": {" + ((List)entry.getValue()).stream().map(BaseTuple::toString).collect(Collectors.joining(",")) + "}").collect(Collectors.joining(","))));
            }
            this.mLogger.debug((Object)"Error is reachable.");
            return Script.LBool.SAT;
        } while (!this.propagationPhase(map));
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Frames:");
            for (Map.Entry<IcfgLocation, List<Pair<ChangedFrame, IPredicate>>> entry2 : map.entrySet()) {
                this.mLogger.debug((Object)("  " + String.valueOf(entry2.getKey().getDebugIdentifier()) + ": " + entry2.getValue().stream().map(BaseTuple::toString).collect(Collectors.joining(","))));
            }
            this.mLogger.debug((Object)"PP:");
            this.mLogger.debug((Object)("  " + new IcfgLocationIterator(this.mPpIcfg).asStream().map(icfgLocation -> icfgLocation.getDebugIdentifier().toString()).collect(Collectors.joining(","))));
            this.mLogger.debug((Object)"Error is not reachable.");
        }
        this.updateGlobalFrames(map, this.mInvarSpot);
        return Script.LBool.UNSAT;
    }

    private final boolean blockingPhase(Deque<ProofObligation> deque, Map<IcfgLocation, List<Pair<ChangedFrame, IPredicate>>> map, int n) {
        this.mLogger.debug((Object)("Begin Blocking Phase: on Level: " + n));
        while (!deque.isEmpty()) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("# of proof-obligations: " + deque.size()));
            }
            ProofObligation proofObligation = deque.pop();
            IPredicate iPredicate = proofObligation.getToBeBlocked();
            IcfgLocation icfgLocation2 = proofObligation.getLocation();
            int n2 = n - proofObligation.getLevel();
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("ProofObligation: " + String.valueOf(proofObligation)));
                this.mLogger.debug((Object)("predecessors: " + String.valueOf(icfgLocation2.getIncomingNodes())));
            }
            for (IcfgEdge icfgEdge : icfgLocation2.getIncomingEdges()) {
                Script.LBool lBool;
                Object object;
                Object object2;
                UnmodifiableTransFormula unmodifiableTransFormula;
                Object object3;
                UnmodifiableTransFormula unmodifiableTransFormula2;
                Object object4;
                String string;
                Object object5;
                Object object6;
                Object object7;
                UnmodifiableTransFormula unmodifiableTransFormula3;
                IPredicate iPredicate2;
                IcfgLocation icfgLocation3 = (IcfgLocation)icfgEdge.getSource();
                if (icfgEdge instanceof IIcfgInternalTransition) {
                    if (!map.containsKey(icfgLocation3)) {
                        this.mLogger.warn((Object)"Found unrelated predecessor");
                        continue;
                    }
                    iPredicate2 = (IPredicate)map.get(icfgLocation3).get(n2 - 1).getSecond();
                    unmodifiableTransFormula3 = new Triple((Object)iPredicate2, (Object)icfgEdge, (Object)iPredicate);
                    object7 = this.mCsToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(icfgEdge.getPrecedingProcedure());
                    object6 = icfgEdge.getTransformula();
                    if (this.mLogger.isDebugEnabled()) {
                        this.mLogger.debug((Object)String.format("Checking %s and %s and %s for satisfiability", iPredicate2, icfgEdge, iPredicate));
                    }
                    object5 = object6;
                    string = icfgLocation3.getProcedure();
                    if (this.mLocalAssignmentCall.containsKey(string) && this.mLocalAssignmentCall.get(string).getFormula() != this.mTruePred.getFormula()) {
                        object4 = this.mLocalAssignmentCall.get(string);
                        unmodifiableTransFormula2 = this.mLocalAssignmentRet.get(string);
                        object3 = this.normalizeTerm((UnmodifiableTransFormula)object4);
                        unmodifiableTransFormula = this.normalizeTerm(unmodifiableTransFormula2);
                        object5 = this.normalizeTerm((UnmodifiableTransFormula)object6);
                        object2 = this.convertEqualToMap(object3.getFormula(), true);
                        object = Substitution.apply((ManagedScript)this.mScript, (Map)object2, (Term)object5.getFormula());
                        object2.putAll(this.convertEqualToMap(unmodifiableTransFormula.getFormula(), false));
                        lBool = new TransFormulaBuilder(object3.getInVars(), unmodifiableTransFormula.getOutVars(), true, Collections.emptySet(), true, Collections.emptyList(), true);
                        object = Substitution.apply((ManagedScript)this.mScript, (Map)object2, (Term)object);
                        lBool.setFormula(object);
                        lBool.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
                        object5 = lBool.finishConstruction(this.mScript);
                        this.mLogger.debug((Object)"Converted TF with local assignment");
                    }
                    object4 = PredicateUtils.isInductiveHelper((Script)this.mScript.getScript(), (IPredicate)iPredicate2, (IPredicate)this.not(iPredicate), (UnmodifiableTransFormula)object6, (Set)object7, (Set)object7);
                    if (this.mLogger.isDebugEnabled()) {
                        this.mLogger.debug((Object)String.format("Is %s", object4));
                    }
                    if (object4 == Script.LBool.SAT) {
                        unmodifiableTransFormula2 = (Term)this.mPredTrans.pre((IAbstractPredicate)iPredicate, (ITransitionRelation)object6);
                        object3 = unmodifiableTransFormula2;
                        unmodifiableTransFormula2 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)object3);
                        unmodifiableTransFormula = this.mLocalPredicateUnifier.getOrConstructPredicate((Term)unmodifiableTransFormula2);
                        object2 = new ProofObligation((IPredicate)unmodifiableTransFormula, icfgLocation3, n - n2 + 1);
                        if (n2 - 1 == 0) {
                            this.mSatProofObligations.add((Pair<ProofObligation, ProofObligation>)new Pair((Object)proofObligation, object2));
                            return false;
                        }
                        deque.addFirst(proofObligation);
                        deque.addFirst((ProofObligation)object2);
                        if (!this.mLogger.isDebugEnabled()) continue;
                        this.mLogger.debug((Object)String.format("pre(%s, %s) == %s", iPredicate, icfgEdge, unmodifiableTransFormula));
                        continue;
                    }
                    if (object4 == Script.LBool.UNSAT) {
                        unmodifiableTransFormula2 = this.computeNewToBeBlocked(iPredicate, icfgEdge, iPredicate2);
                        this.updateLocalFrames((IPredicate)unmodifiableTransFormula2, icfgLocation2, n2, map);
                        proofObligation.addBlockedQuery((Triple<IPredicate, IAction, IPredicate>)unmodifiableTransFormula3);
                        continue;
                    }
                    this.mLogger.error((Object)String.format("Internal query %s && %s && %s was unknown!", iPredicate2, icfgEdge, iPredicate));
                    throw new UnsupportedOperationException("Solver returned unknown");
                }
                if (icfgEdge instanceof IIcfgCallTransition) {
                    if (this.mDealWithProcedures.equals((Object)DealWithProcedures.THROW_EXCEPTION)) {
                        throw new UnsupportedOperationException("Cannot deal with procedures");
                    }
                    if (!this.mLogger.isDebugEnabled()) continue;
                    this.mLogger.debug((Object)"Found Call");
                    continue;
                }
                if (icfgEdge instanceof IIcfgReturnTransition) {
                    if (this.mDealWithProcedures.equals((Object)DealWithProcedures.THROW_EXCEPTION)) {
                        throw new UnsupportedOperationException("Cannot deal with procedures");
                    }
                    if (this.mLogger.isDebugEnabled()) {
                        this.mLogger.debug("Found return, starting PDR for proceedure: %s", new Object[]{((IcfgLocation)icfgEdge.getSource()).getProcedure()});
                    }
                    iPredicate2 = (IIcfgReturnTransition)icfgEdge;
                    unmodifiableTransFormula3 = iPredicate2.getAssignmentOfReturn();
                    object7 = iPredicate2.getCorrespondingCall().getLocalVarsAssignment();
                    this.mLocalAssignmentCall.putIfAbsent(icfgEdge.getPrecedingProcedure(), (UnmodifiableTransFormula)object7);
                    this.mLocalAssignmentRet.putIfAbsent(icfgEdge.getPrecedingProcedure(), unmodifiableTransFormula3);
                    icfgEdge.getPrecedingProcedure();
                    object6 = icfgEdge.getSucceedingProcedure();
                    object5 = this.mCsToolkit.getModifiableGlobalsTable().getModifiedBoogieVars((String)object6);
                    string = this.mCsToolkit.getOldVarsAssignmentCache().getOldVarsAssignment((String)object6);
                    object4 = this.getProcedureTrace((IIcfgReturnTransition<?, ?>)iPredicate2);
                    unmodifiableTransFormula2 = PathProgram.constructPathProgram((String)"procErrorPP", this.mIcfg, new HashSet(object4), Collections.emptySet(), icfgLocation -> true);
                    object3 = new HashSet();
                    object3.add(iPredicate2.getTarget());
                    unmodifiableTransFormula = proofObligation.getToBeBlocked();
                    object2 = new ArrayDeque();
                    object = new ProofObligation((IPredicate)unmodifiableTransFormula, (IcfgLocation)icfgEdge.getSource(), 0);
                    ((ArrayDeque)object2).add(object);
                    lBool = this.computePdr((IIcfg<IcfgLocation>)unmodifiableTransFormula2.getPathProgram(), (Deque<ProofObligation>)object2);
                    if (lBool == Script.LBool.SAT) {
                        Term term;
                        if (this.mLogger.isDebugEnabled()) {
                            this.mLogger.debug((Object)"Procedure can lead to Error!");
                        }
                        Pair<ProofObligation, ProofObligation> pair = this.mSatProofObligations.pop();
                        ProofObligation cfr_ignored_0 = (ProofObligation)pair.getFirst();
                        ProofObligation proofObligation2 = (ProofObligation)pair.getSecond();
                        IcfgLocation icfgLocation4 = iPredicate2.getCallerProgramPoint();
                        IPredicate iPredicate3 = this.mTruePred;
                        Term term2 = term = (Term)this.mPredTrans.preReturn((IAbstractPredicate)proofObligation2.getToBeBlocked(), (IAbstractPredicate)iPredicate3, (ITransitionRelation)unmodifiableTransFormula3, (ITransitionRelation)object7, (ITransitionRelation)string, (Set)object5);
                        term = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)term2);
                        unmodifiableTransFormula = this.mLocalPredicateUnifier.getOrConstructPredicate(term);
                        ProofObligation proofObligation3 = unmodifiableTransFormula != this.mTruePred ? new ProofObligation((IPredicate)unmodifiableTransFormula, icfgLocation4, 0) : new ProofObligation(proofObligation2.getToBeBlocked(), icfgLocation4, 0);
                        List<L> list = this.getSubTrace(icfgLocation4);
                        if (this.mLogger.isDebugEnabled()) {
                            this.mLogger.debug((Object)"Beginning recursive PDR");
                        }
                        PathProgram.PathProgramConstructionResult pathProgramConstructionResult = PathProgram.constructPathProgram((String)"procErrorPP", this.mIcfg, new HashSet<L>(list), null, icfgLocation -> true);
                        ArrayDeque<ProofObligation> arrayDeque = new ArrayDeque<ProofObligation>();
                        arrayDeque.add(proofObligation3);
                        Script.LBool lBool2 = this.computePdr((IIcfg<IcfgLocation>)pathProgramConstructionResult.getPathProgram(), arrayDeque);
                        if (lBool2 == Script.LBool.UNSAT) {
                            this.mLogger.debug((Object)"Recursive is unsat");
                            this.updateLocalFrames(proofObligation3.getToBeBlocked(), ((IIcfgReturnTransition)icfgEdge).getCorrespondingCall().getTarget(), n, map);
                            this.updateSpecificGlobalFrame(this.not(proofObligation3.getToBeBlocked()), ((IIcfgReturnTransition)icfgEdge).getCorrespondingCall().getTarget());
                            if (!this.mLogger.isDebugEnabled()) continue;
                            this.mLogger.debug((Object)"Return to second PDR \n");
                            continue;
                        }
                        if (lBool2 != Script.LBool.SAT) continue;
                        this.mLogger.debug((Object)"SAT");
                        return false;
                    }
                    if (lBool == Script.LBool.UNSAT) {
                        if (this.mLogger.isDebugEnabled()) {
                            this.mLogger.debug((Object)"Procedure can not lead to Error!");
                        }
                        this.updateLocalFrames(iPredicate, icfgLocation2, n2, map);
                        if (!this.mLogger.isDebugEnabled()) continue;
                        this.mLogger.debug((Object)"Return to procedure");
                        continue;
                    }
                    this.mLogger.error((Object)String.format("Internal query was unknown!", new Object[0]));
                    throw new UnsupportedOperationException("Solver returned unknown");
                }
                throw new UnsupportedOperationException("Unknown transition type: " + icfgEdge.getClass().toString());
            }
        }
        return true;
    }

    private IPredicate computeNewToBeBlocked(IPredicate iPredicate, IcfgEdge icfgEdge, IPredicate iPredicate2) throws AssertionError {
        IPredicate iPredicate3;
        if (icfgEdge.getTransformula().getFormula() != this.mTruePred.getFormula()) {
            IPredicate iPredicate4 = this.getInterpolant(icfgEdge, iPredicate2, iPredicate);
            if (iPredicate4 != null) {
                Term term = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{this.not(iPredicate4).getFormula(), iPredicate.getFormula()});
                iPredicate3 = this.mLocalPredicateUnifier.getOrConstructPredicate(term);
            } else {
                this.mLogger.warn("Interpolation yielded UNKNOWN for pF={%s} T=%s pP={%s}", new Object[]{iPredicate2, icfgEdge, iPredicate});
                iPredicate3 = iPredicate;
            }
        } else {
            iPredicate3 = iPredicate;
        }
        return iPredicate3;
    }

    private IPredicate getInterpolant(IcfgEdge icfgEdge, IPredicate iPredicate, IPredicate iPredicate2) throws AssertionError {
        IProgramVar iProgramVar;
        IProgramVar iProgramVar22;
        IProgramVar iProgramVar32;
        Term term = Pdr.andPredTf(this.mScript.getScript(), iPredicate, icfgEdge.getTransformula(), this.mCsToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(icfgEdge.getPrecedingProcedure()));
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)String.format("Converted frame %s and transformula %s to %s", iPredicate, icfgEdge.getTransformula(), term));
        }
        Term term2 = this.mTruePred.getFormula();
        Set set = iPredicate2.getVars();
        HashMap<ApplicationTerm, ApplicationTerm> hashMap = new HashMap<ApplicationTerm, ApplicationTerm>();
        HashMap<ApplicationTerm, ApplicationTerm> hashMap2 = new HashMap<ApplicationTerm, ApplicationTerm>();
        HashMap<ApplicationTerm, TermVariable> hashMap3 = new HashMap<ApplicationTerm, TermVariable>();
        HashMap hashMap4 = new HashMap(icfgEdge.getTransformula().getOutVars());
        for (IProgramVar iProgramVar32 : set) {
            hashMap.put(iProgramVar32.getDefaultConstant(), iProgramVar32.getPrimedConstant());
            hashMap3.put(iProgramVar32.getPrimedConstant(), iProgramVar32.getTermVariable());
        }
        iProgramVar32 = new ArrayList();
        ArrayList arrayList = new ArrayList();
        for (IProgramVar iProgramVar22 : hashMap4.keySet()) {
            iProgramVar32.add(iProgramVar22.getDefaultConstant());
            arrayList.add(iProgramVar22.getPrimedConstant());
        }
        for (IProgramVar iProgramVar22 : iPredicate.getVars()) {
            iProgramVar32.add(iProgramVar22.getDefaultConstant());
            arrayList.add(iProgramVar22.getPrimedConstant());
        }
        term2 = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{term2, SmtUtils.pairwiseEquality((Script)this.mScript.getScript(), (List)iProgramVar32, (List)arrayList)});
        Term term3 = term.getFreeVars();
        int n = ((TermVariable[])term3).length;
        int n2 = 0;
        while (n2 < n) {
            iProgramVar22 = term3[n2];
            iProgramVar = this.mSymbolTable.getProgramVar((TermVariable)iProgramVar22);
            if (hashMap4.containsKey(iProgramVar)) {
                hashMap2.put(iProgramVar.getDefaultConstant(), iProgramVar.getPrimedConstant());
                hashMap3.put(iProgramVar.getPrimedConstant(), iProgramVar.getTermVariable());
            }
            ++n2;
        }
        iProgramVar22 = Substitution.apply((ManagedScript)this.mScript, hashMap, (Term)iPredicate2.getClosedFormula());
        Term term4 = Substitution.apply((ManagedScript)this.mScript, hashMap2, (Term)term);
        term4 = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{term4, term2});
        Pair pair = SmtUtils.interpolateBinary((Script)this.mScript.getScript(), (Term)term4, (Term)iProgramVar22);
        if (pair.getFirst() == Script.LBool.UNKNOWN) {
            return null;
        }
        if (pair.getFirst() == Script.LBool.SAT) {
            throw new AssertionError((Object)String.format("Wrong interpolation query (is sat): Renamed FrameAndTrans: %s Renamed Pre: %s", term4, iProgramVar22));
        }
        term3 = Substitution.apply((ManagedScript)this.mScript, hashMap3, (Term)((Term)pair.getSecond()));
        iProgramVar = this.mLocalPredicateUnifier.getOrConstructPredicate(term3);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)String.format("Interpolant: %s (%s from binInt(%s  %s))", iProgramVar, pair.getSecond(), iProgramVar22, term));
        }
        return iProgramVar;
    }

    private void addProofObligation(Deque<ProofObligation> deque, ProofObligation proofObligation, int n, IcfgLocation icfgLocation, IPredicate iPredicate) {
        ProofObligation proofObligation2 = new ProofObligation(iPredicate, icfgLocation, this.mLevel - n + 1);
        deque.addFirst(proofObligation);
        deque.addFirst(proofObligation2);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("New PO: " + String.valueOf(proofObligation2)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateLocalFrames(IPredicate iPredicate, IcfgLocation icfgLocation, int n, Map<IcfgLocation, List<Pair<ChangedFrame, IPredicate>>> map) {
        void entry;
        boolean n2 = false;
        while (entry <= n) {
            ArrayList<IPredicate> arrayList = new ArrayList<IPredicate>(2);
            arrayList.add((IPredicate)map.get(icfgLocation).get((int)entry).getSecond());
            arrayList.add(this.not(iPredicate));
            IPredicate iPredicate2 = this.mLocalPredicateUnifier.getOrConstructPredicateForConjunction((Collection)arrayList);
            map.get(icfgLocation).set((int)entry, (Pair<ChangedFrame, IPredicate>)new Pair((Object)ChangedFrame.C, (Object)iPredicate2));
            ++entry;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"LOCAL Frames: Updated \n");
            for (Map.Entry entry2 : map.entrySet()) {
                this.mLogger.debug((Object)("  " + String.valueOf(((IcfgLocation)entry2.getKey()).getDebugIdentifier()) + ": " + ((List)entry2.getValue()).stream().map(BaseTuple::toString).collect(Collectors.joining(","))));
            }
        }
    }

    final void updateGlobalFrames(Map<IcfgLocation, List<Pair<ChangedFrame, IPredicate>>> map, int n) {
        for (Map.Entry<IcfgLocation, IPredicate> entry : this.mGlobalFrames.entrySet()) {
            if (!map.containsKey(entry.getKey())) continue;
            this.mLogger.debug("%s, %s, %s", new Object[]{entry.getKey(), n, map.get(entry.getKey()).size()});
            IPredicate iPredicate = (IPredicate)map.get(entry.getKey()).get(n).getSecond();
            if (entry.getValue() == this.mTruePred) {
                this.mGlobalFrames.replace(entry.getKey(), this.mLocalPredicateUnifier.getOrConstructPredicate(iPredicate));
                continue;
            }
            Term term = Util.or((Script)this.mScript.getScript(), (Term[])new Term[]{iPredicate.getFormula(), entry.getValue().getFormula()});
            this.mGlobalFrames.replace(entry.getKey(), this.mLocalPredicateUnifier.getOrConstructPredicate(term));
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"GLOBAL Frames: Updated \n");
            for (Map.Entry<IcfgLocation, IPredicate> entry : this.mGlobalFrames.entrySet()) {
                this.mLogger.debug("%s: %s", new Object[]{entry.getKey(), entry.getValue()});
            }
        }
    }

    final void updateSpecificGlobalFrame(IPredicate iPredicate, IcfgLocation icfgLocation) {
        IPredicate iPredicate2 = this.mGlobalFrames.get(icfgLocation);
        if (iPredicate2 == this.mTruePred) {
            this.mGlobalFrames.replace(icfgLocation, this.mLocalPredicateUnifier.getOrConstructPredicate(iPredicate));
        } else {
            Term object = Util.or((Script)this.mScript.getScript(), (Term[])new Term[]{iPredicate2.getFormula(), iPredicate.getFormula()});
            this.mGlobalFrames.replace(icfgLocation, this.mLocalPredicateUnifier.getOrConstructPredicate(object));
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"GLOBAL SPECIFIC Frames: Updated \n");
            for (Map.Entry<IcfgLocation, IPredicate> entry : this.mGlobalFrames.entrySet()) {
                this.mLogger.debug("%s: %s", new Object[]{entry.getKey(), entry.getValue()});
            }
        }
    }

    final Map<IcfgLocation, IPredicate> initializeGlobalFrames(IIcfg<? extends IcfgLocation> iIcfg) {
        HashMap<IcfgLocation, IPredicate> hashMap = new HashMap<IcfgLocation, IPredicate>();
        Set set = IcfgUtils.getErrorLocations(this.mPpIcfg);
        IcfgLocationIterator icfgLocationIterator = new IcfgLocationIterator(iIcfg);
        while (icfgLocationIterator.hasNext()) {
            IcfgLocation icfgLocation = icfgLocationIterator.next();
            if (set.contains(icfgLocation)) continue;
            hashMap.put(icfgLocation, this.mTruePred);
        }
        return hashMap;
    }

    final Map<IcfgLocation, List<Pair<ChangedFrame, IPredicate>>> initializeLocalFrames(IIcfg<? extends IcfgLocation> iIcfg) {
        HashMap<IcfgLocation, List<Pair<ChangedFrame, IPredicate>>> hashMap = new HashMap<IcfgLocation, List<Pair<ChangedFrame, IPredicate>>>();
        Set set = IcfgUtils.getErrorLocations(iIcfg);
        Set set2 = iIcfg.getInitialNodes();
        IcfgLocationIterator icfgLocationIterator = new IcfgLocationIterator(iIcfg);
        while (icfgLocationIterator.hasNext()) {
            IcfgLocation icfgLocation = icfgLocationIterator.next();
            if (set.contains(icfgLocation)) continue;
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            IPredicate iPredicate = this.mGlobalFrames.get(icfgLocation);
            IPredicate iPredicate2 = set2.contains(icfgLocation) ? iPredicate : (iPredicate != this.mTruePred ? this.mLocalPredicateUnifier.getOrConstructPredicate(iPredicate) : this.mFalsePred);
            arrayList.add(new Pair((Object)ChangedFrame.U, (Object)iPredicate2));
            hashMap.put(icfgLocation, arrayList);
        }
        return hashMap;
    }

    private List<L> getProcedureTrace(IIcfgReturnTransition<?, ?> iIcfgReturnTransition) {
        Object object2;
        IcfgLocation icfgLocation = iIcfgReturnTransition.getSource();
        IIcfgCallTransition iIcfgCallTransition = iIcfgReturnTransition.getCorrespondingCall();
        IcfgLocation icfgLocation2 = iIcfgCallTransition.getTarget();
        ArrayList<UnmodifiableTransFormula> arrayList = new ArrayList<UnmodifiableTransFormula>();
        arrayList.add(iIcfgReturnTransition.getTransformula());
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        for (Object object2 : this.mTrace) {
            if (object2.getSource().equals((Object)icfgLocation2.getLabel())) {
                n2 = n;
            } else if (object2.getSource().equals((Object)icfgLocation.getLabel())) {
                n3 = n;
            }
            ++n;
        }
        assert (n2 != -1);
        assert (n3 != -1);
        object2 = new ArrayList<L>(this.mTrace.subList(n2, n3));
        return object2;
    }

    private List<L> getSubTrace(IcfgLocation icfgLocation) {
        Object object2;
        int n = -1;
        int n2 = 0;
        for (Object object2 : this.mTrace) {
            if (object2.getSource().equals((Object)icfgLocation.getLabel())) {
                n = n2;
            }
            ++n2;
        }
        assert (n != -1);
        object2 = new ArrayList<L>(this.mTrace.subList(0, n));
        return object2;
    }

    private final UnmodifiableTransFormula normalizeTerm(UnmodifiableTransFormula unmodifiableTransFormula) {
        HashMap<Term, TermVariable> hashMap = new HashMap<Term, TermVariable>();
        Term term2 = unmodifiableTransFormula.getFormula();
        HashMap<IProgramVar, TermVariable> hashMap2 = new HashMap<IProgramVar, TermVariable>();
        HashMap<IProgramVar, TermVariable> hashMap3 = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry term3 : unmodifiableTransFormula.getOutVars().entrySet()) {
            hashMap.put((Term)term3.getValue(), ((IProgramVar)term3.getKey()).getTermVariable());
            hashMap3.put((IProgramVar)term3.getKey(), ((IProgramVar)term3.getKey()).getTermVariable());
        }
        for (Map.Entry entry : unmodifiableTransFormula.getInVars().entrySet()) {
            hashMap.put((Term)entry.getValue(), ((IProgramVar)entry.getKey()).getTermVariable());
            hashMap2.put((IProgramVar)entry.getKey(), ((IProgramVar)entry.getKey()).getTermVariable());
        }
        Term term = Substitution.apply((ManagedScript)this.mScript, hashMap, (Term)term2);
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(hashMap2, hashMap3, true, Collections.emptySet(), true, Collections.emptySet(), true);
        transFormulaBuilder.setFormula(term);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return transFormulaBuilder.finishConstruction(this.mScript);
    }

    private final Map<Term, Term> convertEqualToMap(Term term, Boolean bl) {
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        if (applicationTerm.getFunction().getName().equals("=")) {
            if (bl.booleanValue()) {
                hashMap.put(applicationTerm.getParameters()[0], applicationTerm.getParameters()[1]);
            } else {
                hashMap.put(applicationTerm.getParameters()[1], applicationTerm.getParameters()[0]);
            }
        }
        return hashMap;
    }

    private final boolean propagationPhase(Map<IcfgLocation, List<Pair<ChangedFrame, IPredicate>>> map) {
        this.mLogger.debug((Object)"Begin Propagation Phase: \n");
        for (Map.Entry<IcfgLocation, List<Pair<ChangedFrame, IPredicate>>> entry : map.entrySet()) {
            List<Pair<ChangedFrame, IPredicate>> list = entry.getValue();
            int n = 0;
            while (n < list.size() - 1) {
                IPredicate iPredicate = (IPredicate)list.get(n).getSecond();
                IPredicate iPredicate2 = (IPredicate)list.get(n + 1).getSecond();
                if (iPredicate.getFormula().equals(iPredicate2.getFormula()) && this.checkFrames(n, map)) {
                    this.mLogger.debug((Object)("Spot: " + n));
                    this.mInvarSpot = n;
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private final boolean checkFrames(int n, Map<IcfgLocation, List<Pair<ChangedFrame, IPredicate>>> map) {
        for (Map.Entry<IcfgLocation, List<Pair<ChangedFrame, IPredicate>>> entry : map.entrySet()) {
            if (this.mPpIcfg.getInitialNodes().contains(entry.getKey())) continue;
            List<Pair<ChangedFrame, IPredicate>> list = entry.getValue();
            IPredicate iPredicate = (IPredicate)list.get(n).getSecond();
            IPredicate iPredicate2 = (IPredicate)list.get(n + 1).getSecond();
            if (iPredicate.getFormula().equals(iPredicate2.getFormula())) continue;
            return false;
        }
        return true;
    }

    private final IPredicate not(IPredicate iPredicate) {
        return this.mLocalPredicateUnifier.getOrConstructPredicate(SmtUtils.not((Script)this.mScript.getScript(), (Term)iPredicate.getFormula()));
    }

    private final IPredicate[] computeInterpolants() {
        List list;
        IPredicate iPredicate2;
        IPredicate iPredicate3;
        IcfgLocation icfgLocation;
        this.mLogger.debug((Object)"Computing interpolants.");
        HashMap<IcfgLocation, IPredicate> hashMap = new HashMap<IcfgLocation, IPredicate>();
        for (Map.Entry<IcfgLocation, IPredicate> object2 : this.mGlobalFrames.entrySet()) {
            IcfgLocation n2 = object2.getKey();
            icfgLocation = n2.getLabel();
            assert (n2 != icfgLocation) : "Not a path program loc";
            assert (this.mInvarSpot != -1) : "Invariants";
            iPredicate3 = object2.getValue();
            iPredicate2 = hashMap.put(icfgLocation, iPredicate3);
            assert (iPredicate2 == null || iPredicate2.equals(iPredicate3));
        }
        Iterator<L> iterator = this.mTrace.iterator();
        IPredicate[] iPredicateArray = new IPredicate[this.mTrace.size() - 1];
        int n2 = 0;
        while (iterator.hasNext()) {
            icfgLocation = (IIcfgTransition)iterator.next();
            if (!iterator.hasNext()) break;
            iPredicate3 = (IPredicate)hashMap.get(icfgLocation.getTarget());
            assert (iPredicate3 != null);
            iPredicateArray[n2] = iPredicate3;
            ++n2;
        }
        icfgLocation = TraceCheckUtils.toNestedWord(this.mTrace);
        iPredicate3 = new IterativePredicateTransformer(this.mLocalPredicateUnifier.getPredicateFactory(), this.mScript, this.mCsToolkit.getModifiableGlobalsTable(), this.mServices, (NestedWord)icfgLocation, this.mTruePred, this.mFalsePred, Collections.emptySortedMap(), this.mTruePred, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, this.mSymbolTable);
        iPredicate2 = this.mCsToolkit.getOldVarsAssignmentCache();
        DefaultTransFormulas defaultTransFormulas = new DefaultTransFormulas((Word)icfgLocation, this.mTruePred, this.mFalsePred, Collections.emptySortedMap(), (OldVarsAssignmentCache)iPredicate2, false);
        IterativePredicateTransformer.IPredicatePostprocessor iPredicatePostprocessor = (iPredicate, n) -> {
            Term term;
            Term term2;
            if (n == 0 || n == this.mTrace.size()) {
                term2 = iPredicate.getFormula();
            } else {
                term = iPredicateArray[n - 1].getFormula();
                term2 = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{iPredicate.getFormula(), term});
            }
            term = term2;
            Term term3 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)term);
            IPredicate iPredicate2 = this.mLocalPredicateUnifier.getOrConstructPredicate(term3);
            assert (iPredicate2 != null);
            return iPredicate2;
        };
        try {
            list = iPredicate3.computeWeakestPreconditionSequence((NestedFormulas)defaultTransFormulas, Collections.singletonList(iPredicatePostprocessor), false, false).getPredicates();
        }
        catch (IterativePredicateTransformer.TraceInterpolationException traceInterpolationException) {
            throw new RuntimeException(traceInterpolationException);
        }
        assert (TraceCheckUtils.checkInterpolantsInductivityBackward((List)list, (NestedWord)icfgLocation, (IPredicate)this.mTruePred, (IPredicate)this.mFalsePred, Collections.emptyMap(), (String)"BP", (CfgSmtToolkit)this.mCsToolkit, (ILogger)this.mLogger, (ManagedScript)this.mScript)) : "invalid Hoare triple in BP";
        return list.toArray(new IPredicate[list.size()]);
    }

    private static Term primePredicate(Script script, IPredicate iPredicate, UnmodifiableTransFormula unmodifiableTransFormula, Set<IProgramNonOldVar> set) {
        IProgramVar iProgramVar2;
        Set set2 = unmodifiableTransFormula.getAssignedVars();
        HashMap<TermVariable, ApplicationTerm> hashMap = new HashMap<TermVariable, ApplicationTerm>();
        for (IProgramVar iProgramVar2 : iPredicate.getVars()) {
            ApplicationTerm applicationTerm = set2.contains(iProgramVar2) ? iProgramVar2.getPrimedConstant() : iProgramVar2.getDefaultConstant();
            hashMap.put(iProgramVar2.getTermVariable(), applicationTerm);
        }
        iProgramVar2 = PureSubstitution.apply((Script)script, hashMap, (Term)iPredicate.getFormula());
        return iProgramVar2;
    }

    private static Term andPredTf(Script script, IPredicate iPredicate, UnmodifiableTransFormula unmodifiableTransFormula, Set<IProgramNonOldVar> set) {
        IProgramNonOldVar iProgramNonOldVar2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet<IProgramNonOldVar> hashSet = new HashSet<IProgramNonOldVar>();
        HashSet<IProgramNonOldVar> hashSet2 = new HashSet<IProgramNonOldVar>();
        Pdr.findNonModifiablesGlobals(iPredicate.getVars(), set, Collections.emptySet(), hashSet, hashSet2);
        Pdr.findNonModifiablesGlobals(unmodifiableTransFormula.getInVars().keySet(), set, Collections.emptySet(), hashSet, hashSet2);
        for (IProgramNonOldVar iProgramNonOldVar2 : hashSet) {
            arrayList.add(ModifiableGlobalsTable.constructConstantOldVarEquality((IProgramNonOldVar)iProgramNonOldVar2, (boolean)false, (Script)script));
        }
        for (IProgramNonOldVar iProgramNonOldVar2 : hashSet2) {
            arrayList.add(ModifiableGlobalsTable.constructConstantOldVarEquality((IProgramNonOldVar)iProgramNonOldVar2, (boolean)true, (Script)script));
        }
        iProgramNonOldVar2 = iPredicate.getClosedFormula();
        assert (iProgramNonOldVar2 != null);
        arrayList.add(iProgramNonOldVar2);
        Term term = unmodifiableTransFormula.getClosedFormula();
        assert (term != null);
        arrayList.add(term);
        return SmtUtils.and((Script)script, arrayList);
    }

    private static void findNonModifiablesGlobals(Set<IProgramVar> set, Set<IProgramNonOldVar> set2, Set<IProgramVar> set3, Set<IProgramNonOldVar> set4, Set<IProgramNonOldVar> set5) {
        for (IProgramVar iProgramVar : set) {
            IProgramNonOldVar iProgramNonOldVar;
            if (!(iProgramVar instanceof IProgramOldVar) || set2.contains(iProgramNonOldVar = ((IProgramOldVar)iProgramVar).getNonOldVar())) continue;
            if (set3.contains(iProgramVar)) {
                set5.add(iProgramNonOldVar);
                continue;
            }
            set4.add(iProgramNonOldVar);
        }
    }

    private IProgramExecution<L, Term> computeProgramExecution() {
        if (this.mIsTraceCorrect == Script.LBool.SAT) {
            return IProgramExecution.emptyExecution(Term.class, this.mTransitionClazz);
        }
        return null;
    }

    private static ManagedScript createSolver(IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit) throws AssertionError {
        return cfgSmtToolkit.getManagedScript();
    }

    public Script.LBool isCorrect() {
        return this.mIsTraceCorrect;
    }

    public IPredicate getPrecondition() {
        return this.mTruePred;
    }

    public IPredicate getPostcondition() {
        return this.mFalsePred;
    }

    public Map<Integer, IPredicate> getPendingContexts() {
        return Collections.emptyMap();
    }

    public boolean providesRcfgProgramExecution() {
        return this.mIsTraceCorrect != Script.LBool.SAT;
    }

    public IProgramExecution<L, Term> getRcfgProgramExecution() {
        if (this.mFeasibleProgramExecution == null) {
            this.mFeasibleProgramExecution = this.computeProgramExecution();
        }
        return this.mFeasibleProgramExecution;
    }

    public IStatisticsDataProvider getStatistics() {
        return this.mPdrBenchmark;
    }

    public TraceCheckReasonUnknown getTraceCheckReasonUnknown() {
        return this.mReasonUnknown;
    }

    public boolean wasTracecheckFinishedNormally() {
        return this.mTraceCheckFinishedNormally;
    }

    public List<L> getTrace() {
        return this.mTrace;
    }

    public IPredicate[] getInterpolants() {
        return this.mInterpolants;
    }

    public IPredicateUnifier getPredicateUnifier() {
        return this.mLocalPredicateUnifier;
    }

    public boolean isPerfectSequence() {
        return this.isCorrect() == Script.LBool.UNSAT;
    }

    public InterpolantComputationStatus getInterpolantComputationStatus() {
        if (this.isCorrect() == Script.LBool.UNSAT) {
            return new InterpolantComputationStatus();
        }
        if (this.isCorrect() == Script.LBool.SAT) {
            return new InterpolantComputationStatus(InterpolantComputationStatus.ItpErrorStatus.TRACE_FEASIBLE, null);
        }
        throw new UnsupportedOperationException();
    }

    private static enum ChangedFrame {
        C,
        U;

    }

    private static enum DealWithProcedures {
        THROW_EXCEPTION,
        CONTINUE;

    }
}

