/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker;

import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Lasso
implements Serializable {
    private static final long serialVersionUID = 8922273828007750770L;
    private final LinearTransition mStem;
    private final LinearTransition mLoop;

    public Lasso(LinearTransition linearTransition, LinearTransition linearTransition2) {
        LinearTransition linearTransition3 = Lasso.balanceVariablesStem(linearTransition, linearTransition2);
        LinearTransition linearTransition4 = Lasso.balanceVariablesLoop(linearTransition, linearTransition2);
        this.mStem = linearTransition3 == null ? LinearTransition.getTranstionTrue() : linearTransition3;
        this.mLoop = linearTransition4 == null ? LinearTransition.getTranstionTrue() : linearTransition4;
    }

    public LinearTransition getStem() {
        assert (this.mStem != null);
        return this.mStem;
    }

    public LinearTransition getLoop() {
        assert (this.mLoop != null);
        return this.mLoop;
    }

    public int getLoopVarNum() {
        return this.mLoop.getVariables().size();
    }

    public int getStemVarNum() {
        return this.mStem.getVariables().size();
    }

    public int getLoopDisjuncts() {
        return this.mLoop.getNumPolyhedra();
    }

    public int getStemDisjuncts() {
        return this.mStem.getNumPolyhedra();
    }

    public Collection<IProgramVar> getAllRankVars() {
        LinkedHashSet<IProgramVar> linkedHashSet = new LinkedHashSet<IProgramVar>(this.mStem.getInVars().keySet());
        linkedHashSet.addAll(this.mStem.getOutVars().keySet());
        linkedHashSet.addAll(this.mLoop.getInVars().keySet());
        linkedHashSet.addAll(this.mLoop.getOutVars().keySet());
        return linkedHashSet;
    }

    /*
     * WARNING - void declaration
     */
    public Rational[] guessEigenvalues(boolean bl) {
        HashSet<Rational> hashSet = new HashSet<Rational>();
        hashSet.add(Rational.ZERO);
        hashSet.add(Rational.ONE);
        for (List<LinearInequality> list : this.mLoop.getPolyhedra()) {
            Term term;
            Serializable serializable;
            Object object;
            Term[] termArray;
            HashMap hashMap = new HashMap();
            for (LinearInequality linearInequality : list) {
                void var12_17;
                if (linearInequality.isStrict() || !linearInequality.getConstant().isZero() || linearInequality.getVariables().size() != 2) continue;
                termArray = linearInequality.getVariables().toArray(new Term[2]);
                object = linearInequality.getCoefficient(termArray[0]);
                serializable = linearInequality.getCoefficient(termArray[1]);
                assert (!((AffineTerm)object).isZero());
                assert (!((AffineTerm)serializable).isZero());
                if (!((AffineTerm)object).isConstant() || !((AffineTerm)serializable).isConstant() || !((AffineTerm)object).getConstant().equals((Object)((AffineTerm)serializable).getConstant().negate())) continue;
                term = termArray[0];
                Term term2 = termArray[1];
                if (((AffineTerm)object).getConstant().isNegative()) {
                    Iterator<LinearInequality> iterator = term;
                    term = term2;
                    Iterator<LinearInequality> iterator2 = iterator;
                }
                if (!hashMap.containsKey(term)) {
                    hashMap.put(term, new HashSet());
                }
                ((Set)hashMap.get(term)).add(var12_17);
            }
            for (Map.Entry entry : this.mLoop.getOutVars().entrySet()) {
                termArray = (Term[])entry.getKey();
                object = (Term)entry.getValue();
                if (!this.mLoop.getInVars().containsKey(termArray)) continue;
                serializable = new ArrayList();
                term = (Term)this.mLoop.getInVars().get(termArray);
                serializable.add(term);
                if (hashMap.containsKey(term)) {
                    for (Term term3 : (Set)hashMap.get(term)) {
                        if (!hashMap.containsKey(term3) || !((Set)hashMap.get(term3)).contains(term)) continue;
                        serializable.add(term3);
                    }
                }
                for (LinearInequality linearInequality : list) {
                    Iterator iterator = serializable.iterator();
                    while (iterator.hasNext()) {
                        Term term4 = (Term)iterator.next();
                        AffineTerm affineTerm = linearInequality.getCoefficient(term4);
                        AffineTerm affineTerm2 = linearInequality.getCoefficient((Term)object);
                        if (affineTerm.isZero() || affineTerm2.isZero()) continue;
                        assert (affineTerm.isConstant());
                        assert (affineTerm2.isConstant());
                        Rational rational = affineTerm.getConstant().div(affineTerm2.getConstant()).negate();
                        if (rational.isNegative() && !bl) continue;
                        hashSet.add(rational);
                    }
                }
            }
        }
        return hashSet.toArray(new Rational[hashSet.size()]);
    }

    private static LinearTransition balanceVariablesStem(LinearTransition linearTransition, LinearTransition linearTransition2) {
        if (linearTransition == null || linearTransition2 == null) {
            return linearTransition;
        }
        HashMap<IProgramVar, TermVariable> hashMap = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> object : linearTransition2.getInVars().entrySet()) {
            if (linearTransition.getInVars().containsKey(object.getKey()) || linearTransition.getOutVars().containsKey(object.getKey())) continue;
            hashMap.put(object.getKey(), object.getValue());
        }
        if (!hashMap.isEmpty()) {
            HashMap<IProgramVar, TermVariable> hashMap2 = new HashMap<IProgramVar, TermVariable>(linearTransition.getInVars());
            HashMap<IProgramVar, TermVariable> hashMap22 = new HashMap<IProgramVar, TermVariable>(linearTransition.getOutVars());
            hashMap2.putAll(hashMap);
            hashMap22.putAll(hashMap);
            return new LinearTransition(linearTransition.getPolyhedra(), hashMap2, (Map<IProgramVar, TermVariable>)hashMap22);
        }
        return linearTransition;
    }

    private static LinearTransition balanceVariablesLoop(LinearTransition linearTransition, LinearTransition linearTransition2) {
        if (linearTransition == null || linearTransition2 == null) {
            return linearTransition2;
        }
        HashMap<IProgramVar, TermVariable> hashMap = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> object : linearTransition.getOutVars().entrySet()) {
            if (linearTransition2.getInVars().containsKey(object.getKey()) || linearTransition2.getOutVars().containsKey(object.getKey())) continue;
            hashMap.put(object.getKey(), object.getValue());
        }
        if (!hashMap.isEmpty()) {
            HashMap<IProgramVar, TermVariable> hashMap2 = new HashMap<IProgramVar, TermVariable>(linearTransition2.getInVars());
            HashMap<IProgramVar, TermVariable> hashMap22 = new HashMap<IProgramVar, TermVariable>(linearTransition2.getOutVars());
            hashMap2.putAll(hashMap);
            hashMap22.putAll(hashMap);
            return new LinearTransition(linearTransition2.getPolyhedra(), hashMap2, (Map<IProgramVar, TermVariable>)hashMap22);
        }
        return linearTransition2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Stem: ");
        stringBuilder.append(this.mStem);
        stringBuilder.append("\nLoop: ");
        stringBuilder.append(this.mLoop);
        return stringBuilder.toString();
    }
}

