/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.ITreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonRule;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.isDetereministic;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class isTotal<LETTER extends IRankedLetter, STATE>
extends GeneralOperation<LETTER, STATE, IStateFactory<STATE>>
implements IOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final ITreeAutomatonBU<LETTER, STATE> mTreeAutomaton;
    private final boolean mResultTreeRun;

    public isTotal(AutomataLibraryServices automataLibraryServices, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU) {
        super(automataLibraryServices);
        this.mTreeAutomaton = iTreeAutomatonBU;
        this.mResultTreeRun = this.computeResult() && new isDetereministic<LETTER, STATE>(automataLibraryServices, this.mTreeAutomaton).getResult() != false;
    }

    private boolean computeResult() {
        HashMap hashMap = new HashMap();
        for (List<STATE> list : this.mTreeAutomaton.getSourceCombinations()) {
            for (TreeAutomatonRule<List<STATE>, STATE> treeAutomatonRule : this.mTreeAutomaton.getSuccessors(list)) {
                Object LETTER = treeAutomatonRule.getLetter();
                if (!hashMap.containsKey(LETTER)) {
                    hashMap.put(LETTER, new HashSet());
                }
                ((Set)hashMap.get(LETTER)).add(treeAutomatonRule.getSource());
            }
        }
        int n = this.mTreeAutomaton.getStates().size();
        for (Object object : this.mTreeAutomaton.getAlphabet()) {
            if (!hashMap.containsKey(object)) {
                return false;
            }
            int n2 = ((Set)hashMap.get(object)).size();
            int n3 = object.getRank();
            while (n3 > 0) {
                if (n2 % n != 0) {
                    return false;
                }
                --n3;
                n2 /= n;
            }
            if (n2 == 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean getResult() {
        return this.mResultTreeRun;
    }

    @Override
    public String startMessage() {
        return "Starting totality check";
    }

    @Override
    public String exitMessage() {
        return "Exit totality check";
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }
}

