/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.ComplementDeterministicNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.DeterminizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IStateDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEquivalent;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.PowersetDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.TotalizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.ComplementDD;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.IntersectDD;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IDeterminizeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISinkStateFactory;

public final class Complement<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, INwaInclusionStateFactory<STATE>> {
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    private ComplementDeterministicNwa<LETTER, STATE> mComplement;
    private final NestedWordAutomatonReachableStates<LETTER, STATE> mResult;
    private final IStateDeterminizer<LETTER, STATE> mStateDeterminizer;
    private final ISinkStateFactory<STATE> mStateFactory;

    public <SF extends ISinkStateFactory<STATE> & IDeterminizeStateFactory<STATE>> Complement(AutomataLibraryServices automataLibraryServices, SF SF, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException {
        this(automataLibraryServices, SF, iNwaOutgoingLetterAndTransitionProvider, new PowersetDeterminizer<LETTER, STATE>(iNwaOutgoingLetterAndTransitionProvider, true, SF));
    }

    public Complement(AutomataLibraryServices automataLibraryServices, ISinkStateFactory<STATE> iSinkStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, IStateDeterminizer<LETTER, STATE> iStateDeterminizer) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mStateDeterminizer = iStateDeterminizer;
        this.mStateFactory = iSinkStateFactory;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mResult = this.computeComplement();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    private NestedWordAutomatonReachableStates<LETTER, STATE> computeComplement() throws AutomataOperationCanceledException {
        NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates;
        if (this.mOperand instanceof DeterminizeNwa) {
            DeterminizeNwa determinizeNwa = (DeterminizeNwa)this.mOperand;
            this.mComplement = new ComplementDeterministicNwa(determinizeNwa);
            return new NestedWordAutomatonReachableStates<LETTER, STATE>(this.mServices, this.mComplement);
        }
        if (this.mStateDeterminizer instanceof PowersetDeterminizer && (nestedWordAutomatonReachableStates = this.tryWithoutDeterminization()) != null) {
            return nestedWordAutomatonReachableStates;
        }
        DeterminizeNwa<LETTER, STATE> determinizeNwa = new DeterminizeNwa<LETTER, STATE>(this.mServices, this.mOperand, this.mStateDeterminizer, this.mStateFactory, null, true);
        this.mComplement = new ComplementDeterministicNwa<LETTER, STATE>(determinizeNwa);
        return new NestedWordAutomatonReachableStates<LETTER, STATE>(this.mServices, this.mComplement);
    }

    private NestedWordAutomatonReachableStates<LETTER, STATE> tryWithoutDeterminization() throws AutomataOperationCanceledException {
        assert (this.mStateDeterminizer instanceof PowersetDeterminizer);
        TotalizeNwa<LETTER, ISinkStateFactory<STATE>> totalizeNwa = new TotalizeNwa<LETTER, ISinkStateFactory<STATE>>(this.mOperand, this.mStateFactory, true);
        ComplementDeterministicNwa<LETTER, ISinkStateFactory<STATE>> complementDeterministicNwa = new ComplementDeterministicNwa<LETTER, ISinkStateFactory<STATE>>(totalizeNwa);
        NestedWordAutomatonReachableStates<LETTER, ISinkStateFactory<STATE>> nestedWordAutomatonReachableStates = new NestedWordAutomatonReachableStates<LETTER, ISinkStateFactory<STATE>>(this.mServices, complementDeterministicNwa);
        if (!totalizeNwa.nonDeterminismInInputDetected()) {
            this.mComplement = complementDeterministicNwa;
            if (this.mLogger.isInfoEnabled()) {
                this.mLogger.info((Object)"Operand was deterministic. Have not used determinization.");
            }
            return nestedWordAutomatonReachableStates;
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)"Operand was not deterministic. Recomputing result with determinization.");
        }
        return null;
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Result " + this.mResult.sizeInformation();
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(INwaInclusionStateFactory<STATE> iNwaInclusionStateFactory) throws AutomataLibraryException {
        boolean bl = true;
        if (this.mStateDeterminizer instanceof PowersetDeterminizer) {
            if (this.mLogger.isInfoEnabled()) {
                this.mLogger.info((Object)("Start testing correctness of " + this.getOperationName()));
            }
            Object object = new IntersectDD<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, this.mOperand, this.mResult).getResult();
            bl &= new IsEmpty(this.mServices, object).getResult().booleanValue();
            Object object2 = new ComplementDD<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, this.mOperand).getResult();
            bl &= new IsEquivalent<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, object2, this.mResult).getResult().booleanValue();
            if (this.mLogger.isInfoEnabled()) {
                this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
            }
        } else if (this.mLogger.isWarnEnabled()) {
            this.mLogger.warn((Object)"operation not tested");
        }
        if (!bl) {
            AutomatonDefinitionPrinter.writeToFileIfPreferred(this.mServices, this.getOperationName() + "Failed", "language is different", this.mOperand);
        }
        return bl;
    }
}

