/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.visualization;

import de.uni_freiburg.informatik.ultimate.automata.GeneralAutomatonPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class CommonExternalFormatWriter<LETTER, STATE>
extends GeneralAutomatonPrinter {
    protected final Map<LETTER, String> mAlphabetMapping;
    protected final Map<STATE, String> mStateMapping;
    protected final INestedWordAutomaton<LETTER, STATE> mNwa;

    public CommonExternalFormatWriter(PrintWriter printWriter, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        super(printWriter);
        this.mAlphabetMapping = this.getAlphabetMapping(iNestedWordAutomaton.getVpAlphabet().getInternalAlphabet());
        this.mStateMapping = this.getStateMapping(iNestedWordAutomaton.getStates());
        this.mNwa = iNestedWordAutomaton;
        this.finish();
    }

    private Map<LETTER, String> getAlphabetMapping(Collection<LETTER> collection) {
        int n = 0;
        LinkedHashMap<LETTER, String> linkedHashMap = new LinkedHashMap<LETTER, String>();
        ArrayList<LETTER> arrayList = new ArrayList<LETTER>(collection);
        Collections.sort(arrayList, Comparator.comparing(Object::toString));
        for (LETTER LETTER : arrayList) {
            linkedHashMap.put(LETTER, Integer.toString(n));
            ++n;
        }
        return linkedHashMap;
    }

    private Map<STATE, String> getStateMapping(Collection<STATE> collection) {
        int n = 0;
        HashMap<STATE, String> hashMap = new HashMap<STATE, String>();
        for (STATE STATE : collection) {
            hashMap.put(STATE, Integer.toString(n));
            ++n;
        }
        return hashMap;
    }

    public static <LETTER> Map<LETTER, String> constructAlphabetMapping(Collection<LETTER> collection, char c) {
        int n = 0;
        LinkedHashMap<LETTER, CallSite> linkedHashMap = new LinkedHashMap<LETTER, CallSite>();
        ArrayList<LETTER> arrayList = new ArrayList<LETTER>(collection);
        Collections.sort(arrayList, Comparator.comparing(Object::toString));
        for (LETTER LETTER : arrayList) {
            linkedHashMap.put(LETTER, (CallSite)((Object)(c + Integer.toString(n))));
            ++n;
        }
        return linkedHashMap;
    }

    @FunctionalInterface
    protected static interface IConverter<E> {
        public String convert(E var1);
    }

    protected static class MapBasedConverter<E, V>
    implements IConverter<E> {
        private final Map<E, V> mMap;

        public MapBasedConverter(Map<E, V> map) {
            this.mMap = map;
        }

        @Override
        public String convert(E e) {
            V v = this.mMap.get(e);
            if (v == null) {
                throw new IllegalArgumentException("unknown element: " + String.valueOf(e));
            }
            return String.valueOf(v);
        }
    }

    protected static class ToStringConverter<E>
    implements IConverter<E> {
        protected ToStringConverter() {
        }

        @Override
        public String convert(E e) {
            return e.toString();
        }
    }
}

