/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;

public class ListSet<E>
extends AbstractSet<E> {
    private final HashSet<ListSetElem<E>> mElems = new HashSet();
    private final ListSetElem<E> mRoot = new ListSetElem<Object>(null);

    public void beginScope() {
        ListSetElem<Object> listSetElem = new ListSetElem<Object>(null);
        this.addToList(listSetElem);
    }

    public void endScope() {
        ListSetElem listSetElem = this.mRoot.mPrev;
        while (listSetElem.mElem != null) {
            this.mElems.remove(listSetElem);
            listSetElem = this.remove(listSetElem);
        }
    }

    private void addToList(ListSetElem<E> listSetElem) {
        this.mRoot.mPrev.mNext = listSetElem;
        listSetElem.mNext = this.mRoot;
        listSetElem.mPrev = this.mRoot.mPrev;
        this.mRoot.mPrev = listSetElem;
    }

    @Override
    public boolean add(E e) {
        ListSetElem<E> listSetElem = new ListSetElem<E>(e);
        if (this.mElems.add(listSetElem)) {
            this.addToList(listSetElem);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Iterator<ListSetElem<E>> mIt;
            ListSetElem<E> mData;
            {
                this.mIt = ListSet.this.mElems.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mIt.hasNext();
            }

            @Override
            public E next() {
                this.mData = this.mIt.next();
                return this.mData.mElem;
            }

            @Override
            public void remove() {
                ListSet.this.remove(this.mData);
                this.mIt.remove();
            }
        };
    }

    private ListSetElem<E> remove(ListSetElem<E> listSetElem) {
        ListSetElem listSetElem2 = listSetElem.mPrev;
        listSetElem2.mNext = listSetElem.mNext;
        listSetElem.mNext.mPrev = listSetElem2;
        listSetElem.mPrev = listSetElem;
        listSetElem.mNext = listSetElem.mPrev;
        return listSetElem2;
    }

    @Override
    public int size() {
        return this.mElems.size();
    }

    public ListSetIterator listIterator() {
        return new ListSetIterator(this.mRoot);
    }

    public ListSetIterator successors(ListSetIterator listSetIterator) {
        return new ListSetIterator(listSetIterator.mCur);
    }

    public Iterator<E> scopeIterator() {
        return new ScopeIterator();
    }

    public Iterable<E> scope() {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return ListSet.this.scopeIterator();
            }
        };
    }

    private static class ListSetElem<E> {
        E mElem;
        ListSetElem<E> mNext;
        ListSetElem<E> mPrev;

        public ListSetElem(E e) {
            this.mElem = e;
            this.mNext = this.mPrev = this;
        }

        public int hashCode() {
            return this.mElem == null ? 0 : this.mElem.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof ListSetElem) {
                object = ((ListSetElem)object).mElem;
            }
            return this.mElem == null ? object == null : this.mElem.equals(object);
        }
    }

    public class ListSetIterator
    implements Iterator<E> {
        ListSetElem<E> mCur;

        ListSetIterator(ListSetElem<E> listSetElem) {
            this.mCur = listSetElem;
        }

        @Override
        public boolean hasNext() {
            ListSetElem listSetElem = this.mCur.mNext;
            while (listSetElem != ListSet.this.mRoot && listSetElem.mElem == null) {
                listSetElem = listSetElem.mNext;
            }
            return listSetElem != ListSet.this.mRoot;
        }

        @Override
        public E next() {
            ListSetElem listSetElem = this.mCur.mNext;
            while (listSetElem != ListSet.this.mRoot && listSetElem.mElem == null) {
                listSetElem = listSetElem.mNext;
            }
            this.mCur = listSetElem;
            return this.mCur.mElem;
        }

        @Override
        public void remove() {
            this.mCur = ListSet.this.remove(this.mCur);
            ListSet.this.mElems.remove(this.mCur);
        }
    }

    private class ScopeIterator
    implements Iterator<E> {
        ListSetElem<E> mCur;

        private ScopeIterator() {
            this.mCur = ListSet.this.mRoot;
        }

        @Override
        public boolean hasNext() {
            return this.mCur.mPrev.mElem != null;
        }

        @Override
        public E next() {
            this.mCur = this.mCur.mPrev;
            return this.mCur.mElem;
        }

        @Override
        public void remove() {
            this.mCur = ListSet.this.remove(this.mCur).mNext;
            ListSet.this.mElems.remove(this.mCur);
        }
    }
}

