/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IBoogieSymbolTableVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.AffineExpression;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.IfExpressionTree;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.util.typeutils.TypeUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ExpressionTransformer {
    private final Map<Expression, AffineExpression> mCacheAffineExpr;
    private final Map<Expression, Expression> mCacheLogicNeg;
    private final Map<Expression, IfExpressionTree> mCacheRemoveIfExpr = new HashMap<Expression, IfExpressionTree>();
    private final IBoogieSymbolTableVariableProvider mBpl2SmtSymbolTable;

    ExpressionTransformer(IBoogieSymbolTableVariableProvider iBoogieSymbolTableVariableProvider) {
        this.mCacheLogicNeg = new HashMap<Expression, Expression>();
        this.mCacheAffineExpr = new HashMap<Expression, AffineExpression>();
        this.mBpl2SmtSymbolTable = iBoogieSymbolTableVariableProvider;
    }

    public AffineExpression affineExprCached(Expression expression) {
        if (this.mCacheAffineExpr.containsKey(expression)) {
            return this.mCacheAffineExpr.get(expression);
        }
        AffineExpression affineExpression = this.toAffineExpr(expression);
        this.mCacheAffineExpr.put(expression, affineExpression);
        return affineExpression;
    }

    public Expression logicNegCached(Expression expression) {
        Expression expression2 = this.mCacheLogicNeg.get(expression);
        if (expression2 == null) {
            expression2 = ExpressionTransformer.logicNeg(expression);
            this.mCacheLogicNeg.put(expression, expression2);
        }
        return expression2;
    }

    public IfExpressionTree removeIfExprsCached(Expression expression) {
        IfExpressionTree ifExpressionTree = this.mCacheRemoveIfExpr.get(expression);
        if (ifExpressionTree == null) {
            ifExpressionTree = IfExpressionTree.buildTree(expression, this);
            this.mCacheRemoveIfExpr.put(expression, ifExpressionTree);
        }
        return ifExpressionTree;
    }

    private AffineExpression toAffineExpr(Expression expression) {
        assert (TypeUtils.isNumeric(expression.getType())) : "Cannot transform non-numeric expression to affine expression: " + String.valueOf(expression);
        if (expression instanceof IntegerLiteral) {
            String string = ((IntegerLiteral)expression).getValue();
            return new AffineExpression(AbsIntUtil.sanitizeBigDecimalValue(string));
        }
        if (expression instanceof RealLiteral) {
            String string = ((RealLiteral)expression).getValue();
            return new AffineExpression(AbsIntUtil.sanitizeBigDecimalValue(string));
        }
        if (expression instanceof IdentifierExpression) {
            IdentifierExpression identifierExpression = (IdentifierExpression)expression;
            IProgramVar iProgramVar = this.mBpl2SmtSymbolTable.getBoogieVar(identifierExpression.getIdentifier(), identifierExpression.getDeclarationInformation(), false);
            if (iProgramVar == null) {
                iProgramVar = this.mBpl2SmtSymbolTable.getBoogieConst(identifierExpression.getIdentifier());
            }
            assert (iProgramVar != null);
            Map<IProgramVar, BigDecimal> map = Collections.singletonMap(iProgramVar, BigDecimal.ONE);
            return new AffineExpression(map, BigDecimal.ZERO);
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            if (unaryExpression.getOperator() == UnaryExpression.Operator.OLD) {
                if (!(unaryExpression.getExpr() instanceof IdentifierExpression)) {
                    throw new UnsupportedOperationException("No support for old expressions yet");
                }
                IdentifierExpression identifierExpression = (IdentifierExpression)unaryExpression.getExpr();
                IProgramVar iProgramVar = this.mBpl2SmtSymbolTable.getBoogieVar(identifierExpression.getIdentifier(), identifierExpression.getDeclarationInformation(), true);
                if (iProgramVar == null) {
                    iProgramVar = this.mBpl2SmtSymbolTable.getBoogieConst(identifierExpression.getIdentifier());
                }
                assert (iProgramVar != null);
                Map<IProgramVar, BigDecimal> map = Collections.singletonMap(iProgramVar, BigDecimal.ONE);
                return new AffineExpression(map, BigDecimal.ZERO);
            }
            return this.unaryExprToAffineExpr(unaryExpression);
        }
        if (expression instanceof BinaryExpression) {
            return this.binaryExprToAffineExpr((BinaryExpression)expression);
        }
        return null;
    }

    private AffineExpression unaryExprToAffineExpr(UnaryExpression unaryExpression) {
        switch (unaryExpression.getOperator()) {
            case ARITHNEGATIVE: {
                AffineExpression affineExpression = this.affineExprCached(unaryExpression.getExpr());
                return affineExpression == null ? null : affineExpression.negate();
            }
            case OLD: {
                return this.affineExprCached((Expression)unaryExpression);
            }
        }
        return null;
    }

    private AffineExpression binaryExprToAffineExpr(BinaryExpression binaryExpression) {
        AffineExpression affineExpression = this.affineExprCached(binaryExpression.getLeft());
        if (affineExpression == null) {
            return null;
        }
        AffineExpression affineExpression2 = this.affineExprCached(binaryExpression.getRight());
        if (affineExpression2 == null) {
            return null;
        }
        boolean bl = TypeUtils.isNumericInt(binaryExpression.getType());
        switch (binaryExpression.getOperator()) {
            case ARITHDIV: {
                return affineExpression.divide(affineExpression2, bl);
            }
            case ARITHMINUS: {
                return affineExpression.add(affineExpression2.negate());
            }
            case ARITHMOD: {
                return affineExpression.modulo(affineExpression2);
            }
            case ARITHMUL: {
                return affineExpression.multiply(affineExpression2);
            }
            case ARITHPLUS: {
                return affineExpression.add(affineExpression2);
            }
        }
        return null;
    }

    private static Expression logicNeg(Expression expression) {
        assert (TypeUtils.isBoolean(expression.getType())) : "Logical negation of non-boolean expression: " + String.valueOf(expression);
        if (expression instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            if (unaryExpression.getOperator() == UnaryExpression.Operator.LOGICNEG) {
                return unaryExpression.getExpr();
            }
        } else if (expression instanceof BooleanLiteral) {
            BooleanLiteral booleanLiteral = (BooleanLiteral)expression;
            return new BooleanLiteral(booleanLiteral.getLocation(), booleanLiteral.getType(), !booleanLiteral.getValue());
        }
        return new UnaryExpression(expression.getLocation(), expression.getType(), UnaryExpression.Operator.LOGICNEG, expression);
    }
}

