/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.pea2boogie;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieIdExtractor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AllSpecificationsHoldResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.CounterExampleResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.IResultWithCheck;
import de.uni_freiburg.informatik.ultimate.core.lib.results.InvariantResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.PositiveResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.BasicInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.TransferrerWithVariableCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubtermPropertyChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPushTermWalker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheck;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.pea2boogie.Activator;
import de.uni_freiburg.informatik.ultimate.pea2boogie.IReqSymbolTable;
import de.uni_freiburg.informatik.ultimate.pea2boogie.results.ReqCheck;
import de.uni_freiburg.informatik.ultimate.pea2boogie.results.ReqCheckFailResult;
import de.uni_freiburg.informatik.ultimate.pea2boogie.results.ReqCheckRedundancyResult;
import de.uni_freiburg.informatik.ultimate.pea2boogie.results.ReqCheckRtInconsistentResult;
import de.uni_freiburg.informatik.ultimate.pea2boogie.results.ReqCheckSuccessResult;
import de.uni_freiburg.informatik.ultimate.pea2boogie.translator.ReqSymboltableBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlockFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.ParallelComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.SequentialComposition;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class VerificationResultTransformer {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final IReqSymbolTable mReqSymbolTable;
    private final IPreferenceProvider mPrefs;

    public VerificationResultTransformer(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, IReqSymbolTable iReqSymbolTable) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        this.mReqSymbolTable = iReqSymbolTable;
        this.mPrefs = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
    }

    public IResult convertTraceAbstractionResult(IResult iResult) {
        Optional<Check> optional;
        boolean bl;
        ReqCheck reqCheck;
        AbstractResultAtElement abstractResultAtElement;
        InvariantResult invariantResult = null;
        if (iResult instanceof CounterExampleResult) {
            abstractResultAtElement = (AbstractResultAtElement)iResult;
            reqCheck = (ReqCheck)((IResultWithCheck)iResult).getCheckedSpecification();
            bl = false;
        } else if (iResult instanceof PositiveResult) {
            abstractResultAtElement = (AbstractResultAtElement)iResult;
            reqCheck = (ReqCheck)((IResultWithCheck)iResult).getCheckedSpecification();
            bl = true;
        } else if (iResult instanceof InvariantResult) {
            invariantResult = (InvariantResult)iResult;
            abstractResultAtElement = (AbstractResultAtElement)iResult;
            optional = invariantResult.getChecks().stream().filter(ReqCheck.class::isInstance).findFirst();
            if (optional.isEmpty()) {
                return iResult;
            }
            reqCheck = (ReqCheck)((Object)optional.get());
            if (!reqCheck.getSpec().contains(Spec.REDUNDANCY)) {
                return iResult;
            }
            bl = true;
        } else {
            if (iResult instanceof AllSpecificationsHoldResult) {
                return null;
            }
            return iResult;
        }
        optional = reqCheck.getSpec();
        if (optional == null || optional.isEmpty()) {
            throw new AssertionError((Object)("Result without specification: " + abstractResultAtElement.getShortDescription()));
        }
        if (optional.size() != 1) {
            throw new UnsupportedOperationException("Multi-checks of " + String.valueOf(optional) + " are not yet supported");
        }
        Spec spec = (Spec)optional.iterator().next();
        VerificationResultTransformer.dieIfUnsupported(spec);
        if (spec == Spec.CONSISTENCY || spec == Spec.VACUOUS || spec == Spec.REDUNDANCY) {
            bl = !bl;
        }
        IElement iElement = abstractResultAtElement.getElement();
        String string = abstractResultAtElement.getPlugin();
        if (bl) {
            return new ReqCheckSuccessResult<IElement>(iElement, string);
        }
        if (spec == Spec.RTINCONSISTENT) {
            if (!this.mPrefs.getBoolean("Generate failure path for rt-inconsistency")) {
                return new ReqCheckRtInconsistentResult<IElement>(iElement, string);
            }
            IcfgProgramExecution icfgProgramExecution = (IcfgProgramExecution)((CounterExampleResult)abstractResultAtElement).getProgramExecution();
            IProgramExecution<IAction, Term> iProgramExecution = this.reduceRtInconsistencyProgramExecution(icfgProgramExecution, reqCheck);
            if (iProgramExecution == null) {
                return new ReqCheckRtInconsistentResult<IElement>(iElement, string);
            }
            this.mLogger.info("Old program execution had length %s, new has length %s", new Object[]{icfgProgramExecution.getLength(), iProgramExecution.getLength()});
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)"Result before Pea2Boogie result transformation");
                this.mLogger.debug((Object)abstractResultAtElement);
                this.mLogger.debug((Object)"PE after Pea2Boogie result transformation");
                this.mLogger.debug(iProgramExecution);
            }
            List<Map.Entry<Rational, Map<Term, Term>>> list = this.generateTimeSequenceMap(iProgramExecution.getProgramStates());
            String string2 = this.formatTimeSequenceMap(list);
            return new ReqCheckRtInconsistentResult<IElement>(iElement, string, string2);
        }
        if (spec == Spec.REDUNDANCY && invariantResult != null) {
            reqCheck.annotate(iElement);
            Expression expression = (Expression)invariantResult.getInvariant();
            Set<String> set = reqCheck.getReqIds();
            if (set.size() != 1) {
                throw new AssertionError((Object)("Creating redundancy sets for Check containing multiple requirements" + String.valueOf(set) + "is not supported"));
            }
            String string3 = set.iterator().next();
            Set<String> set2 = VerificationResultTransformer.extractRedundancySet(expression);
            return new ReqCheckRedundancyResult<IElement>(iElement, string, string3, set2);
        }
        return new ReqCheckFailResult<IElement>(iElement, string);
    }

    private static Set<String> extractRedundancySet(Expression expression) {
        BoogieIdExtractor boogieIdExtractor = new BoogieIdExtractor();
        boogieIdExtractor.processExpression(expression);
        return boogieIdExtractor.getIds().stream().filter(string -> string.endsWith("_total_pc") || string.endsWith("_total")).map(string -> string.split("_ct")[0]).collect(Collectors.toSet());
    }

    private String formatTimeSequenceMap(List<Map.Entry<Rational, Map<Term, Term>>> list) {
        int n = list.stream().map(entry -> ((Rational)entry.getKey()).toString().length()).max(Integer::compare).get();
        int n2 = n * 2 + 5 < 12 ? 12 : n * 2 + 5;
        StringBuilder stringBuilder = new StringBuilder();
        Rational rational = Rational.ZERO;
        Rational rational2 = Rational.ZERO;
        String string = "";
        for (Map.Entry<Rational, Map<Term, Term>> entry2 : list) {
            String string2 = entry2.getValue().entrySet().stream().map(this::formatVarValue).collect(Collectors.joining(" "));
            if (string.equals(string2)) continue;
            String string3 = (rational2 = rational2.add(entry2.getKey())) == Rational.ZERO ? "INITIAL" : String.format("[%s;%s]", SmtUtils.toString((Rational)rational), SmtUtils.toString((Rational)rational2));
            stringBuilder.append(string3);
            VerificationResultTransformer.appendRepeatedly(stringBuilder, " ", n2 - string3.length());
            stringBuilder.append(string2);
            stringBuilder.append(CoreUtil.getPlatformLineSeparator());
            string = string2;
            rational = rational2;
        }
        return stringBuilder.toString();
    }

    private String formatVarValue(Map.Entry<Term, Term> entry) {
        return String.format("%s=%s", entry.getKey(), entry.getValue() == null ? "*" : entry.getValue());
    }

    private List<Map.Entry<Rational, Map<Term, Term>>> generateTimeSequenceMap(List<IProgramExecution.ProgramState<Term>> list) {
        List list2 = list.stream().filter(Objects::nonNull).collect(Collectors.toList());
        LinkedHashMap<String, Term> linkedHashMap = new LinkedHashMap<String, Term>(list2.stream().flatMap(programState -> programState.getVariables().stream()).distinct().collect(Collectors.toMap(Term::toString, term -> term)));
        Term term2 = (Term)linkedHashMap.get(this.mReqSymbolTable.getDeltaVarName());
        linkedHashMap.remove(this.mReqSymbolTable.getDeltaVarName());
        this.mReqSymbolTable.getClockVars().stream().forEach(linkedHashMap::remove);
        this.mReqSymbolTable.getPcVars().stream().forEach(linkedHashMap::remove);
        ArrayList<Map.Entry<Rational, Map<Term, Term>>> arrayList = new ArrayList<Map.Entry<Rational, Map<Term, Term>>>();
        Term term3 = Collections.emptyMap();
        int n = 0;
        for (IProgramExecution.ProgramState programState2 : list2) {
            Rational rational;
            Term term4;
            if (programState2.getVariables().contains(term2)) {
                term4 = this.firstOrWarn(programState2.getValues((Object)term2), () -> {
                    throw new AssertionError((Object)"Program state broken: Var in vars but no value");
                });
                rational = (Rational)((ConstantTerm)term4).getValue();
            } else {
                rational = Rational.ZERO;
            }
            term4 = new LinkedHashMap();
            arrayList.add((Map.Entry<Rational, Map<Term, Term>>)new Pair((Object)rational, (Object)term4));
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                Map map = Collections.unmodifiableMap(term3);
                Term term5 = this.firstOrWarn(programState2.getValues((Object)((Term)entry.getValue())), () -> (Term)map.get(entry.getValue()));
                term4.put((Term)entry.getValue(), term5);
            }
            term3 = term4;
            if (++n >= list2.size()) break;
        }
        return arrayList;
    }

    private <T> T firstOrWarn(Collection<T> collection, Supplier<T> supplier) {
        if (collection == null || collection.isEmpty()) {
            return supplier.get();
        }
        if (collection.size() > 1) {
            this.mLogger.warn((Object)"More than one value");
        }
        return collection.iterator().next();
    }

    private static StringBuilder appendRepeatedly(StringBuilder stringBuilder, String string, int n) {
        if (stringBuilder == null) {
            return VerificationResultTransformer.appendRepeatedly(new StringBuilder(n * string.length()), string, n);
        }
        if (n <= 0) {
            return stringBuilder;
        }
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append(string);
            ++n2;
        }
        return stringBuilder;
    }

    private IProgramExecution<IAction, Term> reduceRtInconsistencyProgramExecution(IcfgProgramExecution<?> icfgProgramExecution, ReqCheck reqCheck) {
        ArrayList arrayList = new ArrayList(icfgProgramExecution.getLength());
        icfgProgramExecution.stream().map(atomicTraceElement -> (CodeBlock)atomicTraceElement.getTraceElement()).forEach(arrayList::add);
        IcfgLocation icfgLocation = (IcfgLocation)((CodeBlock)arrayList.get(arrayList.size() - 1)).getTarget();
        this.mLogger.info("Analyzing reasons for rt-inconsistency for %s", new Object[]{icfgLocation});
        CodeBlockFactory codeBlockFactory = CodeBlockFactory.getFactory((IToolchainStorage)((IToolchainStorage)this.mServices));
        CfgSmtToolkit cfgSmtToolkit = codeBlockFactory.getToolkit();
        SolverBuilder.SolverSettings solverSettings = SolverBuilder.constructSolverSettings().setUseExternalSolver(SolverBuilder.ExternalSolver.Z3).setSolverMode(SolverBuilder.SolverMode.External_ModelsAndUnsatCoreMode);
        ManagedScript managedScript = cfgSmtToolkit.createFreshManagedScript(this.mServices, solverSettings, "RtInconsistencyPostProcessor");
        Script script = managedScript.getScript();
        BasicPredicateFactory basicPredicateFactory = new BasicPredicateFactory(this.mServices, managedScript, cfgSmtToolkit.getSymbolTable());
        BasicPredicate basicPredicate = basicPredicateFactory.newPredicate(script.term("true", new Term[0]));
        BasicPredicate basicPredicate2 = basicPredicateFactory.newPredicate(script.term("false", new Term[0]));
        ManagedScript managedScript2 = cfgSmtToolkit.getManagedScript();
        try {
            IcfgProgramExecution icfgProgramExecution2;
            TraceCheck traceCheck;
            if (this.hasInvalidBranchEncoders(icfgProgramExecution)) {
                this.mLogger.info((Object)"Computing branch encoders");
                traceCheck = TraceCheck.createTraceCheck((IUltimateServiceProvider)this.mServices, (CfgSmtToolkit)cfgSmtToolkit, (ManagedScript)managedScript, (IPredicate)basicPredicate, (IPredicate)basicPredicate2, arrayList);
                if (!traceCheck.providesRcfgProgramExecution()) {
                    this.mLogger.warn((Object)("Could not extract reduced program execution from trace: TraceCheck reported " + String.valueOf(traceCheck.isCorrect())));
                    return null;
                }
                icfgProgramExecution2 = traceCheck.getRcfgProgramExecution();
            } else {
                icfgProgramExecution2 = icfgProgramExecution;
            }
            this.mLogger.info((Object)"Sequentializing");
            traceCheck = this.sequentialize(icfgProgramExecution2, managedScript, managedScript2);
            List<IAction> list = this.removeUnrelatedVariables((List<IAction>)traceCheck, reqCheck, managedScript);
            this.mLogger.info((Object)"Computing reduced program execution");
            TraceCheck traceCheck2 = TraceCheck.createTraceCheck((IUltimateServiceProvider)this.mServices, (CfgSmtToolkit)cfgSmtToolkit, (ManagedScript)managedScript, (IPredicate)basicPredicate, (IPredicate)basicPredicate2, list);
            if (traceCheck2.isCorrect() == Script.LBool.SAT) {
                IcfgProgramExecution icfgProgramExecution3 = traceCheck2.getRcfgProgramExecution();
                return icfgProgramExecution3;
            }
            try {
                this.mLogger.fatal((Object)"Reduced program execution is not 'sat'");
                TraceCheck traceCheck3 = TraceCheck.createTraceCheck((IUltimateServiceProvider)this.mServices, (CfgSmtToolkit)cfgSmtToolkit, (ManagedScript)managedScript, (IPredicate)basicPredicate, (IPredicate)basicPredicate2, arrayList);
                TraceCheck traceCheck4 = TraceCheck.createTraceCheck((IUltimateServiceProvider)this.mServices, (CfgSmtToolkit)cfgSmtToolkit, (ManagedScript)managedScript, (IPredicate)basicPredicate, (IPredicate)basicPredicate2, (List)traceCheck);
                String string = String.format("Cleaned trace is not '%s', but '%s', sequentialized is '%s', original is '%s'.", Script.LBool.SAT, traceCheck2.isCorrect(), traceCheck4.isCorrect(), traceCheck3.isCorrect());
                this.mLogger.fatal((Object)string);
                throw new AssertionError((Object)string);
            }
            catch (ToolchainCanceledException toolchainCanceledException) {
                this.mLogger.warn((Object)"Timeout during analysis of rt-inconsistency reasons");
                return null;
            }
        }
        finally {
            managedScript.getScript().exit();
        }
    }

    private boolean hasInvalidBranchEncoders(IcfgProgramExecution<?> icfgProgramExecution) {
        if (icfgProgramExecution.getBranchEncoders() == null || icfgProgramExecution.getBranchEncoders().length == 0) {
            return true;
        }
        return Arrays.stream(icfgProgramExecution.getBranchEncoders()).filter(Objects::nonNull).flatMap(map -> map.entrySet().stream()).filter(Map.Entry::getValue).allMatch(Map.Entry::getValue);
    }

    private List<IAction> removeUnrelatedVariables(List<IAction> list, ReqCheck reqCheck, ManagedScript managedScript) {
        String string = ReqSymboltableBuilder.getPcName(reqCheck.getPeaNames().iterator().next());
        HashSet<String> hashSet = new HashSet<String>((Collection<String>)this.mReqSymbolTable.getVariableEquivalenceClasses().getContainingSet((Object)string));
        hashSet.add(this.mReqSymbolTable.getDeltaVarName());
        assert (hashSet.containsAll(reqCheck.getPeaNames().stream().map(ReqSymboltableBuilder::getPcName).collect(Collectors.toSet())));
        ArrayList<IAction> arrayList = new ArrayList<IAction>();
        for (IAction iAction : list) {
            Set set;
            Term term;
            Map.Entry entry2;
            UnmodifiableTransFormula unmodifiableTransFormula = iAction.getTransformula();
            Term term2 = unmodifiableTransFormula.getFormula();
            LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>();
            LinkedHashMap<IProgramVar, TermVariable> linkedHashMap = new LinkedHashMap<IProgramVar, TermVariable>();
            LinkedHashMap<IProgramVar, TermVariable> linkedHashMap2 = new LinkedHashMap<IProgramVar, TermVariable>();
            for (Map.Entry entry2 : unmodifiableTransFormula.getInVars().entrySet()) {
                if (!hashSet.contains(((IProgramVar)entry2.getKey()).toString())) {
                    linkedHashSet.add((TermVariable)entry2.getValue());
                    continue;
                }
                linkedHashMap.put((IProgramVar)entry2.getKey(), (TermVariable)entry2.getValue());
            }
            for (Map.Entry entry2 : unmodifiableTransFormula.getOutVars().entrySet()) {
                if (!hashSet.contains(((IProgramVar)entry2.getKey()).toString())) {
                    linkedHashSet.add((TermVariable)entry2.getValue());
                    continue;
                }
                linkedHashMap2.put((IProgramVar)entry2.getKey(), (TermVariable)entry2.getValue());
            }
            if (linkedHashSet.isEmpty()) {
                term = term2;
                entry2 = unmodifiableTransFormula.getNonTheoryConsts();
            } else {
                this.mLogger.info("Removing %s variables", new Object[]{linkedHashSet.size()});
                set = SmtUtils.quantifier((Script)managedScript.getScript(), (int)0, linkedHashSet, (Term)term2);
                term = this.tryToEliminate(managedScript, (Term)set);
                Set set2 = SmtUtils.extractConstants((Term)term, (boolean)false);
                entry2 = unmodifiableTransFormula.getNonTheoryConsts().stream().filter(iProgramConst -> set2.contains(iProgramConst.getDefaultConstant())).collect(Collectors.toSet());
            }
            set = unmodifiableTransFormula.getBranchEncoders();
            boolean bl = set.isEmpty();
            boolean bl2 = unmodifiableTransFormula.getAuxVars().isEmpty();
            boolean bl3 = entry2.isEmpty();
            TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(null, null, bl3, (Set)((Object)entry2), bl, (Collection)set, bl2);
            transFormulaBuilder.addInVars(linkedHashMap);
            transFormulaBuilder.addOutVars(linkedHashMap2);
            transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
            transFormulaBuilder.setFormula(term);
            UnmodifiableTransFormula unmodifiableTransFormula2 = transFormulaBuilder.finishConstruction(managedScript);
            arrayList.add((IAction)new BasicInternalAction(iAction.getPrecedingProcedure(), iAction.getSucceedingProcedure(), unmodifiableTransFormula2));
        }
        return arrayList;
    }

    private List<IAction> sequentialize(IcfgProgramExecution<?> icfgProgramExecution, ManagedScript managedScript, ManagedScript managedScript2) {
        Map[] mapArray = icfgProgramExecution.getBranchEncoders();
        ArrayList<IAction> arrayList = new ArrayList<IAction>();
        TransferrerWithVariableCache transferrerWithVariableCache = new TransferrerWithVariableCache(managedScript2.getScript(), managedScript);
        int n = 0;
        while (n < icfgProgramExecution.getLength()) {
            AtomicTraceElement atomicTraceElement = icfgProgramExecution.getTraceElement(n);
            if (!"true".equals(((IAction)atomicTraceElement.getTraceElement()).getTransformula().getClosedFormula().toString())) {
                Map map = mapArray == null || n >= mapArray.length ? null : mapArray[n];
                List<IAction> list = this.extractSequential(Collections.singletonList((CodeBlock)atomicTraceElement.getTraceElement()), map);
                List list2 = list.stream().map(iAction -> transferrerWithVariableCache.transferTransFormula(iAction.getTransformula())).collect(Collectors.toList());
                UnmodifiableTransFormula unmodifiableTransFormula = list2.size() == 1 ? (UnmodifiableTransFormula)list2.get(0) : TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)managedScript, (boolean)false, (boolean)false, (boolean)false, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, list2);
                arrayList.add((IAction)new BasicInternalAction("myProcedure", "myProcedure", unmodifiableTransFormula));
            }
            ++n;
        }
        return arrayList;
    }

    private List<IAction> extractSequential(List<CodeBlock> list, Map<TermVariable, Boolean> map) {
        ArrayList<IAction> arrayList = new ArrayList<IAction>();
        for (CodeBlock codeBlock : list) {
            if (codeBlock instanceof SequentialComposition) {
                arrayList.addAll(this.extractSequential(((SequentialComposition)codeBlock).getCodeBlocks(), map));
                continue;
            }
            if (codeBlock instanceof ParallelComposition) {
                if (map == null) {
                    throw new AssertionError((Object)"Not enough branch encoders");
                }
                ParallelComposition parallelComposition = (ParallelComposition)codeBlock;
                Map map2 = parallelComposition.getBranchIndicator2CodeBlock();
                CodeBlock codeBlock2 = map2.entrySet().stream().filter(entry -> (Boolean)map.get(entry.getKey())).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new AssertionError((Object)"No branch was taken!"));
                arrayList.addAll(this.extractSequential(Collections.singletonList(codeBlock2), map));
                continue;
            }
            arrayList.add((IAction)codeBlock);
        }
        return arrayList;
    }

    private Term tryToEliminate(ManagedScript managedScript, Term term) {
        Term term2 = QuantifierPushTermWalker.eliminate((IUltimateServiceProvider)this.mServices, (ManagedScript)managedScript, (boolean)false, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.LIGHT, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, (Term)term);
        if (new SubtermPropertyChecker(QuantifiedFormula.class::isInstance).isSatisfiedBySomeSubterm(term2)) {
            return QuantifierPushTermWalker.eliminate((IUltimateServiceProvider)this.mServices, (ManagedScript)managedScript, (boolean)true, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.ALL, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, (Term)term2);
        }
        return term2;
    }

    private static void dieIfUnsupported(Spec spec) {
        switch (spec) {
            case RTINCONSISTENT: 
            case VACUOUS: 
            case CONSISTENCY: 
            case COMPLEMENT: 
            case REDUNDANCY: {
                return;
            }
        }
        throw new UnsupportedOperationException("Unknown spec type " + String.valueOf(spec));
    }
}

