/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.mcr;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.QualifiedTracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class McrTraceCheckResult<L extends IIcfgTransition<?>> {
    private final List<L> mTrace;
    private final Script.LBool mIsCorrect;
    private final Collection<QualifiedTracePredicates> mQualifiedTracePredicates;
    private final IStatisticsDataProvider mStatistics;
    private final IProgramExecution<L, Term> mExecution;
    private NestedWordAutomaton<L, IPredicate> mAutomaton;

    private McrTraceCheckResult(List<L> list, Script.LBool lBool, Collection<QualifiedTracePredicates> collection, IStatisticsDataProvider iStatisticsDataProvider, IProgramExecution<L, Term> iProgramExecution) {
        this.mTrace = list;
        this.mIsCorrect = lBool;
        this.mQualifiedTracePredicates = collection;
        this.mStatistics = iStatisticsDataProvider;
        this.mExecution = iProgramExecution;
    }

    public static <L extends IIcfgTransition<?>> McrTraceCheckResult<L> constructFeasibleResult(List<L> list, Script.LBool lBool, IStatisticsDataProvider iStatisticsDataProvider, IProgramExecution<L, Term> iProgramExecution) {
        return new McrTraceCheckResult<L>(list, lBool, Collections.emptyList(), iStatisticsDataProvider, iProgramExecution);
    }

    public static <L extends IIcfgTransition<?>> McrTraceCheckResult<L> constructInfeasibleResult(List<L> list, Collection<QualifiedTracePredicates> collection, IStatisticsDataProvider iStatisticsDataProvider) {
        return new McrTraceCheckResult<L>(list, Script.LBool.UNSAT, collection, iStatisticsDataProvider, null);
    }

    public List<L> getTrace() {
        return this.mTrace;
    }

    public Script.LBool isCorrect() {
        return this.mIsCorrect;
    }

    public void setAutomaton(NestedWordAutomaton<L, IPredicate> nestedWordAutomaton) {
        this.mAutomaton = nestedWordAutomaton;
    }

    public NestedWordAutomaton<L, IPredicate> getAutomaton() {
        return this.mAutomaton;
    }

    public IPredicate[] getInterpolants() {
        if (this.mQualifiedTracePredicates.isEmpty()) {
            return null;
        }
        List list = this.mQualifiedTracePredicates.stream().findAny().get().getPredicates();
        return list.toArray(new IPredicate[list.size()]);
    }

    public Collection<QualifiedTracePredicates> getQualifiedTracePredicates() {
        return this.mQualifiedTracePredicates;
    }

    public IStatisticsDataProvider getStatistics() {
        return this.mStatistics;
    }

    public IProgramExecution<L, Term> getExecution() {
        return this.mExecution;
    }

    public boolean providesExecution() {
        return this.mExecution != null;
    }
}

