/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.MLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateWithHistory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.SPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsFuns;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class PredicateFactory
extends BasicPredicateFactory {
    public PredicateFactory(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, IIcfgSymbolTable iIcfgSymbolTable) {
        super(iUltimateServiceProvider, managedScript, iIcfgSymbolTable);
    }

    public PredicateWithHistory newPredicateWithHistory(IcfgLocation icfgLocation, Term term, Map<Integer, Term> map) {
        TermVarsFuns termVarsFuns = this.constructTermVarsProc(term);
        PredicateWithHistory predicateWithHistory = new PredicateWithHistory(icfgLocation, this.constructFreshSerialNumber(), termVarsFuns.getFormula(), termVarsFuns.getVars(), termVarsFuns.getFuns(), termVarsFuns.getClosedFormula(), map);
        return predicateWithHistory;
    }

    public SPredicate newSPredicate(IcfgLocation icfgLocation, Term term) {
        TermVarsFuns termVarsFuns = this.constructTermVarsProc(term);
        return this.newSPredicate(icfgLocation, termVarsFuns);
    }

    SPredicate newSPredicate(IcfgLocation icfgLocation, TermVarsFuns termVarsFuns) {
        SPredicate sPredicate = new SPredicate(icfgLocation, this.constructFreshSerialNumber(), termVarsFuns.getFormula(), termVarsFuns.getVars(), termVarsFuns.getFuns(), termVarsFuns.getClosedFormula());
        return sPredicate;
    }

    public ISLPredicate newEmptyStackPredicate() {
        IcfgLocation icfgLocation = new IcfgLocation(NoCallerDebugIdentifier.INSTANCE, "noCaller");
        return this.newSPredicate(icfgLocation, new TermVarsFuns(this.mEmptyStackTerm, EMPTY_VARS, Collections.emptySet(), this.mEmptyStackTerm));
    }

    public MLPredicate newMLPredicate(IcfgLocation[] icfgLocationArray, Term term) {
        TermVarsFuns termVarsFuns = this.constructTermVarsProc(term);
        MLPredicate mLPredicate = new MLPredicate(icfgLocationArray, this.constructFreshSerialNumber(), termVarsFuns.getFormula(), termVarsFuns.getVars(), termVarsFuns.getFuns(), termVarsFuns.getClosedFormula());
        return mLPredicate;
    }

    public IPredicate newMLPredicate(IcfgLocation[] icfgLocationArray, ArrayList<Term> arrayList) {
        IPredicate iPredicate = this.andT(arrayList);
        return this.newMLPredicate(icfgLocationArray, iPredicate.getFormula());
    }

    public MLPredicate newMLDontCarePredicate(IcfgLocation[] icfgLocationArray) {
        return this.newMLPredicate(icfgLocationArray, this.mDontCareTerm);
    }

    private static final class NoCallerDebugIdentifier
    extends DebugIdentifier {
        public static final NoCallerDebugIdentifier INSTANCE = new NoCallerDebugIdentifier();

        private NoCallerDebugIdentifier() {
        }

        @Override
        public String toString() {
            return "noCaller";
        }
    }
}

