/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class TermcompProofBenchmark
implements ICsvProviderProvider<Double> {
    private final IUltimateServiceProvider mServices;
    private final TreeMap<Integer, String> mModuleFinite = new TreeMap();
    private final TreeMap<Integer, String> mModuleBuchi = new TreeMap();
    private Boolean mHasRemainderModule;
    private boolean mRemainderModuleNonterminationKnown;

    public TermcompProofBenchmark(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
    }

    public void reportFiniteModule(Integer n, INwaOutgoingLetterAndTransitionProvider<?, IPredicate> iNwaOutgoingLetterAndTransitionProvider) {
        String string = AutomatonDefinitionPrinter.toString((AutomataLibraryServices)new AutomataLibraryServices(this.mServices), (String)("finiteAutomatonIteration" + String.valueOf(n)), iNwaOutgoingLetterAndTransitionProvider);
        this.mModuleFinite.put(n, string);
    }

    public void reportBuchiModule(Integer n, INwaOutgoingLetterAndTransitionProvider<?, IPredicate> iNwaOutgoingLetterAndTransitionProvider) {
        String string = AutomatonDefinitionPrinter.toString((AutomataLibraryServices)new AutomataLibraryServices(this.mServices), (String)("buchiAutomatonIteration" + String.valueOf(n)), iNwaOutgoingLetterAndTransitionProvider);
        this.mModuleBuchi.put(n, string);
    }

    public void reportRemainderModule(boolean bl) {
        assert (this.mHasRemainderModule == null) : "remainder module already reported";
        this.mHasRemainderModule = true;
        this.mRemainderModuleNonterminationKnown = bl;
    }

    public void reportNoRemainderModule() {
        assert (this.mHasRemainderModule == null) : "remainder module already reported";
        this.mHasRemainderModule = false;
    }

    public String toString() {
        if (this.mHasRemainderModule == null) {
            return "Decomposition not yet finished";
        }
        if (this.mHasRemainderModule.booleanValue()) {
            if (this.mRemainderModuleNonterminationKnown) {
                return "Program is not terminating, hence no termination proof";
            }
            return "Unable to prove termination";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Your program was decomposed into the following automata ");
        stringBuilder.append(System.lineSeparator());
        for (Map.Entry<Integer, String> entry : this.mModuleFinite.entrySet()) {
            stringBuilder.append(entry.getValue());
            stringBuilder.append(System.lineSeparator());
        }
        for (Map.Entry<Integer, String> entry : this.mModuleBuchi.entrySet()) {
            stringBuilder.append(entry.getValue());
            stringBuilder.append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }

    public ICsvProvider<Double> createCsvProvider() {
        SimpleCsvProvider simpleCsvProvider = new SimpleCsvProvider(new ArrayList());
        return simpleCsvProvider;
    }
}

