/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BitvecLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.TranslationSettings;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CEnum;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.ISOIEC9899TC3;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.preferences.CACSLPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BitvectorConstant;
import java.math.BigInteger;
import java.util.LinkedHashMap;

public class TypeSizes {
    private final boolean mUseFixedTypeSizes;
    private final int mSizeOfPointerType;
    private final CACSLPreferenceInitializer.Signedness mSignednessOfChar;
    private final LinkedHashMap<CPrimitive.CPrimitives, Integer> mCPrimitiveToTypeSizeConstant;
    private final TranslationSettings mSettings;

    public TypeSizes(IPreferenceProvider iPreferenceProvider, TranslationSettings translationSettings) {
        this.mUseFixedTypeSizes = iPreferenceProvider.getBoolean("Use the constants given below as storage sizes for the correponding types");
        this.mSettings = translationSettings;
        int n = iPreferenceProvider.getInt("sizeof _Bool");
        int n2 = iPreferenceProvider.getInt("sizeof char");
        int n3 = iPreferenceProvider.getInt("sizeof short");
        int n4 = iPreferenceProvider.getInt("sizeof int");
        int n5 = iPreferenceProvider.getInt("sizeof long");
        int n6 = iPreferenceProvider.getInt("sizeof long long");
        int n7 = iPreferenceProvider.getInt("sizeof float");
        int n8 = iPreferenceProvider.getInt("sizeof double");
        int n9 = iPreferenceProvider.getInt("sizeof long double");
        this.mSizeOfPointerType = iPreferenceProvider.getInt("sizeof POINTER");
        this.mSignednessOfChar = (CACSLPreferenceInitializer.Signedness)iPreferenceProvider.getEnum("signedness of char", CACSLPreferenceInitializer.Signedness.class);
        this.mCPrimitiveToTypeSizeConstant = new LinkedHashMap();
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.VOID, 1);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.BOOL, n);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.CHAR, n2);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.SCHAR, n2);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.UCHAR, n2);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.SHORT, n3);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.USHORT, n3);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.INT, n4);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.UINT, n4);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.LONG, n5);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.ULONG, n5);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.LONGLONG, n6);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.ULONGLONG, n6);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.DOUBLE, n8);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.FLOAT, n7);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.LONGDOUBLE, n9);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.COMPLEX_DOUBLE, n8 * 2);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.COMPLEX_FLOAT, n7 * 2);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.COMPLEX_LONGDOUBLE, n9 * 2);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.INT128, 16);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.UINT128, 16);
        this.mCPrimitiveToTypeSizeConstant.put(CPrimitive.CPrimitives.FLOAT128, 16);
    }

    public boolean useFixedTypeSizes() {
        return this.mUseFixedTypeSizes;
    }

    public Integer getSize(CPrimitive.CPrimitives cPrimitives) {
        Integer n = this.mCPrimitiveToTypeSizeConstant.get((Object)cPrimitives);
        if (n == null) {
            throw new IllegalArgumentException("unknown type " + String.valueOf((Object)cPrimitives));
        }
        return n;
    }

    public int getSizeOfPointer() {
        return this.mSizeOfPointerType;
    }

    public boolean isUnsigned(CPrimitive cPrimitive) {
        return this.isUnsigned(cPrimitive.getType());
    }

    public boolean isUnsigned(CPrimitive.CPrimitives cPrimitives) throws AssertionError {
        return switch (cPrimitives) {
            case CPrimitive.CPrimitives.UCHAR, CPrimitive.CPrimitives.USHORT, CPrimitive.CPrimitives.UINT, CPrimitive.CPrimitives.ULONG, CPrimitive.CPrimitives.ULONGLONG, CPrimitive.CPrimitives.UINT128, CPrimitive.CPrimitives.BOOL -> true;
            case CPrimitive.CPrimitives.CHAR -> {
                if (this.mSignednessOfChar == CACSLPreferenceInitializer.Signedness.UNSIGNED) {
                    yield true;
                }
                yield false;
            }
            case CPrimitive.CPrimitives.SCHAR, CPrimitive.CPrimitives.SHORT, CPrimitive.CPrimitives.INT, CPrimitive.CPrimitives.LONG, CPrimitive.CPrimitives.LONGLONG, CPrimitive.CPrimitives.INT128 -> false;
            case CPrimitive.CPrimitives.FLOAT, CPrimitive.CPrimitives.FLOAT128, CPrimitive.CPrimitives.COMPLEX_FLOAT, CPrimitive.CPrimitives.DOUBLE, CPrimitive.CPrimitives.COMPLEX_DOUBLE, CPrimitive.CPrimitives.LONGDOUBLE, CPrimitive.CPrimitives.COMPLEX_LONGDOUBLE, CPrimitive.CPrimitives.VOID -> throw new IllegalArgumentException("attribute signedness not applicable to " + String.valueOf((Object)cPrimitives));
            default -> throw new MatchException(null, null);
        };
    }

    public BigInteger getMaxValueOfPrimitiveType(CPrimitive cPrimitive) {
        int n = this.getSize(cPrimitive.getType());
        int n2 = this.isUnsigned(cPrimitive) ? n * 8 : n * 8 - 1;
        return BigInteger.TWO.pow(n2).subtract(BigInteger.ONE);
    }

    public BigInteger getMinValueOfPrimitiveType(CPrimitive cPrimitive) {
        if (this.isUnsigned(cPrimitive)) {
            return BigInteger.ZERO;
        }
        return BigInteger.TWO.pow(this.getSize(cPrimitive.getType()) * 8 - 1).negate();
    }

    public BigInteger getMaxValueOfPointer() {
        return BigInteger.TWO.pow(this.mSizeOfPointerType * 8).subtract(BigInteger.ONE);
    }

    public FloatingPointSize getFloatingPointSize(CPrimitive.CPrimitives cPrimitives) {
        int n = this.getSize(cPrimitives);
        switch (cPrimitives) {
            case FLOAT: {
                if (n != 4) {
                    throw new UnsupportedOperationException("unsupported sizeof " + String.valueOf((Object)cPrimitives) + "==" + n);
                }
                return new FloatingPointSize(n, 24, 8);
            }
            case DOUBLE: {
                if (n != 8) {
                    throw new UnsupportedOperationException("unsupported sizeof " + String.valueOf((Object)cPrimitives) + "==" + n);
                }
                return new FloatingPointSize(n, 53, 11);
            }
            case LONGDOUBLE: {
                if (n != 12 && n != 16) {
                    throw new UnsupportedOperationException("unsupported sizeof " + String.valueOf((Object)cPrimitives) + "==" + n);
                }
                return new FloatingPointSize(n, 113, 15);
            }
            case FLOAT128: {
                if (n != 16) {
                    throw new UnsupportedOperationException("unsupported sizeof " + String.valueOf((Object)cPrimitives) + "==" + n);
                }
                return new FloatingPointSize(n, 113, 15);
            }
        }
        throw new IllegalArgumentException("not real floating type " + String.valueOf((Object)cPrimitives));
    }

    public CPrimitive getCorrespondingUnsignedType(CPrimitive cPrimitive) {
        if (!cPrimitive.isIntegerType()) {
            throw new IllegalArgumentException("no integer type " + String.valueOf(this));
        }
        if (this.isUnsigned(cPrimitive)) {
            throw new IllegalArgumentException("already unsigned " + String.valueOf(this));
        }
        switch (cPrimitive.getType()) {
            case CHAR: {
                if (this.mSignednessOfChar == CACSLPreferenceInitializer.Signedness.SIGNED) {
                    return new CPrimitive(CPrimitive.CPrimitives.UCHAR);
                }
                throw new UnsupportedOperationException("according to your settings, char is already unsigned");
            }
            case INT: {
                return new CPrimitive(CPrimitive.CPrimitives.UINT);
            }
            case LONG: {
                return new CPrimitive(CPrimitive.CPrimitives.ULONG);
            }
            case LONGLONG: {
                return new CPrimitive(CPrimitive.CPrimitives.ULONGLONG);
            }
            case SCHAR: {
                return new CPrimitive(CPrimitive.CPrimitives.UCHAR);
            }
            case SHORT: {
                return new CPrimitive(CPrimitive.CPrimitives.USHORT);
            }
            case INT128: {
                return new CPrimitive(CPrimitive.CPrimitives.UINT128);
            }
        }
        throw new IllegalArgumentException("unsupported type " + String.valueOf(this));
    }

    public CACSLPreferenceInitializer.Signedness getSignednessOfChar() {
        return this.mSignednessOfChar;
    }

    public CPrimitive getSizeT() {
        return new CPrimitive(CPrimitive.CPrimitives.ULONG);
    }

    public CPrimitive getSsizeT() {
        return new CPrimitive(CPrimitive.CPrimitives.LONG);
    }

    public Expression constructLiteralForIntegerType(ILocation iLocation, CPrimitive cPrimitive, BigInteger bigInteger) {
        return ISOIEC9899TC3.constructLiteralForCIntegerLiteral(iLocation, this.mSettings.isBitvectorTranslation(), this, cPrimitive, bigInteger);
    }

    public BigInteger extractIntegerValue(RValue rValue) {
        return this.extractIntegerValue(rValue.getValue(), rValue.getCType().getUnderlyingType());
    }

    public BigInteger extractIntegerValue(Expression expression, ICType iCType) {
        if (expression instanceof IntegerLiteral) {
            BigInteger bigInteger = new BigInteger(((IntegerLiteral)expression).getValue());
            CPrimitive cPrimitive = (CPrimitive)CEnum.replaceEnumWithInt(iCType);
            if (!this.isUnsigned(cPrimitive)) {
                return bigInteger;
            }
            BigInteger bigInteger2 = this.getMaxValueOfPrimitiveType(cPrimitive);
            BigInteger bigInteger3 = bigInteger2.add(BigInteger.ONE);
            return bigInteger.mod(bigInteger3);
        }
        if (expression instanceof BitvecLiteral) {
            BigInteger bigInteger = new BigInteger(((BitvecLiteral)expression).getValue());
            CPrimitive cPrimitive = (CPrimitive)CEnum.replaceEnumWithInt(iCType);
            if (this.isUnsigned(cPrimitive)) {
                if (this.getMinValueOfPrimitiveType(cPrimitive).compareTo(bigInteger) > 0) {
                    throw new AssertionError((Object)("Value too small for type " + String.valueOf(iCType)));
                }
                if (this.getMaxValueOfPrimitiveType(cPrimitive).compareTo(bigInteger) < 0) {
                    throw new AssertionError((Object)("Value too large for type " + String.valueOf(iCType)));
                }
                return bigInteger;
            }
            int n = 8 * this.getSize(cPrimitive.getType());
            BitvectorConstant bitvectorConstant = new BitvectorConstant(bigInteger, BigInteger.valueOf(n));
            return bitvectorConstant.toSignedInt();
        }
        return null;
    }

    public static final class FloatingPointSize {
        private final int mSignificant;
        private final int mExponent;
        private final int mByteSize;

        public FloatingPointSize(int n, int n2, int n3) {
            this.mSignificant = n2;
            this.mExponent = n3;
            this.mByteSize = n;
        }

        public int getSignificant() {
            return this.mSignificant;
        }

        public int getExponent() {
            return this.mExponent;
        }

        public int getByteSize() {
            return this.mByteSize;
        }

        public int[] getIndices() {
            return new int[]{this.getExponent(), this.getSignificant()};
        }
    }
}

