/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.IRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Accepts;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Difference;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IStateDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmptyHeuristic;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.PowersetDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.IOpWithDelayedDeadEndRemoval;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.senwa.DifferenceSenwa;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IDeterminizeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISenwaStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISinkStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.IRunningTaskStackReceiver;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.TaskCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.results.DangerInvariantResult;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IncrementalHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IMLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.taskidentifier.SubtaskIterationIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.HoareAnnotationPositions;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.NwaFloydHoareValidityCheck;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.NwaHoareProofProducer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SMTFeatureExtractionTermClassifier;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.cfg2automaton.Cfg2Automaton;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.PathProgram;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.BasicCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopStatisticsDefinitions;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryRefinement;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryResultChecking;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.automataminimization.AutomataMinimization;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction.ErrorGeneralizationEngine;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.AbstractInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.PathInvariantsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.DangerInvariantGuesser;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TraceAbstractionPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.util.HistogramOfIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class NwaCegarLoop<L extends IIcfgTransition<?>>
extends BasicCegarLoop<L, INestedWordAutomaton<L, IPredicate>> {
    protected static final int MINIMIZE_EVERY_KTH_ITERATION = 10;
    protected static final boolean REMOVE_DEAD_ENDS = true;
    protected static final int MINIMIZATION_TIMEOUT = 1000;
    private static final int DEBUG_DANGER_INVARIANTS_THRESHOLD = Integer.MAX_VALUE;
    protected final Collection<INwaOutgoingLetterAndTransitionProvider<L, IPredicate>> mStoredRawInterpolantAutomata;
    private final IsEmpty.SearchStrategy mSearchStrategy;
    private final ErrorGeneralizationEngine<L> mErrorGeneralizationEngine;
    private final boolean mUseHeuristicEmptinessCheck;
    private final SMTFeatureExtractionTermClassifier.ScoringMethod mScoringMethod;
    private final IsEmptyHeuristic.AStarHeuristic mAStarHeuristic;
    private final Integer mAStarRandomHeuristicSeed;
    protected final NwaHoareProofProducer<L> mProofUpdater;

    public NwaCegarLoop(DebugIdentifier debugIdentifier, INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, IIcfg<?> iIcfg, CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, TAPreferences tAPreferences, Set<? extends IcfgLocation> set, NwaHoareProofProducer<L> nwaHoareProofProducer, IUltimateServiceProvider iUltimateServiceProvider, Class<L> clazz, PredicateFactoryRefinement predicateFactoryRefinement) {
        super(debugIdentifier, iNestedWordAutomaton, iIcfg, cfgSmtToolkit, predicateFactory, tAPreferences, set, nwaHoareProofProducer != null, iUltimateServiceProvider, clazz, predicateFactoryRefinement);
        this.mErrorGeneralizationEngine = new ErrorGeneralizationEngine(iUltimateServiceProvider);
        this.mProofUpdater = nwaHoareProofProducer;
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        this.mSearchStrategy = NwaCegarLoop.getSearchStrategy(iPreferenceProvider);
        this.mStoredRawInterpolantAutomata = NwaCegarLoop.checkStoreCounterExamples(this.mPref) ? new ArrayList() : null;
        this.mUseHeuristicEmptinessCheck = tAPreferences.useHeuristicEmptinessCheck();
        this.mScoringMethod = tAPreferences.getHeuristicEmptinessCheckScoringMethod();
        this.mAStarHeuristic = tAPreferences.getHeuristicEmptinessCheckAStarHeuristic();
        this.mAStarRandomHeuristicSeed = tAPreferences.getHeuristicEmptinessCheckAStarHeuristicRandomSeed();
    }

    @Override
    protected boolean isAbstractionEmpty() throws AutomataOperationCanceledException {
        INwaOutgoingLetterAndTransitionProvider iNwaOutgoingLetterAndTransitionProvider = (INwaOutgoingLetterAndTransitionProvider)this.mAbstraction;
        this.mCegarLoopBenchmark.start((Object)CegarLoopStatisticsDefinitions.EmptinessCheckTime);
        try {
            if (this.mUseHeuristicEmptinessCheck) {
                this.mCounterexample = new IsEmptyHeuristic(new AutomataLibraryServices(this.getServices()), iNwaOutgoingLetterAndTransitionProvider, IsEmptyHeuristic.IHeuristic.getHeuristic((IsEmptyHeuristic.AStarHeuristic)this.mAStarHeuristic, (SMTFeatureExtractionTermClassifier.ScoringMethod)this.mScoringMethod, (long)this.mAStarRandomHeuristicSeed.intValue())).getNestedRun();
                assert (this.checkIsEmptyHeuristic(iNwaOutgoingLetterAndTransitionProvider)) : "IsEmptyHeuristic did not match IsEmpty";
            } else {
                this.mCounterexample = new IsEmpty(new AutomataLibraryServices(this.getServices()), iNwaOutgoingLetterAndTransitionProvider, this.mSearchStrategy).getNestedRun();
            }
        }
        finally {
            this.mCegarLoopBenchmark.stop((Object)CegarLoopStatisticsDefinitions.EmptinessCheckTime);
        }
        if (this.mCounterexample == null) {
            return true;
        }
        if (this.mPref.dumpAutomata()) {
            this.mCegarLoopBenchmark.start((Object)CegarLoopStatisticsDefinitions.DumpTime);
            this.mDumper.dumpNestedRun(this.mCounterexample);
            this.mCegarLoopBenchmark.stop((Object)CegarLoopStatisticsDefinitions.DumpTime);
        }
        this.mLogger.info((Object)"Found error trace");
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)this.mCounterexample.getWord());
        }
        HistogramOfIterable histogramOfIterable = new HistogramOfIterable((Iterable)this.mCounterexample.getWord());
        this.mCegarLoopBenchmark.reportTraceHistogramMaximum(histogramOfIterable.getMax());
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("trace histogram " + histogramOfIterable.toString()));
        }
        if (histogramOfIterable.getMax() > Integer.MAX_VALUE) {
            this.checkForDangerInvariantAndReport();
        }
        if (this.mPref.hasLimitTraceHistogram() && histogramOfIterable.getMax() > this.mPref.getLimitTraceHistogram()) {
            String string = "bailout by trace histogram " + histogramOfIterable.toString() + " in iteration " + this.getIteration();
            throw new TaskCanceledException(TaskCanceledException.UserDefinedLimit.TRACE_HISTOGRAM, this.getClass(), string);
        }
        return false;
    }

    private boolean checkIsEmptyHeuristic(INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException {
        NestedRun nestedRun2 = (NestedRun)this.mCounterexample;
        NestedRun nestedRun3 = new IsEmpty(new AutomataLibraryServices(this.getServices()), iNwaOutgoingLetterAndTransitionProvider, this.mSearchStrategy).getNestedRun();
        Function<NestedRun, String> function = nestedRun -> nestedRun.getWord().asList().stream().map(iIcfgTransition -> "T" + iIcfgTransition.hashCode()).collect(Collectors.joining(" "));
        if (nestedRun2 == null && nestedRun3 == null) {
            return true;
        }
        if (nestedRun2 != null && nestedRun3 == null) {
            this.mLogger.fatal((Object)"IsEmptyHeuristic found a path but IsEmpty did not.");
            this.mLogger.fatal((Object)("IsEmptyHeuristic: " + function.apply(nestedRun2)));
            return false;
        }
        if (nestedRun2 == null && nestedRun3 != null) {
            this.mLogger.fatal((Object)"IsEmptyHeuristic found no path but IsEmpty did.");
            this.mLogger.fatal((Object)("IsEmpty         : " + function.apply(nestedRun3)));
            return false;
        }
        if (nestedRun2 != null && nestedRun3 != null) {
            if (!NestedRun.isEqual((NestedRun)nestedRun2, (NestedRun)nestedRun3)) {
                if (nestedRun2.getLength() > nestedRun3.getLength()) {
                    this.mLogger.warn((Object)"IsEmptyHeuristic and IsEmpty found a path, but isEmptyHeuristic was longer!");
                } else {
                    this.mLogger.info((Object)"IsEmptyHeuristic and IsEmpty found a path, but they differ");
                }
                this.mLogger.info((Object)("IsEmptyHeuristic: " + function.apply(nestedRun2)));
                this.mLogger.info((Object)("IsEmpty         : " + function.apply(nestedRun3)));
            }
            return true;
        }
        this.mLogger.fatal((Object)"Should not happen");
        return false;
    }

    private boolean checkForDangerInvariantAndReport() {
        List<IcfgLocation> list = this.getIcfgLocationsFromRun(this.mCounterexample);
        Set<IcfgEdge> set = PathInvariantsGenerator.extractTransitionsFromRun((NestedWord<? extends IAction>)((NestedWord)this.mCounterexample.getWord()), list, this.mIcfg.getCfgSmtToolkit().getIcfgEdgeFactory());
        PathProgram.PathProgramConstructionResult pathProgramConstructionResult = PathProgram.constructPathProgram((String)"PathInvariantsPathProgram", (IIcfg)this.mIcfg, set, Collections.emptySet(), icfgLocation -> true);
        PathProgram pathProgram = pathProgramConstructionResult.getPathProgram();
        PredicateFactory predicateFactory = this.mPredicateFactory;
        PredicateUnifier predicateUnifier = new PredicateUnifier(this.mLogger, this.getServices(), this.mCsToolkit.getManagedScript(), (BasicPredicateFactory)predicateFactory, this.mCsToolkit.getSymbolTable(), SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, new IPredicate[0]);
        IPredicate iPredicate = predicateUnifier.getTruePredicate();
        DangerInvariantGuesser dangerInvariantGuesser = new DangerInvariantGuesser((IIcfg<IcfgLocation>)pathProgram, this.getServices(), iPredicate, predicateFactory, (IPredicateUnifier)predicateUnifier, this.mCsToolkit);
        boolean bl = dangerInvariantGuesser.isDangerInvariant();
        if (bl) {
            Map<IcfgLocation, IPredicate> map = dangerInvariantGuesser.getCandidateInvariant();
            Map<IcfgLocation, Term> map2 = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((IPredicate)entry.getValue()).getFormula()));
            Set set2 = IcfgUtils.getErrorLocations((IIcfg)pathProgram);
            DangerInvariantResult dangerInvariantResult = new DangerInvariantResult(Activator.PLUGIN_ID, map2, set2, this.getServices().getBacktranslationService());
            this.getServices().getResultService().reportResult(Activator.PLUGIN_ID, (IResult)dangerInvariantResult);
        }
        return bl;
    }

    @Override
    protected void constructErrorAutomaton() throws AutomataOperationCanceledException {
        this.mErrorGeneralizationEngine.constructErrorAutomaton(this.mCounterexample, this.mPredicateFactory, this.mRefinementResult.getPredicateUnifier(), this.mCsToolkit, this.mSimplificationTechnique, this.mIcfg.getCfgSmtToolkit().getSymbolTable(), this.mPredicateFactoryInterpolantAutomata, (INestedWordAutomaton)this.mAbstraction, this.getIteration());
        this.mInterpolAutomaton = null;
        NestedWordAutomaton<L, IPredicate> nestedWordAutomaton = this.mErrorGeneralizationEngine.getResultBeforeEnhancement();
        assert (NwaCegarLoop.isInterpolantAutomatonOfSingleStateType(nestedWordAutomaton));
        assert (this.accepts(this.getServices(), nestedWordAutomaton, this.mCounterexample.getWord(), false)) : "Error automaton broken!";
    }

    @Override
    protected boolean refineAbstraction() throws AutomataLibraryException {
        INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider;
        NestedWordAutomaton<L, IPredicate> nestedWordAutomaton;
        TAPreferences.InterpolantAutomatonEnhancement interpolantAutomatonEnhancement;
        boolean bl;
        boolean bl2;
        AutomatonType automatonType;
        this.mStateFactoryForRefinement.setIteration(this.getIteration());
        this.mCegarLoopBenchmark.start(CegarLoopStatisticsDefinitions.AutomataDifference.toString());
        INestedWordAutomaton iNestedWordAutomaton = (INestedWordAutomaton)this.mAbstraction;
        IPredicateUnifier iPredicateUnifier = this.mRefinementResult.getPredicateUnifier();
        IHoareTripleChecker iHoareTripleChecker = this.getHoareTripleChecker();
        if (this.mErrorGeneralizationEngine.hasAutomatonInIteration(this.getIteration())) {
            this.mErrorGeneralizationEngine.startDifference();
            automatonType = AutomatonType.ERROR;
            bl2 = true;
            bl = false;
            interpolantAutomatonEnhancement = this.mErrorGeneralizationEngine.getEnhancementMode();
            nestedWordAutomaton = this.mErrorGeneralizationEngine.getResultBeforeEnhancement();
            iNwaOutgoingLetterAndTransitionProvider = this.mErrorGeneralizationEngine.getResultAfterEnhancement();
        } else {
            automatonType = AutomatonType.FLOYD_HOARE;
            bl2 = false;
            bl = this.mProofUpdater == null || this.mProofUpdater.exploitSigmaStarConcatOfIa();
            nestedWordAutomaton = this.mInterpolAutomaton;
            interpolantAutomatonEnhancement = this.mPref.interpolantAutomatonEnhancement();
            iNwaOutgoingLetterAndTransitionProvider = this.enhanceInterpolantAutomaton(interpolantAutomatonEnhancement, iPredicateUnifier, iHoareTripleChecker, nestedWordAutomaton);
        }
        this.computeAutomataDifference((INestedWordAutomaton<L, IPredicate>)iNestedWordAutomaton, iNwaOutgoingLetterAndTransitionProvider, (INwaOutgoingLetterAndTransitionProvider<L, IPredicate>)nestedWordAutomaton, iPredicateUnifier, bl, iHoareTripleChecker, interpolantAutomatonEnhancement, bl2, automatonType);
        this.minimizeAbstractionIfEnabled();
        boolean bl3 = new Accepts(new AutomataLibraryServices(this.getServices()), (INwaOutgoingLetterAndTransitionProvider)this.mAbstraction, (NestedWord)this.mCounterexample.getWord()).getResult();
        return !bl3;
    }

    private void computeAutomataDifference(INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider2, IPredicateUnifier iPredicateUnifier, boolean bl, IHoareTripleChecker iHoareTripleChecker, TAPreferences.InterpolantAutomatonEnhancement interpolantAutomatonEnhancement, boolean bl2, AutomatonType automatonType) throws AutomataLibraryException, AssertionError {
        try {
            String string;
            Object object;
            this.mLogger.debug((Object)"Start constructing difference");
            PowersetDeterminizer powersetDeterminizer = new PowersetDeterminizer(iNwaOutgoingLetterAndTransitionProvider, true, (IDeterminizeStateFactory)this.mPredicateFactoryInterpolantAutomata);
            try {
                try {
                    object = this.mPref.differenceSenwa() ? new DifferenceSenwa(new AutomataLibraryServices(this.getServices()), (ISenwaStateFactory)this.mStateFactoryForRefinement, iNestedWordAutomaton, iNwaOutgoingLetterAndTransitionProvider, (IStateDeterminizer)powersetDeterminizer, false) : new Difference(new AutomataLibraryServices(this.getServices()), (ISinkStateFactory)this.mStateFactoryForRefinement, iNestedWordAutomaton, iNwaOutgoingLetterAndTransitionProvider, (IStateDeterminizer)powersetDeterminizer, bl);
                    this.mCegarLoopBenchmark.reportInterpolantAutomatonStates(iNwaOutgoingLetterAndTransitionProvider.size());
                }
                catch (AutomataOperationCanceledException | ToolchainCanceledException throwable) {
                    RunningTaskInfo runningTaskInfo = this.executeDifferenceTimeoutActions(iNestedWordAutomaton, iNwaOutgoingLetterAndTransitionProvider, iNwaOutgoingLetterAndTransitionProvider2, automatonType);
                    ((IRunningTaskStackReceiver)throwable).addRunningTaskInfo(runningTaskInfo);
                    throw throwable;
                }
            }
            finally {
                if (interpolantAutomatonEnhancement != TAPreferences.InterpolantAutomatonEnhancement.NONE) {
                    assert (iNwaOutgoingLetterAndTransitionProvider instanceof AbstractInterpolantAutomaton) : "if enhancement is used, we need AbstractInterpolantAutomaton";
                    ((AbstractInterpolantAutomaton)iNwaOutgoingLetterAndTransitionProvider).switchToReadonlyMode();
                }
            }
            if (this.mErrorGeneralizationEngine.hasAutomatonInIteration(this.getIteration())) {
                this.mErrorGeneralizationEngine.stopDifference(iNestedWordAutomaton, this.mPredicateFactoryInterpolantAutomata, this.mPredicateFactoryResultChecking, this.mCounterexample, false);
                if (this.mFaultLocalizationMode != TraceAbstractionPreferenceInitializer.RelevanceAnalysisMode.NONE) {
                    string = Cfg2Automaton.constructAutomatonWithSPredicates((IUltimateServiceProvider)this.getServices(), (IIcfg)this.mIcfg, (IEmptyStackStateFactory)this.mStateFactoryForRefinement, (Collection)this.mErrorLocs, (boolean)this.mPref.interprocedural(), (PredicateFactory)this.mPredicateFactory);
                    this.mErrorGeneralizationEngine.faultLocalizationWithStorage((INestedWordAutomaton<L, IPredicate>)string, this.mCsToolkit, this.mPredicateFactory, this.mRefinementResult.getPredicateUnifier(), this.mSimplificationTechnique, this.mIcfg.getCfgSmtToolkit().getSymbolTable(), null, (NestedRun<L, IPredicate>)((NestedRun)this.mCounterexample), (IIcfg<IcfgLocation>)this.mIcfg);
                }
            }
            if (this.mPref.dumpAutomata()) {
                string = String.valueOf(new SubtaskIterationIdentifier(this.mTaskIdentifier, this.getIteration())) + "AbstractionAfterDifference";
                super.writeAutomatonToFile(iNwaOutgoingLetterAndTransitionProvider, string);
            }
            this.dumpOrAppendAutomatonForReuseIfEnabled(iNwaOutgoingLetterAndTransitionProvider, iPredicateUnifier);
            if (!bl2) {
                this.checkEnhancement(iNwaOutgoingLetterAndTransitionProvider2, iNwaOutgoingLetterAndTransitionProvider);
            }
            if (this.mProofUpdater != null) {
                string = (Difference)object;
                this.mProofUpdater.updateOnIntersection(string.getFst2snd2res(), string.getResult());
            }
            object.removeDeadEnds();
            if (this.mProofUpdater != null) {
                this.mProofUpdater.addDeadEndDoubleDeckers((IOpWithDelayedDeadEndRemoval)object);
            }
            this.mAbstraction = object.getResult();
            if (this.mPref.dumpAutomata()) {
                string = String.valueOf(new SubtaskIterationIdentifier(this.mTaskIdentifier, this.getIteration())) + "AbstractionAfterDifferenceAndDeadEndRemoval";
                super.writeAutomatonToFile(this.mAbstraction, string);
            }
        }
        finally {
            this.mLogger.info((Object)iPredicateUnifier.collectPredicateUnifierStatistics());
            this.mLogger.info((Object)iHoareTripleChecker.getStatistics());
            this.mLogger.info((Object)iHoareTripleChecker);
            this.mCegarLoopBenchmark.addEdgeCheckerData(iHoareTripleChecker.getStatistics());
            this.mCegarLoopBenchmark.addPredicateUnifierData(iPredicateUnifier.getPredicateUnifierBenchmark());
            this.mCegarLoopBenchmark.stop(CegarLoopStatisticsDefinitions.AutomataDifference.toString());
        }
    }

    @Override
    protected void performAbstractionSanityCheck() {
        if (this.mProofUpdater != null && this.mPref.getHoareAnnotationPositions() == HoareAnnotationPositions.All) {
            PredicateUnifier predicateUnifier = new PredicateUnifier(this.mLogger, this.mServices, this.mCsToolkit.getManagedScript(), (BasicPredicateFactory)this.mPredicateFactory, this.mCsToolkit.getSymbolTable(), this.mSimplificationTechnique, new IPredicate[0]);
            assert (NwaFloydHoareValidityCheck.forInterpolantAutomaton((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mCsToolkit.getManagedScript(), (IHoareTripleChecker)new IncrementalHoareTripleChecker(this.mCsToolkit, false), (IPredicateUnifier)predicateUnifier, (INestedWordAutomaton)((INestedWordAutomaton)this.mAbstraction), (boolean)true).getResult()) : "Not inductive";
        }
    }

    private RunningTaskInfo executeDifferenceTimeoutActions(INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider2, AutomatonType automatonType) throws AutomataLibraryException {
        RunningTaskInfo runningTaskInfo = this.getDifferenceTimeoutRunningTaskInfo(iNestedWordAutomaton, iNwaOutgoingLetterAndTransitionProvider, iNwaOutgoingLetterAndTransitionProvider2, automatonType);
        if (this.mErrorGeneralizationEngine.hasAutomatonInIteration(this.getIteration())) {
            this.mErrorGeneralizationEngine.stopDifference(iNestedWordAutomaton, this.mPredicateFactoryInterpolantAutomata, this.mPredicateFactoryResultChecking, this.mCounterexample, true);
        }
        return runningTaskInfo;
    }

    private RunningTaskInfo getDifferenceTimeoutRunningTaskInfo(INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider2, AutomatonType automatonType) {
        String string = "constructing difference of abstraction (" + iNestedWordAutomaton.size() + "states) and " + String.valueOf((Object)automatonType) + " automaton (currently " + iNwaOutgoingLetterAndTransitionProvider.size() + " states, " + iNwaOutgoingLetterAndTransitionProvider2.size() + " states before enhancement)";
        return new RunningTaskInfo(this.getClass(), string);
    }

    protected void minimizeAbstractionIfEnabled() throws AutomataOperationCanceledException, AutomataLibraryException, AssertionError {
        TraceAbstractionPreferenceInitializer.Minimization minimization = this.mPref.getMinimization();
        switch (minimization) {
            case NONE: {
                break;
            }
            case MINIMIZE_SEVPA: 
            case SHRINK_NWA: 
            case DFA_HOPCROFT_ARRAYS: 
            case DFA_HOPCROFT_LISTS: 
            case NWA_MAX_SAT: 
            case NWA_MAX_SAT2: 
            case NWA_COMBINATOR_PATTERN: 
            case NWA_COMBINATOR_EVERY_KTH: 
            case RAQ_DIRECT_SIMULATION: 
            case RAQ_DIRECT_SIMULATION_B: 
            case NWA_OVERAPPROXIMATION: 
            case NWA_COMBINATOR_MULTI_DEFAULT: 
            case NWA_COMBINATOR_MULTI_SIMULATION: {
                this.minimizeAbstraction(this.mStateFactoryForRefinement, this.mPredicateFactoryResultChecking, minimization);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    protected void minimizeAbstraction(PredicateFactoryRefinement predicateFactoryRefinement, PredicateFactoryResultChecking predicateFactoryResultChecking, TraceAbstractionPreferenceInitializer.Minimization minimization) throws AutomataOperationCanceledException, AutomataLibraryException, AssertionError {
        AutomataMinimization automataMinimization;
        boolean bl;
        try {
            bl = this.mProofUpdater != null;
            automataMinimization = new AutomataMinimization(this.getServices(), (INestedWordAutomaton)this.mAbstraction, minimization, bl, this.getIteration(), predicateFactoryRefinement, 10, this.mStoredRawInterpolantAutomata, this.mInterpolAutomaton, 1000, predicateFactoryResultChecking, PredicateUtils::getLocations, true);
        }
        catch (AutomataMinimization.AutomataMinimizationTimeout automataMinimizationTimeout) {
            this.mCegarLoopBenchmark.addAutomataMinimizationData(automataMinimizationTimeout.getStatistics());
            throw automataMinimizationTimeout.getAutomataOperationCanceledException();
        }
        this.mCegarLoopBenchmark.addAutomataMinimizationData(automataMinimization.getStatistics());
        bl = automataMinimization.newAutomatonWasBuilt();
        if (bl) {
            IDoubleDeckerAutomaton iDoubleDeckerAutomaton = automataMinimization.getMinimizedAutomaton();
            if (this.mProofUpdater != null) {
                Map<IPredicate, IPredicate> map = automataMinimization.getOldState2newStateMapping();
                if (map == null) {
                    throw new AssertionError((Object)("Proof production and " + String.valueOf((Object)minimization) + " incompatible"));
                }
                this.mProofUpdater.updateOnMinimization(map, iDoubleDeckerAutomaton);
            }
            int n = ((INestedWordAutomaton)this.mAbstraction).size();
            int n2 = iDoubleDeckerAutomaton.size();
            assert (n == 0 || n >= n2) : "Minimization increased state space";
            this.mAbstraction = iDoubleDeckerAutomaton;
        }
    }

    @Override
    protected void finish() {
        if (this.mProofUpdater != null) {
            this.mProofUpdater.finish((INestedWordAutomaton)this.mAbstraction);
        }
        this.mErrorGeneralizationEngine.reportErrorGeneralizationBenchmarks();
        super.finish();
    }

    private static final boolean checkStoreCounterExamples(TAPreferences tAPreferences) {
        return tAPreferences.getMinimization() == TraceAbstractionPreferenceInitializer.Minimization.NWA_OVERAPPROXIMATION;
    }

    private static IsEmpty.SearchStrategy getSearchStrategy(IPreferenceProvider iPreferenceProvider) {
        return switch ((TraceAbstractionPreferenceInitializer.CounterexampleSearchStrategy)iPreferenceProvider.getEnum("Counterexample search strategy", TraceAbstractionPreferenceInitializer.CounterexampleSearchStrategy.class)) {
            case TraceAbstractionPreferenceInitializer.CounterexampleSearchStrategy.BFS -> IsEmpty.SearchStrategy.BFS;
            case TraceAbstractionPreferenceInitializer.CounterexampleSearchStrategy.DFS -> IsEmpty.SearchStrategy.DFS;
            default -> throw new MatchException(null, null);
        };
    }

    @Override
    protected List<?> getControlConfigurationsFromCounterexample(IRun<L, ?> iRun) {
        if (IcfgUtils.isConcurrent((IIcfg)this.mIcfg)) {
            return iRun.getStateSequence().stream().map(object -> ((IMLPredicate)object).getProgramPoints()).collect(Collectors.toList());
        }
        return this.getIcfgLocationsFromRun(iRun);
    }

    private List<IcfgLocation> getIcfgLocationsFromRun(IRun<L, ?> iRun) {
        return iRun.getStateSequence().stream().map(object -> ((ISLPredicate)object).getProgramPoint()).collect(Collectors.toList());
    }

    private static enum AutomatonType {
        FLOYD_HOARE,
        ERROR;

    }
}

