/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import jakarta.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class ContributedPartRenderer
extends SWTPartRenderer {
    @Inject
    private IPresentationEngine engine;
    @Inject
    @Optional
    private Logger logger;
    private MPart partToActivate;
    private Listener activationListener = event -> {
        MPart part = (MPart)event.widget.getData("modelElement");
        if (part != null) {
            try {
                this.partToActivate = part;
                this.activate(this.partToActivate);
            }
            finally {
                this.partToActivate = null;
            }
        }
    };

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MPart) || !(parent instanceof Composite)) {
            return null;
        }
        final MPart part = (MPart)element;
        IEclipseContext localContext = part.getContext();
        Widget parentWidget = (Widget)parent;
        Composite partComposite = (Composite)localContext.getLocal(Composite.class);
        if (partComposite == null) {
            Composite newComposite = new Composite((Composite)parentWidget, 0){
                private boolean beingFocused;
                {
                    super($anonymous0, $anonymous1);
                    this.beingFocused = false;
                }

                public boolean setFocus() {
                    if (!this.beingFocused) {
                        try {
                            this.beingFocused = true;
                            Object object = part.getObject();
                            if (object != null && this.isEnabled()) {
                                IPresentationEngine pe = (IPresentationEngine)part.getContext().get(IPresentationEngine.class);
                                pe.focusGui((MUIElement)part);
                                return true;
                            }
                            boolean bl = super.setFocus();
                            return bl;
                        }
                        finally {
                            this.beingFocused = false;
                        }
                    }
                    return true;
                }
            };
            newComposite.setLayout((Layout)new FillLayout(512));
            partComposite = newComposite;
        }
        this.bindWidget(element, partComposite);
        localContext.set(Composite.class, (Object)partComposite);
        IContributionFactory contributionFactory = (IContributionFactory)localContext.get(IContributionFactory.class);
        Object newPart = contributionFactory.create(part.getContributionURI(), localContext);
        part.setObject(newPart);
        return partComposite;
    }

    public void postProcess(MUIElement element) {
        super.postProcess(element);
        if (!(element instanceof MPart)) {
            return;
        }
        MToolBar toolbar = ((MPart)element).getToolbar();
        if (toolbar != null) {
            this.engine.createGui((MUIElement)toolbar);
        }
    }

    public static void setDescription(MPart part, String description) {
        if (!(part.getWidget() instanceof Composite)) {
            return;
        }
        Composite c = (Composite)part.getWidget();
        if (c.getChildren().length == 3) {
            Label label = (Label)c.getChildren()[0];
            if (description == null) {
                description = "";
            }
            boolean hasText = !description.isEmpty();
            label.setVisible(hasText);
            label.setText(description);
            label.setToolTipText(description);
            c.getChildren()[1].setVisible(hasText);
            c.layout();
        } else if (c.getChildren().length == 1) {
            c.setLayout(new Layout(){

                protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                    return new Point(0, 0);
                }

                protected void layout(Composite composite, boolean flushCache) {
                    Rectangle bounds = composite.getBounds();
                    if (composite.getChildren().length == 1) {
                        composite.getChildren()[0].setBounds(composite.getBounds());
                    } else if (composite.getChildren().length == 3) {
                        Label label = (Label)composite.getChildren()[0];
                        Label separator = (Label)composite.getChildren()[1];
                        Control partCtrl = composite.getChildren()[2];
                        int labelHeight = !label.getText().isEmpty() ? label.computeSize((int)bounds.width, (int)-1).y : 0;
                        label.setBounds(0, 0, bounds.width, labelHeight);
                        int separatorHeight = labelHeight > 0 ? separator.computeSize((int)bounds.width, (int)-1).y : 0;
                        separator.setBounds(0, labelHeight, bounds.width, separatorHeight);
                        partCtrl.setBounds(0, labelHeight + separatorHeight, bounds.width, bounds.height - labelHeight - separatorHeight);
                    }
                }
            });
            Label separator = new Label(c, 258);
            separator.moveAbove(null);
            Label label = new Label(c, 0);
            label.setText(description);
            label.setToolTipText(description);
            label.moveAbove(null);
            c.layout();
        }
    }

    @Override
    protected boolean requiresFocus(MPart element) {
        if (element == this.partToActivate) {
            return true;
        }
        return super.requiresFocus(element);
    }

    @Override
    public void hookControllerLogic(MUIElement me) {
        super.hookControllerLogic(me);
        if (!(me instanceof MPart)) {
            return;
        }
        Widget widget = (Widget)me.getWidget();
        if (widget instanceof Composite) {
            widget.addListener(26, this.activationListener);
        }
    }

    public Object getUIContainer(MUIElement element) {
        if (element instanceof MToolBar) {
            MElementContainer parent;
            Object widget;
            MUIElement container = this.modelService.getContainer(element);
            if (container.getCurSharedRef() != null) {
                container = container.getCurSharedRef();
            }
            if ((widget = (parent = container.getParent()).getWidget()) instanceof CTabFolder) {
                return ((CTabFolder)widget).getTopRight();
            }
            return widget;
        }
        return super.getUIContainer(element);
    }

    @Override
    public void disposeWidget(MUIElement element) {
        if (element instanceof MPart) {
            MPart part = (MPart)element;
            MToolBar toolBar = part.getToolbar();
            if (toolBar != null) {
                this.engine.removeGui((MUIElement)toolBar);
            }
            for (MMenu menu : part.getMenus()) {
                this.engine.removeGui((MUIElement)menu);
            }
        }
        Composite parent = null;
        if (element.getWidget() instanceof Composite) {
            parent = ((Composite)element.getWidget()).getParent();
        }
        if (parent != null) {
            try {
                parent.setRedraw(false);
                super.disposeWidget(element);
            }
            finally {
                parent.setRedraw(true);
            }
        } else {
            super.disposeWidget(element);
        }
    }
}

