/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.IAxis;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.ref.Histogram;

abstract class AbstractHistogram3D
extends Histogram
implements IHistogram3D {
    protected IAxis xAxis;
    protected IAxis yAxis;
    protected IAxis zAxis;

    AbstractHistogram3D(String string) {
        super(string);
    }

    public int allEntries() {
        int n = 0;
        int n2 = this.xAxis.bins();
        while (--n2 >= -2) {
            int n3 = this.yAxis.bins();
            while (--n3 >= -2) {
                int n4 = this.zAxis.bins();
                while (--n4 >= -2) {
                    n += this.binEntries(n2, n3, n4);
                }
            }
        }
        return n;
    }

    public int dimensions() {
        return 3;
    }

    public int entries() {
        int n = 0;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            for (int j = 0; j < this.yAxis.bins(); ++j) {
                for (int k = 0; k < this.zAxis.bins(); ++k) {
                    n += this.binEntries(i, j, k);
                }
            }
        }
        return n;
    }

    public int extraEntries() {
        return this.allEntries() - this.entries();
    }

    public void fill(double d, double d2, double d3) {
        this.fill(d, d2, d3, 1.0);
    }

    protected abstract IHistogram2D internalSliceXY(String var1, int var2, int var3);

    protected abstract IHistogram2D internalSliceXZ(String var1, int var2, int var3);

    protected abstract IHistogram2D internalSliceYZ(String var1, int var2, int var3);

    int mapX(int n) {
        int n2 = this.xAxis.bins() + 2;
        if (n >= n2) {
            throw new IllegalArgumentException("bin=" + n);
        }
        if (n >= 0) {
            return n + 1;
        }
        if (n == -2) {
            return 0;
        }
        if (n == -1) {
            return n2 - 1;
        }
        throw new IllegalArgumentException("bin=" + n);
    }

    int mapY(int n) {
        int n2 = this.yAxis.bins() + 2;
        if (n >= n2) {
            throw new IllegalArgumentException("bin=" + n);
        }
        if (n >= 0) {
            return n + 1;
        }
        if (n == -2) {
            return 0;
        }
        if (n == -1) {
            return n2 - 1;
        }
        throw new IllegalArgumentException("bin=" + n);
    }

    int mapZ(int n) {
        int n2 = this.zAxis.bins() + 2;
        if (n >= n2) {
            throw new IllegalArgumentException("bin=" + n);
        }
        if (n >= 0) {
            return n + 1;
        }
        if (n == -2) {
            return 0;
        }
        if (n == -1) {
            return n2 - 1;
        }
        throw new IllegalArgumentException("bin=" + n);
    }

    public int[] minMaxBins() {
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = this.xAxis.bins();
        while (--n7 >= 0) {
            int n8 = this.yAxis.bins();
            while (--n8 >= 0) {
                int n9 = this.zAxis.bins();
                while (--n9 >= 0) {
                    double d3 = this.binHeight(n7, n8, n9);
                    if (d3 < d) {
                        d = d3;
                        n = n7;
                        n2 = n8;
                        n3 = n9;
                    }
                    if (!(d3 > d2)) continue;
                    d2 = d3;
                    n4 = n7;
                    n5 = n8;
                    n6 = n9;
                }
            }
        }
        int[] nArray = new int[]{n, n2, n3, n4, n5, n6};
        return nArray;
    }

    public IHistogram2D projectionXY() {
        String string = this.title() + " (projectionXY)";
        return this.internalSliceXY(string, this.mapZ(-2), this.mapZ(-1));
    }

    public IHistogram2D projectionXZ() {
        String string = this.title() + " (projectionXZ)";
        return this.internalSliceXZ(string, this.mapY(-2), this.mapY(-1));
    }

    public IHistogram2D projectionYZ() {
        String string = this.title() + " (projectionYZ)";
        return this.internalSliceYZ(string, this.mapX(-2), this.mapX(-1));
    }

    public IHistogram2D sliceXY(int n) {
        return this.sliceXY(n, n);
    }

    public IHistogram2D sliceXY(int n, int n2) {
        int n3 = this.mapZ(n);
        int n4 = this.mapZ(n2);
        String string = this.title() + " (sliceXY [" + n + ":" + n2 + "])";
        return this.internalSliceXY(string, n3, n4);
    }

    public IHistogram2D sliceXZ(int n) {
        return this.sliceXZ(n, n);
    }

    public IHistogram2D sliceXZ(int n, int n2) {
        int n3 = this.mapY(n);
        int n4 = this.mapY(n2);
        String string = this.title() + " (sliceXZ [" + n + ":" + n2 + "])";
        return this.internalSliceXY(string, n3, n4);
    }

    public IHistogram2D sliceYZ(int n) {
        return this.sliceYZ(n, n);
    }

    public IHistogram2D sliceYZ(int n, int n2) {
        int n3 = this.mapX(n);
        int n4 = this.mapX(n2);
        String string = this.title() + " (sliceYZ [" + n + ":" + n2 + "])";
        return this.internalSliceYZ(string, n3, n4);
    }

    public double sumAllBinHeights() {
        double d = 0.0;
        int n = this.xAxis.bins();
        while (--n >= -2) {
            int n2 = this.yAxis.bins();
            while (--n2 >= -2) {
                int n3 = this.zAxis.bins();
                while (--n3 >= -2) {
                    d += this.binHeight(n, n2, n3);
                }
            }
        }
        return d;
    }

    public double sumBinHeights() {
        double d = 0.0;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            for (int j = 0; j < this.yAxis.bins(); ++j) {
                for (int k = 0; k < this.zAxis.bins(); ++k) {
                    d += this.binHeight(i, j, k);
                }
            }
        }
        return d;
    }

    public double sumExtraBinHeights() {
        return this.sumAllBinHeights() - this.sumBinHeights();
    }

    public IAxis xAxis() {
        return this.xAxis;
    }

    public IAxis yAxis() {
        return this.yAxis;
    }

    public IAxis zAxis() {
        return this.zAxis;
    }
}

