/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDecker;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DoubleDeckerVisitor;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class HasUnreachableStates<LETTER, STATE>
extends DoubleDeckerVisitor<LETTER, STATE>
implements IOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final Set<STATE> mVisitedStates = new HashSet<STATE>();
    private int mUnreachableStates;

    public HasUnreachableStates(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mTraversedNwa = iNestedWordAutomaton;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.traverseDoubleDeckerGraph();
        for (Object STATE : this.mTraversedNwa.getStates()) {
            if (this.mVisitedStates.contains(STATE)) continue;
            ++this.mUnreachableStates;
            if (!this.mLogger.isWarnEnabled()) continue;
            this.mLogger.warn((Object)("Unreachable state: " + String.valueOf(STATE)));
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    protected Collection<STATE> getInitialStates() {
        this.mVisitedStates.addAll((Collection<STATE>)this.mTraversedNwa.getInitialStates());
        return this.mTraversedNwa.getInitialStates();
    }

    @Override
    protected Collection<STATE> visitAndGetInternalSuccessors(DoubleDecker<STATE> doubleDecker) {
        STATE STATE = doubleDecker.getUp();
        HashSet<STATE> hashSet = new HashSet<STATE>();
        for (Object LETTER : this.mTraversedNwa.lettersInternal(STATE)) {
            for (OutgoingInternalTransition outgoingInternalTransition : this.mTraversedNwa.internalSuccessors(STATE, LETTER)) {
                hashSet.add(outgoingInternalTransition.getSucc());
            }
        }
        this.mVisitedStates.addAll(hashSet);
        return hashSet;
    }

    @Override
    protected Collection<STATE> visitAndGetCallSuccessors(DoubleDecker<STATE> doubleDecker) {
        STATE STATE = doubleDecker.getUp();
        HashSet<STATE> hashSet = new HashSet<STATE>();
        for (Object LETTER : this.mTraversedNwa.lettersCall(STATE)) {
            for (OutgoingCallTransition outgoingCallTransition : this.mTraversedNwa.callSuccessors(STATE, LETTER)) {
                hashSet.add(outgoingCallTransition.getSucc());
            }
        }
        this.mVisitedStates.addAll(hashSet);
        return hashSet;
    }

    @Override
    protected Collection<STATE> visitAndGetReturnSuccessors(DoubleDecker<STATE> doubleDecker) {
        STATE STATE = doubleDecker.getUp();
        STATE STATE2 = doubleDecker.getDown();
        HashSet<STATE> hashSet = new HashSet<STATE>();
        for (OutgoingReturnTransition outgoingReturnTransition : this.mTraversedNwa.returnSuccessorsGivenHier(STATE, STATE2)) {
            hashSet.add(outgoingReturnTransition.getSucc());
        }
        this.mVisitedStates.addAll(hashSet);
        return hashSet;
    }

    @Override
    public String startMessage() {
        return "Start " + this.getOperationName() + " Operand " + this.mTraversedNwa.sizeInformation();
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + " Operand has " + this.mUnreachableStates + " unreachable states";
    }

    @Override
    public Boolean getResult() {
        if (this.mUnreachableStates != 0) {
            return true;
        }
        return false;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }
}

